/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client;

import com.google.api.services.containeranalysis.v1beta1.model.Occurrence;
import com.google.cloud.graphite.platforms.plugin.client.ContainerAnalysisWrapper;
import com.google.cloud.graphite.platforms.plugin.client.util.ClientUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;

public class ContainerAnalysisClient {
    private static final Logger log = Logger.getLogger(ContainerAnalysisClient.class.getName());
    private static final String VULNERABILITY_NOTE_PROJECT_ID = "goog-analysis";
    private static final String VULNERABILITY_NOTE_ID = "PACKAGE_VULNERABILITY";
    private static final String VULNERABILITY_KIND = "VULNERABILITY";
    private static final List<String> FINISHED_STATUSES = ImmutableList.of((Object)"FINISHED_SUCCESS", (Object)"FINISHED_FAILED", (Object)"FINISHED_UNSUPPORTED");
    private static final long POLL_INTERVAL_MS = 1000L;
    private ContainerAnalysisWrapper containerAnalysis;

    ContainerAnalysisClient(ContainerAnalysisWrapper containerAnalysis) {
        this.containerAnalysis = containerAnalysis;
    }

    public String getVulnerabilityScanStatusSync(String projectId, String resourceUrl, long timeoutMillis) throws ConditionTimeoutException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resourceUrl) ? 1 : 0) != 0);
        Preconditions.checkArgument((timeoutMillis >= 0L ? 1 : 0) != 0);
        long start = System.currentTimeMillis();
        Occurrence statusOccurrence = (Occurrence)((Optional)Awaitility.await().pollDelay(1000L, TimeUnit.MILLISECONDS).pollInterval(1000L, TimeUnit.MILLISECONDS).timeout(timeoutMillis, TimeUnit.MILLISECONDS).until(() -> this.getStatusOccurrence(projectId, resourceUrl), Optional::isPresent)).get();
        long timeLeft = timeoutMillis - (System.currentTimeMillis() - start);
        if (timeLeft <= 0L) {
            throw new ConditionTimeoutException("Timed out waiting for vulnerability scan to finish.");
        }
        return (String)((Optional)Awaitility.await().pollDelay(1000L, TimeUnit.MILLISECONDS).pollInterval(1000L, TimeUnit.MILLISECONDS).timeout(timeLeft, TimeUnit.MILLISECONDS).until(() -> this.getVulnerabilityScanStatus(projectId, ClientUtil.nameFromSelfLink(statusOccurrence.getName())), Optional::isPresent)).get();
    }

    public ImmutableList<Occurrence> listVulnerabilityScanOccurrences(String projectId, String resourceUrl) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resourceUrl) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.containerAnalysis.listOccurrences(projectId, ClientUtil.buildFilterString((Map<String, String>)ImmutableMap.of((Object)"resourceUrl", (Object)resourceUrl, (Object)"kind", (Object)VULNERABILITY_KIND))), Comparator.comparing(Occurrence::getName));
    }

    public Occurrence createAttestation(String projectId, String resourceUrl, String noteProjectId, String noteId, String signature, String publicKeyId, String payload) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resourceUrl) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)noteProjectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)noteId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)signature) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)publicKeyId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)payload) ? 1 : 0) != 0);
        return this.containerAnalysis.createAttestation(projectId, resourceUrl, noteProjectId, noteId, signature, publicKeyId, payload);
    }

    private Optional<Occurrence> getStatusOccurrence(String projectId, String resourceUrl) {
        List<Occurrence> occurrences;
        try {
            occurrences = this.containerAnalysis.listOccurrences(projectId, ClientUtil.buildFilterString((Map<String, String>)ImmutableMap.of((Object)"resourceUrl", (Object)resourceUrl, (Object)"kind", (Object)"DISCOVERY")));
        }
        catch (IOException ioe) {
            log.warning(String.format("Error listing occurrences: %s. Retrying ...", ioe.getMessage()));
            return Optional.empty();
        }
        if (occurrences == null) {
            return Optional.empty();
        }
        for (Occurrence o : occurrences) {
            if (o.getDiscovered() == null) continue;
            return Optional.of(o);
        }
        log.info("Did not find occurrences.");
        return Optional.empty();
    }

    private Optional<String> getVulnerabilityScanStatus(String projectId, String occurrenceId) {
        Occurrence occurrence;
        try {
            occurrence = this.containerAnalysis.getOccurrence(projectId, occurrenceId);
        }
        catch (IOException ioe) {
            log.warning(String.format("Error retrieving vulnerability status occurrence projects/%s/occurrences/%s: %s", projectId, occurrenceId, ioe.getMessage()));
            return Optional.empty();
        }
        String status = occurrence.getDiscovered().getDiscovered().getAnalysisStatus();
        if (FINISHED_STATUSES.contains(status)) {
            return Optional.of(status);
        }
        log.fine(String.format("Vulnerability scan is not finished. Current status is %s.", status));
        return Optional.empty();
    }
}

