/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import com.google.api.services.compute.Compute;
import com.google.api.services.compute.model.AcceleratorType;
import com.google.api.services.compute.model.AcceleratorTypeList;
import com.google.api.services.compute.model.DiskType;
import com.google.api.services.compute.model.DiskTypeList;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.ImageList;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceAggregatedList;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.InstanceTemplateList;
import com.google.api.services.compute.model.InstancesScopedList;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.MachineTypeList;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.NetworkList;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.RegionList;
import com.google.api.services.compute.model.Snapshot;
import com.google.api.services.compute.model.Subnetwork;
import com.google.api.services.compute.model.SubnetworkList;
import com.google.api.services.compute.model.Zone;
import com.google.api.services.compute.model.ZoneList;
import com.google.cloud.graphite.platforms.plugin.client.model.GuestAttribute;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class ComputeWrapper {
    private static final String GET_GUEST_ATTRIBUTES_URL = "https://compute.googleapis.com/compute/v1/projects/%s/zones/%s/instances/%s/getGuestAttributes?queryPath=%s";
    private final Compute compute;

    ComputeWrapper(Compute compute) {
        this.compute = compute;
    }

    List<Region> listRegions(String projectId) throws IOException {
        return ((RegionList)this.compute.regions().list(projectId).execute()).getItems();
    }

    Zone getZone(String projectId, String zone) throws IOException {
        return (Zone)this.compute.zones().get(projectId, zone).execute();
    }

    List<Zone> listZones(String projectId) throws IOException {
        return ((ZoneList)this.compute.zones().list(projectId).execute()).getItems();
    }

    List<MachineType> listMachineTypes(String projectId, String zone) throws IOException {
        return ((MachineTypeList)this.compute.machineTypes().list(projectId, zone).execute()).getItems();
    }

    List<DiskType> listDiskTypes(String projectId, String zone) throws IOException {
        return ((DiskTypeList)this.compute.diskTypes().list(projectId, zone).execute()).getItems();
    }

    Image getImage(String projectId, String image) throws IOException {
        return (Image)this.compute.images().get(projectId, image).execute();
    }

    List<Image> listImages(String projectId) throws IOException {
        return ((ImageList)this.compute.images().list(projectId).execute()).getItems();
    }

    List<AcceleratorType> listAcceleratorTypes(String projectId, String zone) throws IOException {
        return ((AcceleratorTypeList)this.compute.acceleratorTypes().list(projectId, zone).execute()).getItems();
    }

    List<Network> listNetworks(String projectId) throws IOException {
        return ((NetworkList)this.compute.networks().list(projectId).execute()).getItems();
    }

    List<Subnetwork> listSubnetworks(String projectId, String region) throws IOException {
        return ((SubnetworkList)this.compute.subnetworks().list(projectId, region).execute()).getItems();
    }

    Operation insertInstance(String projectId, String zone, Instance instance) throws IOException {
        return (Operation)this.compute.instances().insert(projectId, zone, instance).execute();
    }

    Operation insertInstanceWithTemplate(String projectId, String zone, Instance instance, String template) throws IOException {
        return (Operation)this.compute.instances().insert(projectId, zone, instance).setSourceInstanceTemplate(template).execute();
    }

    Operation deleteInstance(String projectId, String zone, String instanceId) throws IOException {
        return (Operation)this.compute.instances().delete(projectId, zone, instanceId).execute();
    }

    Operation setInstanceMetadata(String projectId, String zone, String instanceId, Metadata metadata) throws IOException {
        return (Operation)this.compute.instances().setMetadata(projectId, zone, instanceId, metadata).execute();
    }

    Instance getInstance(String projectId, String zone, String instanceId) throws IOException {
        return (Instance)this.compute.instances().get(projectId, zone, instanceId).execute();
    }

    Map<String, InstancesScopedList> aggregatedListInstances(String projectId, String filter) throws IOException {
        return ((InstanceAggregatedList)this.compute.instances().aggregatedList(projectId).setFilter(filter).execute()).getItems();
    }

    InstanceTemplate getInstanceTemplate(String projectId, String templateName) throws IOException {
        return (InstanceTemplate)this.compute.instanceTemplates().get(projectId, templateName).execute();
    }

    List<InstanceTemplate> listInstanceTemplates(String projectId) throws IOException {
        return ((InstanceTemplateList)this.compute.instanceTemplates().list(projectId).execute()).getItems();
    }

    Operation insertInstanceTemplate(String projectId, InstanceTemplate instanceTemplate) throws IOException {
        return (Operation)this.compute.instanceTemplates().insert(projectId, instanceTemplate).execute();
    }

    Operation deleteInstanceTemplate(String projectId, String templateName) throws IOException {
        return (Operation)this.compute.instanceTemplates().delete(projectId, templateName).execute();
    }

    Operation createDiskSnapshot(String projectId, String zone, String disk, Snapshot snapshot) throws IOException {
        return (Operation)this.compute.disks().createSnapshot(projectId, zone, disk, snapshot).execute();
    }

    Operation deleteSnapshot(String projectId, String snapshotName) throws IOException {
        return (Operation)this.compute.snapshots().delete(projectId, snapshotName).execute();
    }

    Snapshot getSnapshot(String projectId, String snapshotName) throws IOException {
        return (Snapshot)this.compute.snapshots().get(projectId, snapshotName).execute();
    }

    Operation getZoneOperation(String projectId, String zone, String operationId) throws IOException {
        return (Operation)this.compute.zoneOperations().get(projectId, zone, operationId).execute();
    }

    Operation simulateMaintenanceEvent(String projectId, String zone, String instanceId) throws IOException {
        return (Operation)this.compute.instances().simulateMaintenanceEvent(projectId, zone, instanceId).execute();
    }

    GuestAttributeQueryResult getGuestAttributes(String projectId, String zone, String instanceId, String queryPath) throws IOException {
        return (GuestAttributeQueryResult)this.compute.getRequestFactory().buildGetRequest(new GenericUrl(String.format(GET_GUEST_ATTRIBUTES_URL, projectId, zone, instanceId, queryPath))).setParser((ObjectParser)new JsonObjectParser((JsonFactory)new JacksonFactory())).execute().parseAs(GuestAttributeQueryResult.class);
    }

    public static class GuestAttributeQueryValue {
        @Key(value="items")
        private List<GuestAttribute> items;

        public static GuestAttributeQueryValueBuilder builder() {
            return new GuestAttributeQueryValueBuilder();
        }

        public List<GuestAttribute> getItems() {
            return this.items;
        }

        public void setItems(List<GuestAttribute> items) {
            this.items = items;
        }

        public GuestAttributeQueryValue(List<GuestAttribute> items) {
            this.items = items;
        }

        public GuestAttributeQueryValue() {
        }

        public static class GuestAttributeQueryValueBuilder {
            private List<GuestAttribute> items;

            GuestAttributeQueryValueBuilder() {
            }

            public GuestAttributeQueryValueBuilder items(List<GuestAttribute> items) {
                this.items = items;
                return this;
            }

            public GuestAttributeQueryValue build() {
                return new GuestAttributeQueryValue(this.items);
            }

            public String toString() {
                return "ComputeWrapper.GuestAttributeQueryValue.GuestAttributeQueryValueBuilder(items=" + this.items + ")";
            }
        }
    }

    public static class GuestAttributeQueryResult {
        @Key(value="queryPath")
        private String queryPath;
        @Key(value="queryValue")
        private GuestAttributeQueryValue queryValue;

        public static GuestAttributeQueryResultBuilder builder() {
            return new GuestAttributeQueryResultBuilder();
        }

        public String getQueryPath() {
            return this.queryPath;
        }

        public GuestAttributeQueryValue getQueryValue() {
            return this.queryValue;
        }

        public void setQueryPath(String queryPath) {
            this.queryPath = queryPath;
        }

        public void setQueryValue(GuestAttributeQueryValue queryValue) {
            this.queryValue = queryValue;
        }

        public GuestAttributeQueryResult(String queryPath, GuestAttributeQueryValue queryValue) {
            this.queryPath = queryPath;
            this.queryValue = queryValue;
        }

        public GuestAttributeQueryResult() {
        }

        public static class GuestAttributeQueryResultBuilder {
            private String queryPath;
            private GuestAttributeQueryValue queryValue;

            GuestAttributeQueryResultBuilder() {
            }

            public GuestAttributeQueryResultBuilder queryPath(String queryPath) {
                this.queryPath = queryPath;
                return this;
            }

            public GuestAttributeQueryResultBuilder queryValue(GuestAttributeQueryValue queryValue) {
                this.queryValue = queryValue;
                return this;
            }

            public GuestAttributeQueryResult build() {
                return new GuestAttributeQueryResult(this.queryPath, this.queryValue);
            }

            public String toString() {
                return "ComputeWrapper.GuestAttributeQueryResult.GuestAttributeQueryResultBuilder(queryPath=" + this.queryPath + ", queryValue=" + this.queryValue + ")";
            }
        }
    }
}

