/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client;

import com.diffplug.common.base.Errors;
import com.google.api.services.compute.model.AcceleratorType;
import com.google.api.services.compute.model.DeprecationStatus;
import com.google.api.services.compute.model.DiskType;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.InstancesScopedList;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.Snapshot;
import com.google.api.services.compute.model.Subnetwork;
import com.google.api.services.compute.model.Zone;
import com.google.cloud.graphite.platforms.plugin.client.ComputeWrapper;
import com.google.cloud.graphite.platforms.plugin.client.model.GuestAttribute;
import com.google.cloud.graphite.platforms.plugin.client.util.ClientUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;

public class ComputeClient {
    private static final Logger LOGGER = Logger.getLogger(ComputeClient.class.getName());
    private static final long POLLING_INTERVAL = 5000L;
    private final ComputeWrapper compute;

    ComputeClient(ComputeWrapper compute) {
        this.compute = compute;
    }

    public static ImmutableList<Metadata.Items> mergeMetadataItems(List<Metadata.Items> winner, List<Metadata.Items> loser) {
        if (loser == null) {
            return ImmutableList.copyOf(winner);
        }
        ArrayList<Metadata.Items> result = new ArrayList<Metadata.Items>(winner);
        loser.stream().filter(existing -> winner.stream().noneMatch(newItem -> newItem.getKey().equals(existing.getKey()))).forEach(result::add);
        return ImmutableList.copyOf(result);
    }

    public ImmutableList<Region> listRegions(String projectId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.compute.listRegions(projectId), r -> !ComputeClient.isDeprecated(r.getDeprecated()), Comparator.comparing(Region::getName));
    }

    public ImmutableList<Zone> listZones(String projectId, String regionLink) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)regionLink) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.compute.listZones(projectId), z -> regionLink.equalsIgnoreCase(z.getRegion()), Comparator.comparing(Zone::getName));
    }

    public ImmutableList<MachineType> listMachineTypes(String projectId, String zoneLink) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.compute.listMachineTypes(projectId, ClientUtil.nameFromSelfLink(zoneLink)), o -> !ComputeClient.isDeprecated(o.getDeprecated()), Comparator.comparing(MachineType::getName));
    }

    public ImmutableList<String> listCpuPlatforms(String projectId, String zoneLink) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.compute.getZone(projectId, ClientUtil.nameFromSelfLink(zoneLink)).getAvailableCpuPlatforms(), String::compareTo);
    }

    public ImmutableList<DiskType> listDiskTypes(String projectId, String zoneLink) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.compute.listDiskTypes(projectId, ClientUtil.nameFromSelfLink(zoneLink)), d -> !ComputeClient.isDeprecated(d.getDeprecated()), Comparator.comparing(DiskType::getName));
    }

    public ImmutableList<DiskType> listBootDiskTypes(String projectId, String zoneLink) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.compute.listDiskTypes(projectId, ClientUtil.nameFromSelfLink(zoneLink)), d -> !ComputeClient.isDeprecated(d.getDeprecated()) && !d.getName().startsWith("local-"), Comparator.comparing(DiskType::getName));
    }

    public ImmutableList<Image> listImages(String projectId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.compute.listImages(projectId), i -> !ComputeClient.isDeprecated(i.getDeprecated()), Comparator.comparing(Image::getName));
    }

    public Image getImage(String projectId, String imageName) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageName) ? 1 : 0) != 0);
        return this.compute.getImage(projectId, imageName);
    }

    public ImmutableList<AcceleratorType> listAcceleratorTypes(String projectId, String zoneLink) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.compute.listAcceleratorTypes(projectId, ClientUtil.nameFromSelfLink(zoneLink)), a -> !ComputeClient.isDeprecated(a.getDeprecated()), Comparator.comparing(AcceleratorType::getName));
    }

    public ImmutableList<Network> listNetworks(String projectId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.compute.listNetworks(projectId), Comparator.comparing(Network::getName));
    }

    public ImmutableList<Subnetwork> listSubnetworks(String projectId, String networkLink, String regionLink) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)networkLink) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)regionLink) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.compute.listSubnetworks(projectId, ClientUtil.nameFromSelfLink(regionLink)), s -> s.getNetwork().equalsIgnoreCase(networkLink), Comparator.comparing(Subnetwork::getName));
    }

    public Operation insertInstance(String projectId, Optional<String> templateLink, Instance instance) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)instance);
        String zone = ClientUtil.nameFromSelfLink(instance.getZone());
        if (templateLink.isPresent() && !templateLink.get().isEmpty()) {
            return this.compute.insertInstanceWithTemplate(projectId, zone, instance, templateLink.get());
        }
        return this.compute.insertInstance(projectId, zone, instance);
    }

    public Operation terminateInstanceAsync(String projectId, String zoneLink, String instanceId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0);
        return this.compute.deleteInstance(projectId, ClientUtil.nameFromSelfLink(zoneLink), instanceId);
    }

    public Optional<Operation> terminateInstanceWithStatusAsync(String projectId, String zoneLink, String instanceId, String desiredStatus) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)desiredStatus) ? 1 : 0) != 0);
        String zoneName = ClientUtil.nameFromSelfLink(zoneLink);
        Instance instance = this.compute.getInstance(projectId, zoneName, instanceId);
        if (instance.getStatus().equals(desiredStatus)) {
            return Optional.of(this.compute.deleteInstance(projectId, zoneName, instanceId));
        }
        return Optional.empty();
    }

    public Instance getInstance(String projectId, String zoneLink, String instanceId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0);
        return this.compute.getInstance(projectId, ClientUtil.nameFromSelfLink(zoneLink), instanceId);
    }

    public ImmutableList<Instance> listInstancesWithLabel(String projectId, Map<String, String> labels) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkNotNull(labels);
        Map<String, InstancesScopedList> result = this.compute.aggregatedListInstances(projectId, ClientUtil.buildLabelsFilterString(labels));
        ArrayList instances = new ArrayList();
        for (InstancesScopedList matchingInstances : result.values()) {
            if (matchingInstances.getInstances() == null) continue;
            instances.addAll(matchingInstances.getInstances());
        }
        return ImmutableList.copyOf(instances);
    }

    public InstanceTemplate getTemplate(String projectId, String templateName) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)templateName) ? 1 : 0) != 0);
        return this.compute.getInstanceTemplate(projectId, templateName);
    }

    public Operation insertTemplateAsync(String projectId, InstanceTemplate instanceTemplate) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)instanceTemplate);
        return this.compute.insertInstanceTemplate(projectId, instanceTemplate);
    }

    public Operation deleteTemplateAsync(String projectId, String templateName) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)templateName) ? 1 : 0) != 0);
        return this.compute.deleteInstanceTemplate(projectId, templateName);
    }

    public ImmutableList<InstanceTemplate> listTemplates(String projectId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.compute.listInstanceTemplates(projectId), Comparator.comparing(InstanceTemplate::getName));
    }

    public void createSnapshotSync(String projectId, String zoneLink, String instanceId, long timeout) throws IOException, InterruptedException, OperationException {
        Instance instance;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        String zoneName = ClientUtil.nameFromSelfLink(zoneLink);
        try {
            instance = this.compute.getInstance(projectId, zoneName, instanceId);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Error retrieving instance.", ioe);
            throw ioe;
        }
        instance.getDisks().parallelStream().forEach(Errors.rethrow().wrap(disk -> {
            try {
                this.createSnapshotForDiskSync(projectId, zoneName, ClientUtil.nameFromSelfLink(disk.getSource()), timeout);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Error in creating snapshot.", ioe);
                throw ioe;
            }
            catch (InterruptedException ie) {
                LOGGER.log(Level.WARNING, "Interruption in creating snapshot.", ie);
                throw ie;
            }
            catch (OperationException oe) {
                LOGGER.log(Level.WARNING, "Error in completing operation.");
                throw oe;
            }
        }));
    }

    public Operation createSnapshotForDiskSync(String projectId, String zoneName, String diskName, long timeout) throws IOException, InterruptedException, OperationException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)diskName) ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        Snapshot snapshot = new Snapshot();
        snapshot.setName(diskName);
        Operation op = this.compute.createDiskSnapshot(projectId, zoneName, diskName, snapshot);
        return this.waitForOperationCompletion(projectId, op, timeout);
    }

    public Operation deleteSnapshotAsync(String projectId, String snapshotName) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snapshotName) ? 1 : 0) != 0);
        return this.compute.deleteSnapshot(projectId, snapshotName);
    }

    public Snapshot getSnapshot(String projectId, String snapshotName) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)snapshotName) ? 1 : 0) != 0);
        return this.compute.getSnapshot(projectId, snapshotName);
    }

    public Operation getZoneOperation(String projectId, String zoneLink, String operationId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)operationId) ? 1 : 0) != 0);
        return this.compute.getZoneOperation(projectId, ClientUtil.nameFromSelfLink(zoneLink), operationId);
    }

    public Operation appendInstanceMetadataSync(String projectId, String zoneLink, String instanceId, List<Metadata.Items> items, long timeout) throws IOException, InterruptedException, OperationException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0);
        Preconditions.checkNotNull(items);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        String zoneName = ClientUtil.nameFromSelfLink(zoneLink);
        Instance instance = this.getInstance(projectId, zoneName, instanceId);
        Metadata existingMetadata = instance.getMetadata();
        ImmutableList<Metadata.Items> newMetadataItems = ComputeClient.mergeMetadataItems(items, existingMetadata.getItems());
        existingMetadata.setItems(newMetadataItems);
        Operation op = this.compute.setInstanceMetadata(projectId, zoneName, instanceId, existingMetadata);
        return this.waitForOperationCompletion(projectId, op, timeout);
    }

    public Operation waitForOperationCompletion(String projectId, Operation operation, long timeout) throws InterruptedException, OperationException {
        Preconditions.checkNotNull((Object)operation);
        return this.waitForOperationCompletion(projectId, operation.getName(), operation.getZone(), timeout);
    }

    public Operation waitForOperationCompletion(String projectId, String operationName, String zoneLink, long timeout) throws InterruptedException, OperationException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)operationName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        Operation operation = new Operation();
        try {
            Awaitility.await().pollInterval(5000L, TimeUnit.MILLISECONDS).timeout(timeout, TimeUnit.MILLISECONDS).until(() -> {
                LOGGER.log(Level.FINE, "Waiting for operation " + operationName + " to complete.");
                try {
                    Operation op = this.getZoneOperation(projectId, zoneLink, operationName);
                    operation.setError(op.getError());
                    return this.isOperationDone(op);
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, "Error retrieving operation.", ioe);
                    return false;
                }
            });
        }
        catch (ConditionTimeoutException e) {
            throw new InterruptedException("Timed out waiting for operation to complete.");
        }
        if (operation.getError() != null) {
            throw new OperationException(operation.getError());
        }
        return operation;
    }

    public Operation simulateMaintenanceEvent(String projectId, String zoneLink, String instanceId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneLink) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0);
        return this.compute.simulateMaintenanceEvent(projectId, ClientUtil.nameFromSelfLink(zoneLink), instanceId);
    }

    public ImmutableList<GuestAttribute> getGuestAttributesSync(String projectId, String zoneName, String instanceId, String queryPath) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zoneName) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)queryPath) ? 1 : 0) != 0);
        ComputeWrapper.GuestAttributeQueryResult queryResult = this.compute.getGuestAttributes(projectId, zoneName, instanceId, queryPath);
        ComputeWrapper.GuestAttributeQueryValue queryValue = queryResult.getQueryValue();
        if (queryValue == null) {
            throw new IOException("Response did not contain 'queryValue'");
        }
        List<GuestAttribute> items = queryValue.getItems();
        if (items == null) {
            throw new IOException("Response 'queryValue' does not contain items");
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        items.forEach(arg_0 -> ((ImmutableList.Builder)resultBuilder).add(arg_0));
        return resultBuilder.build();
    }

    private boolean isOperationDone(Operation operation) {
        if (operation == null) {
            return false;
        }
        return operation.getStatus().equals("DONE");
    }

    private static boolean isDeprecated(DeprecationStatus deprecated) {
        return deprecated != null && deprecated.getState().equalsIgnoreCase("DEPRECATED");
    }

    public static class OperationException
    extends Exception {
        private Operation.Error error;

        public OperationException(Operation.Error error) {
            this("", error);
        }

        public OperationException(String message, Operation.Error error) {
            super(message);
            this.error = error;
        }

        public Operation.Error getError() {
            return this.error;
        }
    }
}

