/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client;

import com.google.api.services.cloudkms.v1.CloudKMS;
import com.google.api.services.cloudkms.v1.model.AsymmetricSignRequest;
import com.google.api.services.cloudkms.v1.model.AsymmetricSignResponse;
import com.google.api.services.cloudkms.v1.model.CryptoKey;
import com.google.api.services.cloudkms.v1.model.CryptoKeyVersion;
import com.google.api.services.cloudkms.v1.model.Digest;
import com.google.api.services.cloudkms.v1.model.KeyRing;
import com.google.api.services.cloudkms.v1.model.ListCryptoKeyVersionsResponse;
import com.google.api.services.cloudkms.v1.model.ListCryptoKeysResponse;
import com.google.api.services.cloudkms.v1.model.ListKeyRingsResponse;
import com.google.api.services.cloudkms.v1.model.ListLocationsResponse;
import com.google.api.services.cloudkms.v1.model.Location;
import com.google.api.services.cloudkms.v1.model.PublicKey;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

class CloudKMSWrapper {
    private CloudKMS cloudKMS;

    CloudKMSWrapper(CloudKMS cloudKMS) {
        this.cloudKMS = cloudKMS;
    }

    List<Location> listLocations(String projectId) throws IOException {
        return ((ListLocationsResponse)this.cloudKMS.projects().locations().list(CloudKMSWrapper.toLocationName(projectId)).execute()).getLocations();
    }

    List<KeyRing> listKeyRings(String projectId, String location) throws IOException {
        return ((ListKeyRingsResponse)this.cloudKMS.projects().locations().keyRings().list(CloudKMSWrapper.toKeyRingParent(projectId, location)).execute()).getKeyRings();
    }

    List<CryptoKey> listCryptoKeys(String projectId, String location, String keyRing) throws IOException {
        return ((ListCryptoKeysResponse)this.cloudKMS.projects().locations().keyRings().cryptoKeys().list(CloudKMSWrapper.toCryptoKeyParent(projectId, location, keyRing)).execute()).getCryptoKeys();
    }

    CryptoKey getCryptoKey(String projectId, String location, String keyRing, String cryptoKey) throws IOException {
        return (CryptoKey)this.cloudKMS.projects().locations().keyRings().cryptoKeys().get(CloudKMSWrapper.toCryptoKeyVersionParent(projectId, location, keyRing, cryptoKey)).execute();
    }

    List<CryptoKeyVersion> listCryptoKeyVersions(String projectId, String location, String keyRing, String cryptoKey) throws IOException {
        return ((ListCryptoKeyVersionsResponse)this.cloudKMS.projects().locations().keyRings().cryptoKeys().cryptoKeyVersions().list(CloudKMSWrapper.toCryptoKeyVersionParent(projectId, location, keyRing, cryptoKey)).execute()).getCryptoKeyVersions();
    }

    CryptoKeyVersion getCryptoKeyVersion(String projectId, String location, String keyRing, String cryptoKey, String cryptoKeyVersion) throws IOException {
        return (CryptoKeyVersion)this.cloudKMS.projects().locations().keyRings().cryptoKeys().cryptoKeyVersions().get(CloudKMSWrapper.toCryptoKeyVersionName(projectId, location, keyRing, cryptoKey, cryptoKeyVersion)).execute();
    }

    PublicKey getPublicKey(String projectId, String location, String keyRing, String cryptoKey, String cryptoKeyVersion) throws IOException {
        return (PublicKey)this.cloudKMS.projects().locations().keyRings().cryptoKeys().cryptoKeyVersions().getPublicKey(CloudKMSWrapper.toCryptoKeyVersionName(projectId, location, keyRing, cryptoKey, cryptoKeyVersion)).execute();
    }

    String asymmetricSign(String projectId, String location, String keyRing, String cryptoKey, String cryptoKeyVersion, String algorithm, String payload) throws IOException, NoSuchAlgorithmException {
        return ((AsymmetricSignResponse)this.cloudKMS.projects().locations().keyRings().cryptoKeys().cryptoKeyVersions().asymmetricSign(CloudKMSWrapper.toCryptoKeyVersionName(projectId, location, keyRing, cryptoKey, cryptoKeyVersion), new AsymmetricSignRequest().setDigest(CloudKMSWrapper.toDigest(algorithm, payload))).execute()).getSignature();
    }

    private static String toLocationName(String projectId) {
        return String.format("projects/%s", projectId);
    }

    private static String toKeyRingParent(String projectId, String location) {
        return String.format("projects/%s/locations/%s", projectId, location);
    }

    private static String toCryptoKeyParent(String projectId, String location, String keyRing) {
        return String.format("projects/%s/locations/%s/keyRings/%s", projectId, location, keyRing);
    }

    private static String toCryptoKeyVersionParent(String projectId, String location, String keyRing, String cryptoKey) {
        return String.format("projects/%s/locations/%s/keyRings/%s/cryptoKeys/%s", projectId, location, keyRing, cryptoKey);
    }

    private static String toCryptoKeyVersionName(String projectId, String location, String keyRing, String cryptoKey, String cryptoKeyVersion) {
        return String.format("projects/%s/locations/%s/keyRings/%s/cryptoKeys/%s/cryptoKeyVersions/%s", projectId, location, keyRing, cryptoKey, cryptoKeyVersion);
    }

    private static Digest toDigest(String algorithm, String payload) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] digest = md.digest(payload.getBytes());
        Digest result = new Digest();
        switch (algorithm) {
            case "SHA-256": {
                return result.encodeSha256(digest);
            }
            case "SHA-384": {
                return result.encodeSha384(digest);
            }
            case "SHA-512": {
                return result.encodeSha512(digest);
            }
        }
        throw new IllegalArgumentException("algorithm should be one of SHA-256, SHA-384, or SHA-512 but was: " + algorithm);
    }
}

