/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client;

import com.google.api.services.cloudkms.v1.model.CryptoKey;
import com.google.api.services.cloudkms.v1.model.CryptoKeyVersion;
import com.google.api.services.cloudkms.v1.model.KeyRing;
import com.google.api.services.cloudkms.v1.model.Location;
import com.google.api.services.cloudkms.v1.model.PublicKey;
import com.google.cloud.graphite.platforms.plugin.client.CloudKMSWrapper;
import com.google.cloud.graphite.platforms.plugin.client.util.ClientUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.logging.Logger;

public class CloudKMSClient {
    private static final Logger log = Logger.getLogger(CloudKMSClient.class.getName());
    private CloudKMSWrapper cloudKMS;

    CloudKMSClient(CloudKMSWrapper cloudKMS) {
        this.cloudKMS = cloudKMS;
    }

    public ImmutableList<Location> listLocations(String projectId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.cloudKMS.listLocations(projectId), Comparator.comparing(Location::getName));
    }

    public ImmutableList<KeyRing> listKeyRings(String projectId, String location) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.cloudKMS.listKeyRings(projectId, location), Comparator.comparing(KeyRing::getName));
    }

    public ImmutableList<CryptoKey> listCryptoKeys(String projectId, String location, String keyRing) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyRing) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.cloudKMS.listCryptoKeys(projectId, location, keyRing), Comparator.comparing(CryptoKey::getName));
    }

    public CryptoKey getCryptoKey(String projectId, String location, String keyRing, String cryptoKey) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyRing) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cryptoKey) ? 1 : 0) != 0);
        return this.cloudKMS.getCryptoKey(projectId, location, keyRing, cryptoKey);
    }

    public ImmutableList<CryptoKeyVersion> listCryptoKeyVersions(String projectId, String location, String keyRing, String cryptoKey) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyRing) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cryptoKey) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.cloudKMS.listCryptoKeyVersions(projectId, location, keyRing, cryptoKey), c -> "ENABLED".equals(c.getState()), Comparator.comparing(CryptoKeyVersion::getName));
    }

    public CryptoKeyVersion getCryptoKeyVersion(String projectId, String location, String keyRing, String cryptoKey, String cryptoKeyVersion) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyRing) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cryptoKey) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cryptoKeyVersion) ? 1 : 0) != 0);
        return this.cloudKMS.getCryptoKeyVersion(projectId, location, keyRing, cryptoKey, cryptoKeyVersion);
    }

    public PublicKey getPublicKey(String projectId, String location, String keyRing, String cryptoKey, String cryptoKeyVersion) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyRing) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cryptoKey) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cryptoKeyVersion) ? 1 : 0) != 0);
        return this.cloudKMS.getPublicKey(projectId, location, keyRing, cryptoKey, cryptoKeyVersion);
    }

    public String asymmetricSign(String projectId, String location, String keyRing, String cryptoKey, String cryptoKeyVersion, String payload) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)location) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyRing) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cryptoKey) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cryptoKeyVersion) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)payload) ? 1 : 0) != 0);
        CryptoKeyVersion cryptoKeyVersionObj = this.cloudKMS.getCryptoKeyVersion(projectId, location, keyRing, cryptoKey, cryptoKeyVersion);
        String purpose = CloudKMSClient.parseKeyPurpose(cryptoKeyVersionObj.getAlgorithm());
        if (!"SIGN".equals(purpose)) {
            throw new IllegalArgumentException(String.format("Key specified should have purpose SIGN, instead was: %s", purpose));
        }
        String digestAlgorithm = CloudKMSClient.parseDigestAlgorithm(cryptoKeyVersionObj.getAlgorithm());
        try {
            return this.cloudKMS.asymmetricSign(projectId, location, keyRing, cryptoKey, cryptoKeyVersion, digestAlgorithm, payload);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException("The digest algorithm was verified but still caught NoSuchAlgorithmException.", nsae);
        }
    }

    private static String parseKeyPurpose(String algorithm) {
        String[] tokens = algorithm.split("_");
        if (tokens.length < 3 || tokens.length > 5) {
            throw new IllegalArgumentException("Invalid key algorithm provided: " + algorithm);
        }
        switch (tokens[1]) {
            case "SIGN": 
            case "DECRYPT": {
                return tokens[1];
            }
            case "KEY": 
            case "SYMMETRIC": {
                throw new IllegalArgumentException("Key with unspecified purpose provided: " + algorithm);
            }
        }
        throw new IllegalArgumentException("Invalid key algorithm provided: " + algorithm);
    }

    private static String parseDigestAlgorithm(String algorithm) {
        String digestAlgorithm;
        String[] tokens = algorithm.split("_");
        if (tokens.length < 3 || tokens.length > 5) {
            throw new IllegalArgumentException();
        }
        switch (digestAlgorithm = tokens[tokens.length - 1]) {
            case "SHA256": 
            case "SHA384": 
            case "SHA512": {
                return "SHA-" + digestAlgorithm.substring(3);
            }
            case "ENCRYPTION": 
            case "UNSPECIFIED": {
                throw new IllegalArgumentException("Key with unspecified digest algorithm provided: " + algorithm);
            }
        }
        throw new IllegalArgumentException("Invalid key algorithm provided: " + algorithm);
    }
}

