/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.binaryauthorization.v1beta1.BinaryAuthorization;
import com.google.api.services.cloudkms.v1.CloudKMS;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.compute.Compute;
import com.google.api.services.container.Container;
import com.google.api.services.containeranalysis.v1beta1.ContainerAnalysis;
import com.google.cloud.graphite.platforms.plugin.client.BinaryAuthorizationClient;
import com.google.cloud.graphite.platforms.plugin.client.BinaryAuthorizationWrapper;
import com.google.cloud.graphite.platforms.plugin.client.CloudKMSClient;
import com.google.cloud.graphite.platforms.plugin.client.CloudKMSWrapper;
import com.google.cloud.graphite.platforms.plugin.client.CloudResourceManagerClient;
import com.google.cloud.graphite.platforms.plugin.client.CloudResourceManagerWrapper;
import com.google.cloud.graphite.platforms.plugin.client.ComputeClient;
import com.google.cloud.graphite.platforms.plugin.client.ComputeWrapper;
import com.google.cloud.graphite.platforms.plugin.client.ContainerAnalysisClient;
import com.google.cloud.graphite.platforms.plugin.client.ContainerAnalysisWrapper;
import com.google.cloud.graphite.platforms.plugin.client.ContainerClient;
import com.google.cloud.graphite.platforms.plugin.client.ContainerWrapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Optional;

public class ClientFactory {
    private final HttpTransport transport;
    private final JsonFactory jsonFactory;
    private final HttpRequestInitializer httpRequestInitializer;
    private final String applicationName;

    public ClientFactory(Optional<HttpTransport> httpTransport, HttpRequestInitializer httpRequestInitializer, String applicationName) throws IOException, GeneralSecurityException {
        this.transport = httpTransport.orElse((HttpTransport)GoogleNetHttpTransport.newTrustedTransport());
        this.jsonFactory = new JacksonFactory();
        this.httpRequestInitializer = (HttpRequestInitializer)Preconditions.checkNotNull((Object)httpRequestInitializer);
        this.applicationName = (String)Preconditions.checkNotNull((Object)applicationName);
    }

    public BinaryAuthorizationClient binaryAuthorizationClient() {
        return new BinaryAuthorizationClient(new BinaryAuthorizationWrapper(new BinaryAuthorization.Builder(this.transport, this.jsonFactory, this.httpRequestInitializer).setGoogleClientRequestInitializer(this::initializeRequest).setApplicationName(this.applicationName).build()));
    }

    public CloudKMSClient cloudKMSClient() {
        return new CloudKMSClient(new CloudKMSWrapper(new CloudKMS.Builder(this.transport, this.jsonFactory, this.httpRequestInitializer).setGoogleClientRequestInitializer(this::initializeRequest).setApplicationName(this.applicationName).build()));
    }

    public CloudResourceManagerClient cloudResourceManagerClient() {
        return new CloudResourceManagerClient(new CloudResourceManagerWrapper(new CloudResourceManager.Builder(this.transport, this.jsonFactory, this.httpRequestInitializer).setGoogleClientRequestInitializer(this::initializeRequest).setApplicationName(this.applicationName).build()));
    }

    public ComputeClient computeClient() {
        return new ComputeClient(new ComputeWrapper(new Compute.Builder(this.transport, this.jsonFactory, this.httpRequestInitializer).setGoogleClientRequestInitializer(this::initializeRequest).setApplicationName(this.applicationName).build()));
    }

    public ContainerClient containerClient() {
        return new ContainerClient(new ContainerWrapper(new Container.Builder(this.transport, this.jsonFactory, this.httpRequestInitializer).setGoogleClientRequestInitializer(this::initializeRequest).setApplicationName(this.applicationName).build()));
    }

    public ContainerAnalysisClient containerAnalysisClient() {
        return new ContainerAnalysisClient(new ContainerAnalysisWrapper(new ContainerAnalysis.Builder(this.transport, this.jsonFactory, this.httpRequestInitializer).setGoogleClientRequestInitializer(this::initializeRequest).setApplicationName(this.applicationName).build()));
    }

    private void initializeRequest(AbstractGoogleClientRequest request) {
        request.setRequestHeaders(request.getRequestHeaders().setUserAgent(this.applicationName));
    }
}

