/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client;

import com.google.api.services.binaryauthorization.v1beta1.BinaryAuthorization;
import com.google.api.services.binaryauthorization.v1beta1.model.Attestor;
import com.google.api.services.binaryauthorization.v1beta1.model.ListAttestorsResponse;
import java.io.IOException;
import java.util.List;

class BinaryAuthorizationWrapper {
    private BinaryAuthorization binaryAuthorization;

    BinaryAuthorizationWrapper(BinaryAuthorization binaryAuthorization) {
        this.binaryAuthorization = binaryAuthorization;
    }

    List<Attestor> listAttestors(String projectId) throws IOException {
        return ((ListAttestorsResponse)this.binaryAuthorization.projects().attestors().list(BinaryAuthorizationWrapper.toAttestorParent(projectId)).execute()).getAttestors();
    }

    Attestor getAttestor(String projectId, String attestor) throws IOException {
        return (Attestor)this.binaryAuthorization.projects().attestors().get(BinaryAuthorizationWrapper.toAttestorName(projectId, attestor)).execute();
    }

    private static String toAttestorParent(String projectId) {
        return String.format("projects/%s", projectId);
    }

    private static String toAttestorName(String projectId, String attestor) {
        return String.format("projects/%s/attestors/%s", projectId, attestor);
    }
}

