/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.graphite.platforms.plugin.client;

import com.google.api.services.binaryauthorization.v1beta1.model.Attestor;
import com.google.cloud.graphite.platforms.plugin.client.BinaryAuthorizationWrapper;
import com.google.cloud.graphite.platforms.plugin.client.util.ClientUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Comparator;

public class BinaryAuthorizationClient {
    private static final String ATTESTATION_PAYLOAD_TEMPLATE = "{\n  \"critical\": {\n    \"identity\": {\n      \"docker-reference\": \"%s\"\n    },\n    \"image\": {\n      \"docker-manifest-digest\": \"%s\"\n    },\n    \"type\": \"Google cloud binauthz container signature\"\n  }\n}\n";
    private BinaryAuthorizationWrapper binaryAuthorization;

    BinaryAuthorizationClient(BinaryAuthorizationWrapper binaryAuthorization) {
        this.binaryAuthorization = binaryAuthorization;
    }

    public ImmutableList<Attestor> listAttestors(String projectId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        return ClientUtil.processResourceList(this.binaryAuthorization.listAttestors(projectId), Comparator.comparing(Attestor::getName));
    }

    public Attestor getAttestor(String projectId, String attestorName) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)attestorName) ? 1 : 0) != 0);
        return this.binaryAuthorization.getAttestor(projectId, attestorName);
    }

    public String generateAttestationPayload(String resourceUrl) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resourceUrl) && resourceUrl.contains("@") ? 1 : 0) != 0);
        String[] tokens = resourceUrl.split("@");
        return String.format(ATTESTATION_PAYLOAD_TEMPLATE, tokens[0], tokens[1]);
    }
}

