/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.Box;
import com.diffplug.common.base.Errors;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public class StringPrinter {
    private final Consumer<String> consumer;
    private static final int DECODER_BUFFER = 128;

    public StringPrinter(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    public void println(String line) {
        this.consumer.accept(line);
        this.consumer.accept("\n");
    }

    public void print(String content) {
        this.consumer.accept(content);
    }

    public static String buildString(Consumer<StringPrinter> printer) {
        StringBuilder builder = new StringBuilder();
        printer.accept(new StringPrinter(builder::append));
        return builder.toString();
    }

    public static String buildStringFromLines(String ... lines) {
        int numChars = lines.length;
        for (String line : lines) {
            numChars += line.length();
        }
        StringBuilder builder = new StringBuilder(numChars);
        for (String line : lines) {
            builder.append(line);
            builder.append('\n');
        }
        return builder.toString();
    }

    public OutputStream toOutputStream(Charset charset) {
        final CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
        final ByteBuffer decoderIn = ByteBuffer.allocate(128);
        final CharBuffer decoderOut = CharBuffer.allocate(128);
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b});
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                while (len > 0) {
                    int c = Math.min(len, decoderIn.remaining());
                    decoderIn.put(b, off, c);
                    this.processInput(false);
                    len -= c;
                    off += c;
                }
                this.flushOutput();
            }

            private void processInput(boolean endOfInput) throws IOException {
                CoderResult coderResult;
                decoderIn.flip();
                while ((coderResult = decoder.decode(decoderIn, decoderOut, endOfInput)).isOverflow()) {
                    this.flushOutput();
                }
                if (!coderResult.isUnderflow()) {
                    throw new IOException("Unexpected coder result");
                }
                decoderIn.compact();
            }

            private void flushOutput() throws IOException {
                if (decoderOut.position() > 0) {
                    StringPrinter.this.consumer.accept(new String(decoderOut.array(), 0, decoderOut.position()));
                    decoderOut.rewind();
                }
            }
        };
    }

    public PrintStream toPrintStream() {
        return this.toPrintStream(StandardCharsets.UTF_8);
    }

    public PrintStream toPrintStream(Charset charset) {
        return (PrintStream)Errors.rethrow().get(() -> new PrintStream(this.toOutputStream(charset), true, charset.name()));
    }

    public Writer toWriter() {
        return new Writer(){

            @Override
            public Writer append(char c) {
                StringPrinter.this.consumer.accept(new String(new char[]{c}));
                return this;
            }

            @Override
            public Writer append(CharSequence csq) {
                if (csq instanceof String) {
                    StringPrinter.this.consumer.accept((String)csq);
                } else {
                    StringPrinter.this.consumer.accept(this.toStringSafely(csq));
                }
                return this;
            }

            @Override
            public Writer append(CharSequence csq, int start, int end) {
                if (csq instanceof String) {
                    StringPrinter.this.consumer.accept(((String)csq).substring(start, end));
                } else {
                    StringPrinter.this.consumer.accept(this.toStringSafely(csq.subSequence(start, end)));
                }
                return this;
            }

            private String toStringSafely(CharSequence csq) {
                String asString = csq.toString();
                if (asString.length() == csq.length()) {
                    return asString;
                }
                Errors.log().accept(new IllegalArgumentException(csq.getClass() + " did not implement toString() correctly."));
                char[] chars = new char[csq.length()];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = csq.charAt(i);
                }
                return new String(chars);
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                StringPrinter.this.consumer.accept(new String(cbuf, off, len));
            }

            @Override
            public void write(String str) {
                StringPrinter.this.consumer.accept(str);
            }

            @Override
            public void write(String str, int off, int len) {
                StringPrinter.this.consumer.accept(str.substring(off, off + len));
            }
        };
    }

    public PrintWriter toPrintWriter() {
        boolean autoflush = true;
        return new PrintWriter(this.toWriter(), autoflush);
    }

    public static Consumer<String> stringsToLines(Consumer<String> perLine) {
        Box<String> leftover = Box.of("");
        return rawString -> {
            rawString = (String)leftover.get() + rawString.replace("\r", "");
            int lastIdx = 0;
            int idx = 0;
            while ((idx = rawString.indexOf(10, lastIdx)) > -1) {
                perLine.accept(rawString.substring(lastIdx, idx));
                lastIdx = idx + 1;
            }
            leftover.set(rawString.substring(lastIdx));
        };
    }

    public static StringPrinter systemOut() {
        return new StringPrinter(System.out::print);
    }

    public static StringPrinter systemErr() {
        return new StringPrinter(System.err::print);
    }
}

