/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class Functions {
    private Functions() {
    }

    public static <E> Function<E, E> identity() {
        return Function.identity();
    }

    public static <K, V> Function<K, V> forMap(Map<K, V> map) {
        return key -> {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Key '" + key + "' not present in map");
        };
    }

    public static <K, V> Function<K, V> forMap(Map<K, ? extends V> map, @Nullable V defaultValue) {
        return key -> map.containsKey(key) ? map.get(key) : defaultValue;
    }

    public static <A, B, C> Function<A, C> compose(Function<B, C> g, Function<A, ? extends B> f) {
        return g.compose(f);
    }

    public static <T> Function<T, Boolean> forPredicate(Predicate<T> predicate) {
        return predicate::test;
    }

    public static <E> Function<Object, E> constant(@Nullable E value) {
        return input -> value;
    }

    public static <T> Function<Object, T> forSupplier(Supplier<T> supplier) {
        return input -> supplier.get();
    }
}

