/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.Unhandled;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Either<L, R> {
    public boolean isLeft();

    default public boolean isRight() {
        return !this.isLeft();
    }

    public L getLeft();

    public R getRight();

    default public void ifLeft(Consumer<? super L> consumer) {
        if (this.isLeft()) {
            consumer.accept(this.getLeft());
        }
    }

    default public void ifRight(Consumer<? super R> consumer) {
        if (this.isRight()) {
            consumer.accept(this.getRight());
        }
    }

    default public Optional<L> asOptionalLeft() {
        return this.fold(Optional::of, val -> Optional.empty());
    }

    default public Optional<R> asOptionalRight() {
        return this.fold(val -> Optional.empty(), Optional::of);
    }

    default public <T> T fold(Function<? super L, ? extends T> left, Function<? super R, ? extends T> right) {
        if (this.isLeft()) {
            return left.apply(this.getLeft());
        }
        return right.apply(this.getRight());
    }

    default public void accept(Consumer<? super L> left, Consumer<? super R> right) {
        if (this.isLeft()) {
            left.accept(this.getLeft());
        } else {
            right.accept(this.getRight());
        }
    }

    default public <T> Either<T, R> mapLeft(Function<? super L, ? extends T> mapper) {
        if (this.isLeft()) {
            return Either.createLeft(mapper.apply(this.getLeft()));
        }
        return this;
    }

    default public <T> Either<L, T> mapRight(Function<? super R, ? extends T> mapper) {
        if (this.isLeft()) {
            return this;
        }
        return Either.createRight(mapper.apply(this.getRight()));
    }

    default public void acceptBoth(Consumer<? super L> left, Consumer<? super R> right, L defaultLeft, R defaultRight) {
        left.accept(this.isLeft() ? this.getLeft() : defaultLeft);
        right.accept(this.isRight() ? this.getRight() : defaultRight);
    }

    public static <L, R> Either<L, R> create(L l, R r) {
        if (l == null && r != null) {
            return Either.createRight(r);
        }
        if (l != null && r == null) {
            return Either.createLeft(l);
        }
        if (l == null) {
            throw new IllegalArgumentException("Both arguments were null.");
        }
        throw new IllegalArgumentException("Both arguments were non-null: " + l + " " + r);
    }

    public static <L, R> Either<L, R> createLeft(L l) {
        return new Left(l);
    }

    public static <L, R> Either<L, R> createRight(R r) {
        return new Right(r);
    }

    public static final class Right<L, R>
    implements Either<L, R> {
        private final R value;

        public Right(R value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public L getLeft() {
            throw Unhandled.operationException();
        }

        @Override
        public R getRight() {
            return this.value;
        }

        public boolean equals(Object otherObj) {
            if (otherObj instanceof Right) {
                return Objects.equals(this.value, ((Right)otherObj).value);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(Right.class, this.value);
        }

        public String toString() {
            return "Right[" + this.value.toString() + "]";
        }
    }

    public static final class Left<L, R>
    implements Either<L, R> {
        private final L value;

        public Left(L value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public L getLeft() {
            return this.value;
        }

        @Override
        public R getRight() {
            throw Unhandled.operationException();
        }

        public boolean equals(Object otherObj) {
            if (otherObj instanceof Left) {
                return Objects.equals(this.value, ((Left)otherObj).value);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(Left.class, this.value);
        }

        public String toString() {
            return "Left[" + this.value.toString() + "]";
        }
    }
}

