/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.Unhandled;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;

public enum Comparison {
    LESSER,
    EQUAL,
    GREATER;


    public <T> T lesserEqualGreater(T lesser, T equal, T greater) {
        switch (this) {
            case LESSER: {
                return lesser;
            }
            case EQUAL: {
                return equal;
            }
            case GREATER: {
                return greater;
            }
        }
        throw Unhandled.enumException(this);
    }

    public static <T extends Comparable<T>> Comparison compare(T a, T b) {
        return Comparison.from(a.compareTo(b));
    }

    public static <T> Comparison compare(Comparator<T> comparator, T a, T b) {
        return Comparison.from(comparator.compare(a, b));
    }

    @SuppressFBWarnings(value={"UC_USELESS_CONDITION"}, justification="Throwing Unhandled keeps the full-enumeration more explicit.")
    public static Comparison from(int compareToResult) {
        if (compareToResult == 0) {
            return EQUAL;
        }
        if (compareToResult < 0) {
            return LESSER;
        }
        if (compareToResult > 0) {
            return GREATER;
        }
        throw Unhandled.integerException(compareToResult);
    }
}

