/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public interface Box<T>
extends Supplier<T>,
Consumer<T> {
    public void set(T var1);

    @Override
    default public void accept(T value) {
        this.set(value);
    }

    default public T modify(Function<? super T, ? extends T> mutator) {
        T modified = mutator.apply(this.get());
        this.set(modified);
        return modified;
    }

    default public <R> Box<R> map(Function<? super T, ? extends R> getMapper, Function<? super R, ? extends T> setMapper) {
        return Box.from(() -> getMapper.apply((T)this.get()), toSet -> this.set(setMapper.apply((Object)toSet)));
    }

    public static <T> Box<T> of(T value) {
        return new Default<T>(value);
    }

    public static <T> Box<T> from(final Supplier<T> getter, final Consumer<T> setter) {
        return new Box<T>(){

            @Override
            public T get() {
                return Objects.requireNonNull(getter.get());
            }

            @Override
            public void set(T value) {
                setter.accept(Objects.requireNonNull(value));
            }
        };
    }

    public static <T, V> Box<T> from(final V target, final Function<V, T> getter, final BiConsumer<V, T> setter) {
        return new Box<T>(){

            @Override
            public T get() {
                return Objects.requireNonNull(getter.apply(target));
            }

            @Override
            public void set(T value) {
                setter.accept(target, Objects.requireNonNull(value));
            }
        };
    }

    public static interface Int
    extends IntSupplier,
    IntConsumer {
        public void set(int var1);

        public int get();

        @Override
        default public void accept(int value) {
            this.set(value);
        }

        @Override
        default public int getAsInt() {
            return this.get();
        }

        public static Int of(int value) {
            return new Default(value);
        }

        public static Int from(final IntSupplier getter, final IntConsumer setter) {
            return new Int(){

                @Override
                public int get() {
                    return getter.getAsInt();
                }

                @Override
                public void set(int value) {
                    setter.accept(value);
                }
            };
        }

        public static class Default
        implements Int {
            protected volatile int obj;

            protected Default(int init) {
                this.obj = init;
            }

            @Override
            public int get() {
                return this.obj;
            }

            @Override
            public void set(int obj) {
                this.obj = obj;
            }

            public String toString() {
                return "Box.Int[" + this.obj + "]";
            }
        }
    }

    public static interface Dbl
    extends DoubleSupplier,
    DoubleConsumer {
        public void set(double var1);

        public double get();

        @Override
        default public void accept(double value) {
            this.set(value);
        }

        @Override
        default public double getAsDouble() {
            return this.get();
        }

        public static Dbl of(double value) {
            return new Default(value);
        }

        public static Dbl from(final DoubleSupplier getter, final DoubleConsumer setter) {
            return new Dbl(){

                @Override
                public double get() {
                    return getter.getAsDouble();
                }

                @Override
                public void set(double value) {
                    setter.accept(value);
                }
            };
        }

        public static class Default
        implements Dbl {
            protected volatile double obj;

            protected Default(double init) {
                this.obj = init;
            }

            @Override
            public double get() {
                return this.obj;
            }

            @Override
            public void set(double obj) {
                this.obj = obj;
            }

            public String toString() {
                return "Box.Double[" + this.obj + "]";
            }
        }
    }

    public static interface Nullable<T>
    extends Supplier<T>,
    Consumer<T> {
        public void set(T var1);

        @Override
        default public void accept(T value) {
            this.set(value);
        }

        default public T modify(Function<? super T, ? extends T> mutator) {
            T modified = mutator.apply(this.get());
            this.set(modified);
            return modified;
        }

        default public <R> Nullable<R> map(Function<? super T, ? extends R> getMapper, Function<? super R, ? extends T> setMapper) {
            return Nullable.from(() -> getMapper.apply((T)this.get()), toSet -> this.set(setMapper.apply((Object)toSet)));
        }

        public static <T> Nullable<T> of(T init) {
            return new Default<T>(init);
        }

        public static <T> Nullable<T> ofNull() {
            return new Default<Object>(null);
        }

        public static <T> Nullable<T> from(final Supplier<T> getter, final Consumer<T> setter) {
            return new Nullable<T>(){

                @Override
                public T get() {
                    return getter.get();
                }

                @Override
                public void set(T value) {
                    setter.accept(value);
                }
            };
        }

        public static <T, V> Nullable<T> from(final V target, final Function<V, T> getter, final BiConsumer<V, T> setter) {
            return new Nullable<T>(){

                @Override
                public T get() {
                    return getter.apply(target);
                }

                @Override
                public void set(T value) {
                    setter.accept(target, value);
                }
            };
        }

        public static class Default<T>
        implements Nullable<T> {
            protected volatile T obj;

            protected Default(T init) {
                this.obj = init;
            }

            @Override
            public T get() {
                return this.obj;
            }

            @Override
            public void set(T obj) {
                this.obj = obj;
            }

            public String toString() {
                return "Box.Nullable[" + (this.get() == null ? "null" : this.get().toString()) + "]";
            }
        }
    }

    public static class Default<T>
    implements Box<T> {
        protected volatile T obj;

        protected Default(T init) {
            this.obj = Objects.requireNonNull(init);
        }

        @Override
        public T get() {
            return this.obj;
        }

        @Override
        public void set(T obj) {
            this.obj = Objects.requireNonNull(obj);
        }

        public String toString() {
            return "Box[" + this.get().toString() + "]";
        }
    }
}

