/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.binaryauthorization.v1beta1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.binaryauthorization.v1beta1.BinaryAuthorizationRequest;
import com.google.api.services.binaryauthorization.v1beta1.BinaryAuthorizationRequestInitializer;
import com.google.api.services.binaryauthorization.v1beta1.model.Attestor;
import com.google.api.services.binaryauthorization.v1beta1.model.Empty;
import com.google.api.services.binaryauthorization.v1beta1.model.IamPolicy;
import com.google.api.services.binaryauthorization.v1beta1.model.ListAttestorsResponse;
import com.google.api.services.binaryauthorization.v1beta1.model.Policy;
import com.google.api.services.binaryauthorization.v1beta1.model.SetIamPolicyRequest;
import com.google.api.services.binaryauthorization.v1beta1.model.TestIamPermissionsRequest;
import com.google.api.services.binaryauthorization.v1beta1.model.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryAuthorization
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://binaryauthorization.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://binaryauthorization.googleapis.com/";

    public BinaryAuthorization(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    BinaryAuthorization(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Binary Authorization API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://binaryauthorization.googleapis.com/", BinaryAuthorization.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(BinaryAuthorization.DEFAULT_BATCH_PATH);
        }

        public BinaryAuthorization build() {
            return new BinaryAuthorization(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setBinaryAuthorizationRequestInitializer(BinaryAuthorizationRequestInitializer binaryAuthorizationRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)binaryAuthorizationRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public GetPolicy getPolicy(String string) throws IOException {
            GetPolicy getPolicy = new GetPolicy(string);
            BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)getPolicy);
            return getPolicy;
        }

        public UpdatePolicy updatePolicy(String string, com.google.api.services.binaryauthorization.v1beta1.model.Policy policy) throws IOException {
            UpdatePolicy updatePolicy = new UpdatePolicy(string, policy);
            BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)updatePolicy);
            return updatePolicy;
        }

        public Attestors attestors() {
            return new Attestors();
        }

        public Policy policy() {
            return new Policy();
        }

        public class Policy {
            public GetIamPolicy getIamPolicy(String string) throws IOException {
                GetIamPolicy getIamPolicy = new GetIamPolicy(string);
                BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                return getIamPolicy;
            }

            public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                return setIamPolicy;
            }

            public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                return testIamPermissions;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class TestIamPermissions
            extends BinaryAuthorizationRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                    super(BinaryAuthorization.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/policy$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/policy$");
                    }
                }

                public TestIamPermissions set$Xgafv(String string) {
                    return (TestIamPermissions)super.set$Xgafv(string);
                }

                public TestIamPermissions setAccessToken(String string) {
                    return (TestIamPermissions)super.setAccessToken(string);
                }

                public TestIamPermissions setAlt(String string) {
                    return (TestIamPermissions)super.setAlt(string);
                }

                public TestIamPermissions setCallback(String string) {
                    return (TestIamPermissions)super.setCallback(string);
                }

                public TestIamPermissions setFields(String string) {
                    return (TestIamPermissions)super.setFields(string);
                }

                public TestIamPermissions setKey(String string) {
                    return (TestIamPermissions)super.setKey(string);
                }

                public TestIamPermissions setOauthToken(String string) {
                    return (TestIamPermissions)super.setOauthToken(string);
                }

                public TestIamPermissions setPrettyPrint(Boolean bl) {
                    return (TestIamPermissions)super.setPrettyPrint(bl);
                }

                public TestIamPermissions setQuotaUser(String string) {
                    return (TestIamPermissions)super.setQuotaUser(string);
                }

                public TestIamPermissions setUploadType(String string) {
                    return (TestIamPermissions)super.setUploadType(string);
                }

                public TestIamPermissions setUploadProtocol(String string) {
                    return (TestIamPermissions)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String string) {
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/policy$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public TestIamPermissions set(String string, Object object) {
                    return (TestIamPermissions)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SetIamPolicy
            extends BinaryAuthorizationRequest<IamPolicy> {
                private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                    super(BinaryAuthorization.this, "POST", REST_PATH, (Object)setIamPolicyRequest, IamPolicy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/policy$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/policy$");
                    }
                }

                public SetIamPolicy set$Xgafv(String string) {
                    return (SetIamPolicy)super.set$Xgafv(string);
                }

                public SetIamPolicy setAccessToken(String string) {
                    return (SetIamPolicy)super.setAccessToken(string);
                }

                public SetIamPolicy setAlt(String string) {
                    return (SetIamPolicy)super.setAlt(string);
                }

                public SetIamPolicy setCallback(String string) {
                    return (SetIamPolicy)super.setCallback(string);
                }

                public SetIamPolicy setFields(String string) {
                    return (SetIamPolicy)super.setFields(string);
                }

                public SetIamPolicy setKey(String string) {
                    return (SetIamPolicy)super.setKey(string);
                }

                public SetIamPolicy setOauthToken(String string) {
                    return (SetIamPolicy)super.setOauthToken(string);
                }

                public SetIamPolicy setPrettyPrint(Boolean bl) {
                    return (SetIamPolicy)super.setPrettyPrint(bl);
                }

                public SetIamPolicy setQuotaUser(String string) {
                    return (SetIamPolicy)super.setQuotaUser(string);
                }

                public SetIamPolicy setUploadType(String string) {
                    return (SetIamPolicy)super.setUploadType(string);
                }

                public SetIamPolicy setUploadProtocol(String string) {
                    return (SetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String string) {
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/policy$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public SetIamPolicy set(String string, Object object) {
                    return (SetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetIamPolicy
            extends BinaryAuthorizationRequest<IamPolicy> {
                private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected GetIamPolicy(String string) {
                    super(BinaryAuthorization.this, "GET", REST_PATH, null, IamPolicy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/policy$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/policy$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetIamPolicy set$Xgafv(String string) {
                    return (GetIamPolicy)super.set$Xgafv(string);
                }

                public GetIamPolicy setAccessToken(String string) {
                    return (GetIamPolicy)super.setAccessToken(string);
                }

                public GetIamPolicy setAlt(String string) {
                    return (GetIamPolicy)super.setAlt(string);
                }

                public GetIamPolicy setCallback(String string) {
                    return (GetIamPolicy)super.setCallback(string);
                }

                public GetIamPolicy setFields(String string) {
                    return (GetIamPolicy)super.setFields(string);
                }

                public GetIamPolicy setKey(String string) {
                    return (GetIamPolicy)super.setKey(string);
                }

                public GetIamPolicy setOauthToken(String string) {
                    return (GetIamPolicy)super.setOauthToken(string);
                }

                public GetIamPolicy setPrettyPrint(Boolean bl) {
                    return (GetIamPolicy)super.setPrettyPrint(bl);
                }

                public GetIamPolicy setQuotaUser(String string) {
                    return (GetIamPolicy)super.setQuotaUser(string);
                }

                public GetIamPolicy setUploadType(String string) {
                    return (GetIamPolicy)super.setUploadType(string);
                }

                public GetIamPolicy setUploadProtocol(String string) {
                    return (GetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String string) {
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/policy$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public GetIamPolicy set(String string, Object object) {
                    return (GetIamPolicy)super.set(string, object);
                }
            }
        }

        public class Attestors {
            public Create create(String string, Attestor attestor) throws IOException {
                Create create = new Create(string, attestor);
                BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GetIamPolicy getIamPolicy(String string) throws IOException {
                GetIamPolicy getIamPolicy = new GetIamPolicy(string);
                BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                return getIamPolicy;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                return setIamPolicy;
            }

            public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                return testIamPermissions;
            }

            public Update update(String string, Attestor attestor) throws IOException {
                Update update = new Update(string, attestor);
                BinaryAuthorization.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends BinaryAuthorizationRequest<Attestor> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Update(String string, Attestor attestor) {
                    super(BinaryAuthorization.this, "PUT", REST_PATH, (Object)attestor, Attestor.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/attestors/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Update setName(String string) {
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class TestIamPermissions
            extends BinaryAuthorizationRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                    super(BinaryAuthorization.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/attestors/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String string) {
                    return (TestIamPermissions)super.set$Xgafv(string);
                }

                public TestIamPermissions setAccessToken(String string) {
                    return (TestIamPermissions)super.setAccessToken(string);
                }

                public TestIamPermissions setAlt(String string) {
                    return (TestIamPermissions)super.setAlt(string);
                }

                public TestIamPermissions setCallback(String string) {
                    return (TestIamPermissions)super.setCallback(string);
                }

                public TestIamPermissions setFields(String string) {
                    return (TestIamPermissions)super.setFields(string);
                }

                public TestIamPermissions setKey(String string) {
                    return (TestIamPermissions)super.setKey(string);
                }

                public TestIamPermissions setOauthToken(String string) {
                    return (TestIamPermissions)super.setOauthToken(string);
                }

                public TestIamPermissions setPrettyPrint(Boolean bl) {
                    return (TestIamPermissions)super.setPrettyPrint(bl);
                }

                public TestIamPermissions setQuotaUser(String string) {
                    return (TestIamPermissions)super.setQuotaUser(string);
                }

                public TestIamPermissions setUploadType(String string) {
                    return (TestIamPermissions)super.setUploadType(string);
                }

                public TestIamPermissions setUploadProtocol(String string) {
                    return (TestIamPermissions)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String string) {
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public TestIamPermissions set(String string, Object object) {
                    return (TestIamPermissions)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SetIamPolicy
            extends BinaryAuthorizationRequest<IamPolicy> {
                private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                    super(BinaryAuthorization.this, "POST", REST_PATH, (Object)setIamPolicyRequest, IamPolicy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/attestors/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String string) {
                    return (SetIamPolicy)super.set$Xgafv(string);
                }

                public SetIamPolicy setAccessToken(String string) {
                    return (SetIamPolicy)super.setAccessToken(string);
                }

                public SetIamPolicy setAlt(String string) {
                    return (SetIamPolicy)super.setAlt(string);
                }

                public SetIamPolicy setCallback(String string) {
                    return (SetIamPolicy)super.setCallback(string);
                }

                public SetIamPolicy setFields(String string) {
                    return (SetIamPolicy)super.setFields(string);
                }

                public SetIamPolicy setKey(String string) {
                    return (SetIamPolicy)super.setKey(string);
                }

                public SetIamPolicy setOauthToken(String string) {
                    return (SetIamPolicy)super.setOauthToken(string);
                }

                public SetIamPolicy setPrettyPrint(Boolean bl) {
                    return (SetIamPolicy)super.setPrettyPrint(bl);
                }

                public SetIamPolicy setQuotaUser(String string) {
                    return (SetIamPolicy)super.setQuotaUser(string);
                }

                public SetIamPolicy setUploadType(String string) {
                    return (SetIamPolicy)super.setUploadType(string);
                }

                public SetIamPolicy setUploadProtocol(String string) {
                    return (SetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String string) {
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public SetIamPolicy set(String string, Object object) {
                    return (SetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends BinaryAuthorizationRequest<ListAttestorsResponse> {
                private static final String REST_PATH = "v1beta1/{+parent}/attestors";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(BinaryAuthorization.this, "GET", REST_PATH, null, ListAttestorsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetIamPolicy
            extends BinaryAuthorizationRequest<IamPolicy> {
                private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected GetIamPolicy(String string) {
                    super(BinaryAuthorization.this, "GET", REST_PATH, null, IamPolicy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/attestors/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetIamPolicy set$Xgafv(String string) {
                    return (GetIamPolicy)super.set$Xgafv(string);
                }

                public GetIamPolicy setAccessToken(String string) {
                    return (GetIamPolicy)super.setAccessToken(string);
                }

                public GetIamPolicy setAlt(String string) {
                    return (GetIamPolicy)super.setAlt(string);
                }

                public GetIamPolicy setCallback(String string) {
                    return (GetIamPolicy)super.setCallback(string);
                }

                public GetIamPolicy setFields(String string) {
                    return (GetIamPolicy)super.setFields(string);
                }

                public GetIamPolicy setKey(String string) {
                    return (GetIamPolicy)super.setKey(string);
                }

                public GetIamPolicy setOauthToken(String string) {
                    return (GetIamPolicy)super.setOauthToken(string);
                }

                public GetIamPolicy setPrettyPrint(Boolean bl) {
                    return (GetIamPolicy)super.setPrettyPrint(bl);
                }

                public GetIamPolicy setQuotaUser(String string) {
                    return (GetIamPolicy)super.setQuotaUser(string);
                }

                public GetIamPolicy setUploadType(String string) {
                    return (GetIamPolicy)super.setUploadType(string);
                }

                public GetIamPolicy setUploadProtocol(String string) {
                    return (GetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String string) {
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public GetIamPolicy set(String string, Object object) {
                    return (GetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends BinaryAuthorizationRequest<Attestor> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(BinaryAuthorization.this, "GET", REST_PATH, null, Attestor.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/attestors/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends BinaryAuthorizationRequest<Empty> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String string) {
                    super(BinaryAuthorization.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/attestors/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String string) {
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/attestors/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends BinaryAuthorizationRequest<Attestor> {
                private static final String REST_PATH = "v1beta1/{+parent}/attestors";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String attestorId;

                protected Create(String string, Attestor attestor) {
                    super(BinaryAuthorization.this, "POST", REST_PATH, (Object)attestor, Attestor.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getAttestorId() {
                    return this.attestorId;
                }

                public Create setAttestorId(String string) {
                    this.attestorId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class UpdatePolicy
        extends BinaryAuthorizationRequest<com.google.api.services.binaryauthorization.v1beta1.model.Policy> {
            private static final String REST_PATH = "v1beta1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected UpdatePolicy(String string, com.google.api.services.binaryauthorization.v1beta1.model.Policy policy) {
                super(BinaryAuthorization.this, "PUT", REST_PATH, (Object)policy, com.google.api.services.binaryauthorization.v1beta1.model.Policy.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/policy$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/policy$");
                }
            }

            public UpdatePolicy set$Xgafv(String string) {
                return (UpdatePolicy)super.set$Xgafv(string);
            }

            public UpdatePolicy setAccessToken(String string) {
                return (UpdatePolicy)super.setAccessToken(string);
            }

            public UpdatePolicy setAlt(String string) {
                return (UpdatePolicy)super.setAlt(string);
            }

            public UpdatePolicy setCallback(String string) {
                return (UpdatePolicy)super.setCallback(string);
            }

            public UpdatePolicy setFields(String string) {
                return (UpdatePolicy)super.setFields(string);
            }

            public UpdatePolicy setKey(String string) {
                return (UpdatePolicy)super.setKey(string);
            }

            public UpdatePolicy setOauthToken(String string) {
                return (UpdatePolicy)super.setOauthToken(string);
            }

            public UpdatePolicy setPrettyPrint(Boolean bl) {
                return (UpdatePolicy)super.setPrettyPrint(bl);
            }

            public UpdatePolicy setQuotaUser(String string) {
                return (UpdatePolicy)super.setQuotaUser(string);
            }

            public UpdatePolicy setUploadType(String string) {
                return (UpdatePolicy)super.setUploadType(string);
            }

            public UpdatePolicy setUploadProtocol(String string) {
                return (UpdatePolicy)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public UpdatePolicy setName(String string) {
                if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/policy$");
                }
                this.name = string;
                return this;
            }

            @Override
            public UpdatePolicy set(String string, Object object) {
                return (UpdatePolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetPolicy
        extends BinaryAuthorizationRequest<com.google.api.services.binaryauthorization.v1beta1.model.Policy> {
            private static final String REST_PATH = "v1beta1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetPolicy(String string) {
                super(BinaryAuthorization.this, "GET", REST_PATH, null, com.google.api.services.binaryauthorization.v1beta1.model.Policy.class);
                this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/policy$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/policy$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetPolicy set$Xgafv(String string) {
                return (GetPolicy)super.set$Xgafv(string);
            }

            public GetPolicy setAccessToken(String string) {
                return (GetPolicy)super.setAccessToken(string);
            }

            public GetPolicy setAlt(String string) {
                return (GetPolicy)super.setAlt(string);
            }

            public GetPolicy setCallback(String string) {
                return (GetPolicy)super.setCallback(string);
            }

            public GetPolicy setFields(String string) {
                return (GetPolicy)super.setFields(string);
            }

            public GetPolicy setKey(String string) {
                return (GetPolicy)super.setKey(string);
            }

            public GetPolicy setOauthToken(String string) {
                return (GetPolicy)super.setOauthToken(string);
            }

            public GetPolicy setPrettyPrint(Boolean bl) {
                return (GetPolicy)super.setPrettyPrint(bl);
            }

            public GetPolicy setQuotaUser(String string) {
                return (GetPolicy)super.setQuotaUser(string);
            }

            public GetPolicy setUploadType(String string) {
                return (GetPolicy)super.setUploadType(string);
            }

            public GetPolicy setUploadProtocol(String string) {
                return (GetPolicy)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public GetPolicy setName(String string) {
                if (!BinaryAuthorization.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/policy$");
                }
                this.name = string;
                return this;
            }

            @Override
            public GetPolicy set(String string, Object object) {
                return (GetPolicy)super.set(string, object);
            }
        }
    }
}

