/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.k8sengine;

import com.google.jenkins.plugins.k8sengine.KubectlWrapper;
import com.google.jenkins.plugins.k8sengine.KubernetesVerifiers;
import com.google.jenkins.plugins.k8sengine.Manifests;
import com.google.jenkins.plugins.k8sengine.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.PrintStream;
import java.time.Duration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;
import reactor.retry.Backoff;
import reactor.retry.Repeat;

public class VerificationTask {
    private static final int VERIFICATION_DELAY = 5;
    private KubectlWrapper kubectl;
    private Manifests.ManifestObject manifestObject;
    private KubernetesVerifiers.VerificationResult currentResult;
    private PrintStream consoleLogger;
    private static Logger LOGGER = Logger.getLogger(VerificationTask.class.getName());

    private VerificationTask(KubectlWrapper kubectl, Manifests.ManifestObject manifestObject, PrintStream consoleLogger) {
        this.kubectl = kubectl;
        this.manifestObject = manifestObject;
        this.consoleLogger = consoleLogger;
    }

    private boolean isVerified() {
        return this.currentResult != null && this.currentResult.isVerified();
    }

    public KubernetesVerifiers.VerificationResult getVerificationResult() {
        return this.currentResult;
    }

    private VerificationTask verify() {
        this.consoleLogger.println(Messages.KubernetesEngineBuilder_VerifyingLogPrefix(this.manifestObject.describe()));
        this.currentResult = KubernetesVerifiers.verify(this.kubectl, this.manifestObject);
        if (this.isVerified()) {
            this.consoleLogger.println(this.currentResult.toString());
        }
        return this;
    }

    public static boolean verifyObjects(@NonNull KubectlWrapper kubectl, @NonNull List<Manifests.ManifestObject> manifestObjects, @NonNull PrintStream consoleLogger, int timeoutInMinutes) {
        List verificationTasks = manifestObjects.stream().map(manifestObject -> new VerificationTask(kubectl, (Manifests.ManifestObject)manifestObject, consoleLogger)).collect(Collectors.toList());
        Repeat.onlyIf(ctx -> verificationTasks.stream().map(task -> task.isVerified()).reduce(true, (acc, done) -> acc != false && done != false) == false).backoff(Backoff.fixed((Duration)Duration.ofSeconds(5L))).timeout(Duration.ofMinutes(timeoutInMinutes)).apply((Publisher)Flux.fromIterable(verificationTasks)).filter(task -> !task.isVerified()).map(task -> task.verify()).subscribeOn(Schedulers.elastic()).doOnError(error -> {
            LOGGER.log(Level.SEVERE, "Unexpected error in verifyObjects()", (Throwable)error);
            error.printStackTrace(consoleLogger);
        }).blockLast();
        List finalResults = verificationTasks.stream().map(task -> task.getVerificationResult()).collect(Collectors.toList());
        List<KubernetesVerifiers.VerificationResult> errorResults = finalResults.stream().filter(result -> !result.isVerified()).collect(Collectors.toList());
        errorResults.forEach(it -> consoleLogger.println(it.toString()));
        LOGGER.info(String.format("%d error results", errorResults.size()));
        return errorResults.size() == 0;
    }
}

