/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.k8sengine;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import com.google.jenkins.plugins.k8sengine.client.ContainerScopeRequirement;
import com.google.jenkins.plugins.k8sengine.client.Messages;
import hudson.AbortException;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.io.IOException;
import java.security.GeneralSecurityException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

public class CredentialsUtil {
    public static GoogleRobotCredentials getRobotCredentials(ItemGroup itemGroup, ImmutableList<DomainRequirement> domainRequirements, String credentialsId) throws AbortException {
        Preconditions.checkNotNull((Object)itemGroup);
        Preconditions.checkNotNull(domainRequirements);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)credentialsId) ? 1 : 0) != 0);
        GoogleRobotCredentials robotCreds = (GoogleRobotCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(GoogleRobotCredentials.class, (ItemGroup)itemGroup, (Authentication)ACL.SYSTEM, domainRequirements), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (robotCreds == null) {
            throw new AbortException(Messages.ClientFactory_FailedToRetrieveCredentials(credentialsId));
        }
        return robotCreds;
    }

    public static Credential getGoogleCredential(GoogleRobotCredentials robotCreds) throws AbortException {
        Credential credential;
        try {
            credential = robotCreds.getGoogleCredential((GoogleOAuth2ScopeRequirement)new ContainerScopeRequirement());
        }
        catch (GeneralSecurityException gse) {
            throw new AbortException(Messages.ClientFactory_FailedToInitializeHTTPTransport(gse.getMessage()));
        }
        return credential;
    }

    static String getAccessToken(ItemGroup itemGroup, String credentialsId) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)credentialsId) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)itemGroup);
        GoogleRobotCredentials robotCreds = CredentialsUtil.getRobotCredentials(itemGroup, (ImmutableList<DomainRequirement>)ImmutableList.of(), credentialsId);
        Credential googleCredential = CredentialsUtil.getGoogleCredential(robotCreds);
        return CredentialsUtil.getAccessToken(googleCredential);
    }

    static String getAccessToken(String credentialsId) throws IOException {
        return CredentialsUtil.getAccessToken((ItemGroup)Jenkins.get(), credentialsId);
    }

    static String getAccessToken(Credential googleCredential) throws IOException {
        Preconditions.checkNotNull((Object)googleCredential);
        googleCredential.refreshToken();
        return googleCredential.getAccessToken();
    }

    static String getDefaultProjectId(ItemGroup itemGroup, String credentialsId) throws AbortException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)credentialsId) ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)itemGroup);
        GoogleRobotCredentials robotCreds = CredentialsUtil.getRobotCredentials(itemGroup, (ImmutableList<DomainRequirement>)ImmutableList.of(), credentialsId);
        return Strings.isNullOrEmpty((String)robotCreds.getProjectId()) ? "" : robotCreds.getProjectId();
    }

    static String getDefaultProjectId(String credentialsId) throws AbortException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)credentialsId) ? 1 : 0) != 0);
        return CredentialsUtil.getDefaultProjectId((ItemGroup)Jenkins.get(), credentialsId);
    }
}

