/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.container;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.container.ContainerRequest;
import com.google.api.services.container.ContainerRequestInitializer;
import com.google.api.services.container.model.CancelOperationRequest;
import com.google.api.services.container.model.Cluster;
import com.google.api.services.container.model.CompleteIPRotationRequest;
import com.google.api.services.container.model.CreateClusterRequest;
import com.google.api.services.container.model.CreateNodePoolRequest;
import com.google.api.services.container.model.Empty;
import com.google.api.services.container.model.GetJSONWebKeysResponse;
import com.google.api.services.container.model.GetOpenIDConfigResponse;
import com.google.api.services.container.model.ListClustersResponse;
import com.google.api.services.container.model.ListNodePoolsResponse;
import com.google.api.services.container.model.ListOperationsResponse;
import com.google.api.services.container.model.ListUsableSubnetworksResponse;
import com.google.api.services.container.model.NodePool;
import com.google.api.services.container.model.Operation;
import com.google.api.services.container.model.RollbackNodePoolUpgradeRequest;
import com.google.api.services.container.model.ServerConfig;
import com.google.api.services.container.model.SetAddonsConfigRequest;
import com.google.api.services.container.model.SetLabelsRequest;
import com.google.api.services.container.model.SetLegacyAbacRequest;
import com.google.api.services.container.model.SetLocationsRequest;
import com.google.api.services.container.model.SetLoggingServiceRequest;
import com.google.api.services.container.model.SetMaintenancePolicyRequest;
import com.google.api.services.container.model.SetMasterAuthRequest;
import com.google.api.services.container.model.SetMonitoringServiceRequest;
import com.google.api.services.container.model.SetNetworkPolicyRequest;
import com.google.api.services.container.model.SetNodePoolAutoscalingRequest;
import com.google.api.services.container.model.SetNodePoolManagementRequest;
import com.google.api.services.container.model.SetNodePoolSizeRequest;
import com.google.api.services.container.model.StartIPRotationRequest;
import com.google.api.services.container.model.UpdateClusterRequest;
import com.google.api.services.container.model.UpdateMasterRequest;
import com.google.api.services.container.model.UpdateNodePoolRequest;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://container.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://container.googleapis.com/";

    public Container(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Container(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Kubernetes Engine API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://container.googleapis.com/", Container.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Container.DEFAULT_BATCH_PATH);
        }

        public Container build() {
            return new Container(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setContainerRequestInitializer(ContainerRequestInitializer containerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)containerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Aggregated aggregated() {
            return new Aggregated();
        }

        public Locations locations() {
            return new Locations();
        }

        public Zones zones() {
            return new Zones();
        }

        public class Zones {
            public GetServerconfig getServerconfig(String string, String string2) throws IOException {
                GetServerconfig getServerconfig = new GetServerconfig(string, string2);
                Container.this.initialize((AbstractGoogleClientRequest<?>)getServerconfig);
                return getServerconfig;
            }

            public Clusters clusters() {
                return new Clusters();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String string, String string2, String string3, CancelOperationRequest cancelOperationRequest) throws IOException {
                    Cancel cancel = new Cancel(string, string2, string3, cancelOperationRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)cancel);
                    return cancel;
                }

                public Get get(String string, String string2, String string3) throws IOException {
                    Get get = new Get(string, string2, string3);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends ContainerRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/operations";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String parent;

                    protected List(String string, String string2) {
                        super(Container.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public List setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/operations/{operationId}";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String operationId;
                    @Key
                    private String name;

                    protected Get(String string, String string2, String string3) {
                        super(Container.this, "GET", REST_PATH, null, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.operationId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter operationId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Get setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getOperationId() {
                        return this.operationId;
                    }

                    public Get setOperationId(String string) {
                        this.operationId = string;
                        return this;
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Cancel
                extends ContainerRequest<Empty> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/operations/{operationId}:cancel";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String operationId;

                    protected Cancel(String string, String string2, String string3, CancelOperationRequest cancelOperationRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)cancelOperationRequest, Empty.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.operationId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter operationId must be specified.");
                    }

                    public Cancel set$Xgafv(String string) {
                        return (Cancel)super.set$Xgafv(string);
                    }

                    public Cancel setAccessToken(String string) {
                        return (Cancel)super.setAccessToken(string);
                    }

                    public Cancel setAlt(String string) {
                        return (Cancel)super.setAlt(string);
                    }

                    public Cancel setCallback(String string) {
                        return (Cancel)super.setCallback(string);
                    }

                    public Cancel setFields(String string) {
                        return (Cancel)super.setFields(string);
                    }

                    public Cancel setKey(String string) {
                        return (Cancel)super.setKey(string);
                    }

                    public Cancel setOauthToken(String string) {
                        return (Cancel)super.setOauthToken(string);
                    }

                    public Cancel setPrettyPrint(Boolean bl) {
                        return (Cancel)super.setPrettyPrint(bl);
                    }

                    public Cancel setQuotaUser(String string) {
                        return (Cancel)super.setQuotaUser(string);
                    }

                    public Cancel setUploadType(String string) {
                        return (Cancel)super.setUploadType(string);
                    }

                    public Cancel setUploadProtocol(String string) {
                        return (Cancel)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Cancel setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Cancel setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getOperationId() {
                        return this.operationId;
                    }

                    public Cancel setOperationId(String string) {
                        this.operationId = string;
                        return this;
                    }

                    @Override
                    public Cancel set(String string, Object object) {
                        return (Cancel)super.set(string, object);
                    }
                }
            }

            public class Clusters {
                public Addons addons(String string, String string2, String string3, SetAddonsConfigRequest setAddonsConfigRequest) throws IOException {
                    Addons addons = new Addons(string, string2, string3, setAddonsConfigRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)addons);
                    return addons;
                }

                public CompleteIpRotation completeIpRotation(String string, String string2, String string3, CompleteIPRotationRequest completeIPRotationRequest) throws IOException {
                    CompleteIpRotation completeIpRotation = new CompleteIpRotation(string, string2, string3, completeIPRotationRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)completeIpRotation);
                    return completeIpRotation;
                }

                public Create create(String string, String string2, CreateClusterRequest createClusterRequest) throws IOException {
                    Create create = new Create(string, string2, createClusterRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string, String string2, String string3) throws IOException {
                    Delete delete = new Delete(string, string2, string3);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string, String string2, String string3) throws IOException {
                    Get get = new Get(string, string2, string3);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public LegacyAbac legacyAbac(String string, String string2, String string3, SetLegacyAbacRequest setLegacyAbacRequest) throws IOException {
                    LegacyAbac legacyAbac = new LegacyAbac(string, string2, string3, setLegacyAbacRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)legacyAbac);
                    return legacyAbac;
                }

                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Locations locations(String string, String string2, String string3, SetLocationsRequest setLocationsRequest) throws IOException {
                    Locations locations = new Locations(string, string2, string3, setLocationsRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)locations);
                    return locations;
                }

                public Logging logging(String string, String string2, String string3, SetLoggingServiceRequest setLoggingServiceRequest) throws IOException {
                    Logging logging = new Logging(string, string2, string3, setLoggingServiceRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)logging);
                    return logging;
                }

                public Master master(String string, String string2, String string3, UpdateMasterRequest updateMasterRequest) throws IOException {
                    Master master = new Master(string, string2, string3, updateMasterRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)master);
                    return master;
                }

                public Monitoring monitoring(String string, String string2, String string3, SetMonitoringServiceRequest setMonitoringServiceRequest) throws IOException {
                    Monitoring monitoring = new Monitoring(string, string2, string3, setMonitoringServiceRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)monitoring);
                    return monitoring;
                }

                public ResourceLabels resourceLabels(String string, String string2, String string3, SetLabelsRequest setLabelsRequest) throws IOException {
                    ResourceLabels resourceLabels = new ResourceLabels(string, string2, string3, setLabelsRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)resourceLabels);
                    return resourceLabels;
                }

                public SetMaintenancePolicy setMaintenancePolicy(String string, String string2, String string3, SetMaintenancePolicyRequest setMaintenancePolicyRequest) throws IOException {
                    SetMaintenancePolicy setMaintenancePolicy = new SetMaintenancePolicy(string, string2, string3, setMaintenancePolicyRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setMaintenancePolicy);
                    return setMaintenancePolicy;
                }

                public SetMasterAuth setMasterAuth(String string, String string2, String string3, SetMasterAuthRequest setMasterAuthRequest) throws IOException {
                    SetMasterAuth setMasterAuth = new SetMasterAuth(string, string2, string3, setMasterAuthRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setMasterAuth);
                    return setMasterAuth;
                }

                public SetNetworkPolicy setNetworkPolicy(String string, String string2, String string3, SetNetworkPolicyRequest setNetworkPolicyRequest) throws IOException {
                    SetNetworkPolicy setNetworkPolicy = new SetNetworkPolicy(string, string2, string3, setNetworkPolicyRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setNetworkPolicy);
                    return setNetworkPolicy;
                }

                public StartIpRotation startIpRotation(String string, String string2, String string3, StartIPRotationRequest startIPRotationRequest) throws IOException {
                    StartIpRotation startIpRotation = new StartIpRotation(string, string2, string3, startIPRotationRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)startIpRotation);
                    return startIpRotation;
                }

                public Update update(String string, String string2, String string3, UpdateClusterRequest updateClusterRequest) throws IOException {
                    Update update = new Update(string, string2, string3, updateClusterRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)update);
                    return update;
                }

                public NodePools nodePools() {
                    return new NodePools();
                }

                public class NodePools {
                    public Autoscaling autoscaling(String string, String string2, String string3, String string4, SetNodePoolAutoscalingRequest setNodePoolAutoscalingRequest) throws IOException {
                        Autoscaling autoscaling = new Autoscaling(string, string2, string3, string4, setNodePoolAutoscalingRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)autoscaling);
                        return autoscaling;
                    }

                    public Create create(String string, String string2, String string3, CreateNodePoolRequest createNodePoolRequest) throws IOException {
                        Create create = new Create(string, string2, string3, createNodePoolRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)create);
                        return create;
                    }

                    public Delete delete(String string, String string2, String string3, String string4) throws IOException {
                        Delete delete = new Delete(string, string2, string3, string4);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)delete);
                        return delete;
                    }

                    public Get get(String string, String string2, String string3, String string4) throws IOException {
                        Get get = new Get(string, string2, string3, string4);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)get);
                        return get;
                    }

                    public List list(String string, String string2, String string3) throws IOException {
                        List list = new List(string, string2, string3);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)list);
                        return list;
                    }

                    public Rollback rollback(String string, String string2, String string3, String string4, RollbackNodePoolUpgradeRequest rollbackNodePoolUpgradeRequest) throws IOException {
                        Rollback rollback = new Rollback(string, string2, string3, string4, rollbackNodePoolUpgradeRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)rollback);
                        return rollback;
                    }

                    public SetManagement setManagement(String string, String string2, String string3, String string4, SetNodePoolManagementRequest setNodePoolManagementRequest) throws IOException {
                        SetManagement setManagement = new SetManagement(string, string2, string3, string4, setNodePoolManagementRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)setManagement);
                        return setManagement;
                    }

                    public SetSize setSize(String string, String string2, String string3, String string4, SetNodePoolSizeRequest setNodePoolSizeRequest) throws IOException {
                        SetSize setSize = new SetSize(string, string2, string3, string4, setNodePoolSizeRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)setSize);
                        return setSize;
                    }

                    public Update update(String string, String string2, String string3, String string4, UpdateNodePoolRequest updateNodePoolRequest) throws IOException {
                        Update update = new Update(string, string2, string3, string4, updateNodePoolRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)update);
                        return update;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Update
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/update";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;

                        protected Update(String string, String string2, String string3, String string4, UpdateNodePoolRequest updateNodePoolRequest) {
                            super(Container.this, "POST", REST_PATH, (Object)updateNodePoolRequest, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public Update set$Xgafv(String string) {
                            return (Update)super.set$Xgafv(string);
                        }

                        public Update setAccessToken(String string) {
                            return (Update)super.setAccessToken(string);
                        }

                        public Update setAlt(String string) {
                            return (Update)super.setAlt(string);
                        }

                        public Update setCallback(String string) {
                            return (Update)super.setCallback(string);
                        }

                        public Update setFields(String string) {
                            return (Update)super.setFields(string);
                        }

                        public Update setKey(String string) {
                            return (Update)super.setKey(string);
                        }

                        public Update setOauthToken(String string) {
                            return (Update)super.setOauthToken(string);
                        }

                        public Update setPrettyPrint(Boolean bl) {
                            return (Update)super.setPrettyPrint(bl);
                        }

                        public Update setQuotaUser(String string) {
                            return (Update)super.setQuotaUser(string);
                        }

                        public Update setUploadType(String string) {
                            return (Update)super.setUploadType(string);
                        }

                        public Update setUploadProtocol(String string) {
                            return (Update)super.setUploadProtocol(string);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Update setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Update setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Update setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Update setNodePoolId(String string) {
                            this.nodePoolId = string;
                            return this;
                        }

                        @Override
                        public Update set(String string, Object object) {
                            return (Update)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class SetSize
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setSize";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;

                        protected SetSize(String string, String string2, String string3, String string4, SetNodePoolSizeRequest setNodePoolSizeRequest) {
                            super(Container.this, "POST", REST_PATH, (Object)setNodePoolSizeRequest, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public SetSize set$Xgafv(String string) {
                            return (SetSize)super.set$Xgafv(string);
                        }

                        public SetSize setAccessToken(String string) {
                            return (SetSize)super.setAccessToken(string);
                        }

                        public SetSize setAlt(String string) {
                            return (SetSize)super.setAlt(string);
                        }

                        public SetSize setCallback(String string) {
                            return (SetSize)super.setCallback(string);
                        }

                        public SetSize setFields(String string) {
                            return (SetSize)super.setFields(string);
                        }

                        public SetSize setKey(String string) {
                            return (SetSize)super.setKey(string);
                        }

                        public SetSize setOauthToken(String string) {
                            return (SetSize)super.setOauthToken(string);
                        }

                        public SetSize setPrettyPrint(Boolean bl) {
                            return (SetSize)super.setPrettyPrint(bl);
                        }

                        public SetSize setQuotaUser(String string) {
                            return (SetSize)super.setQuotaUser(string);
                        }

                        public SetSize setUploadType(String string) {
                            return (SetSize)super.setUploadType(string);
                        }

                        public SetSize setUploadProtocol(String string) {
                            return (SetSize)super.setUploadProtocol(string);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public SetSize setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public SetSize setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public SetSize setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public SetSize setNodePoolId(String string) {
                            this.nodePoolId = string;
                            return this;
                        }

                        @Override
                        public SetSize set(String string, Object object) {
                            return (SetSize)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class SetManagement
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/setManagement";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;

                        protected SetManagement(String string, String string2, String string3, String string4, SetNodePoolManagementRequest setNodePoolManagementRequest) {
                            super(Container.this, "POST", REST_PATH, (Object)setNodePoolManagementRequest, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public SetManagement set$Xgafv(String string) {
                            return (SetManagement)super.set$Xgafv(string);
                        }

                        public SetManagement setAccessToken(String string) {
                            return (SetManagement)super.setAccessToken(string);
                        }

                        public SetManagement setAlt(String string) {
                            return (SetManagement)super.setAlt(string);
                        }

                        public SetManagement setCallback(String string) {
                            return (SetManagement)super.setCallback(string);
                        }

                        public SetManagement setFields(String string) {
                            return (SetManagement)super.setFields(string);
                        }

                        public SetManagement setKey(String string) {
                            return (SetManagement)super.setKey(string);
                        }

                        public SetManagement setOauthToken(String string) {
                            return (SetManagement)super.setOauthToken(string);
                        }

                        public SetManagement setPrettyPrint(Boolean bl) {
                            return (SetManagement)super.setPrettyPrint(bl);
                        }

                        public SetManagement setQuotaUser(String string) {
                            return (SetManagement)super.setQuotaUser(string);
                        }

                        public SetManagement setUploadType(String string) {
                            return (SetManagement)super.setUploadType(string);
                        }

                        public SetManagement setUploadProtocol(String string) {
                            return (SetManagement)super.setUploadProtocol(string);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public SetManagement setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public SetManagement setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public SetManagement setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public SetManagement setNodePoolId(String string) {
                            this.nodePoolId = string;
                            return this;
                        }

                        @Override
                        public SetManagement set(String string, Object object) {
                            return (SetManagement)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Rollback
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}:rollback";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;

                        protected Rollback(String string, String string2, String string3, String string4, RollbackNodePoolUpgradeRequest rollbackNodePoolUpgradeRequest) {
                            super(Container.this, "POST", REST_PATH, (Object)rollbackNodePoolUpgradeRequest, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public Rollback set$Xgafv(String string) {
                            return (Rollback)super.set$Xgafv(string);
                        }

                        public Rollback setAccessToken(String string) {
                            return (Rollback)super.setAccessToken(string);
                        }

                        public Rollback setAlt(String string) {
                            return (Rollback)super.setAlt(string);
                        }

                        public Rollback setCallback(String string) {
                            return (Rollback)super.setCallback(string);
                        }

                        public Rollback setFields(String string) {
                            return (Rollback)super.setFields(string);
                        }

                        public Rollback setKey(String string) {
                            return (Rollback)super.setKey(string);
                        }

                        public Rollback setOauthToken(String string) {
                            return (Rollback)super.setOauthToken(string);
                        }

                        public Rollback setPrettyPrint(Boolean bl) {
                            return (Rollback)super.setPrettyPrint(bl);
                        }

                        public Rollback setQuotaUser(String string) {
                            return (Rollback)super.setQuotaUser(string);
                        }

                        public Rollback setUploadType(String string) {
                            return (Rollback)super.setUploadType(string);
                        }

                        public Rollback setUploadProtocol(String string) {
                            return (Rollback)super.setUploadProtocol(string);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Rollback setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Rollback setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Rollback setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Rollback setNodePoolId(String string) {
                            this.nodePoolId = string;
                            return this;
                        }

                        @Override
                        public Rollback set(String string, Object object) {
                            return (Rollback)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class List
                    extends ContainerRequest<ListNodePoolsResponse> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String parent;

                        protected List(String string, String string2, String string3) {
                            super(Container.this, "GET", REST_PATH, null, ListNodePoolsResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String string) {
                            return (List)super.set$Xgafv(string);
                        }

                        public List setAccessToken(String string) {
                            return (List)super.setAccessToken(string);
                        }

                        public List setAlt(String string) {
                            return (List)super.setAlt(string);
                        }

                        public List setCallback(String string) {
                            return (List)super.setCallback(string);
                        }

                        public List setFields(String string) {
                            return (List)super.setFields(string);
                        }

                        public List setKey(String string) {
                            return (List)super.setKey(string);
                        }

                        public List setOauthToken(String string) {
                            return (List)super.setOauthToken(string);
                        }

                        public List setPrettyPrint(Boolean bl) {
                            return (List)super.setPrettyPrint(bl);
                        }

                        public List setQuotaUser(String string) {
                            return (List)super.setQuotaUser(string);
                        }

                        public List setUploadType(String string) {
                            return (List)super.setUploadType(string);
                        }

                        public List setUploadProtocol(String string) {
                            return (List)super.setUploadProtocol(string);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public List setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public List setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public List setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String string) {
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public List set(String string, Object object) {
                            return (List)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Get
                    extends ContainerRequest<NodePool> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;
                        @Key
                        private String name;

                        protected Get(String string, String string2, String string3, String string4) {
                            super(Container.this, "GET", REST_PATH, null, NodePool.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String string) {
                            return (Get)super.set$Xgafv(string);
                        }

                        public Get setAccessToken(String string) {
                            return (Get)super.setAccessToken(string);
                        }

                        public Get setAlt(String string) {
                            return (Get)super.setAlt(string);
                        }

                        public Get setCallback(String string) {
                            return (Get)super.setCallback(string);
                        }

                        public Get setFields(String string) {
                            return (Get)super.setFields(string);
                        }

                        public Get setKey(String string) {
                            return (Get)super.setKey(string);
                        }

                        public Get setOauthToken(String string) {
                            return (Get)super.setOauthToken(string);
                        }

                        public Get setPrettyPrint(Boolean bl) {
                            return (Get)super.setPrettyPrint(bl);
                        }

                        public Get setQuotaUser(String string) {
                            return (Get)super.setQuotaUser(string);
                        }

                        public Get setUploadType(String string) {
                            return (Get)super.setUploadType(string);
                        }

                        public Get setUploadProtocol(String string) {
                            return (Get)super.setUploadProtocol(string);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Get setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Get setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Get setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Get setNodePoolId(String string) {
                            this.nodePoolId = string;
                            return this;
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String string) {
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Get set(String string, Object object) {
                            return (Get)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Delete
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;
                        @Key
                        private String name;

                        protected Delete(String string, String string2, String string3, String string4) {
                            super(Container.this, "DELETE", REST_PATH, null, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public Delete set$Xgafv(String string) {
                            return (Delete)super.set$Xgafv(string);
                        }

                        public Delete setAccessToken(String string) {
                            return (Delete)super.setAccessToken(string);
                        }

                        public Delete setAlt(String string) {
                            return (Delete)super.setAlt(string);
                        }

                        public Delete setCallback(String string) {
                            return (Delete)super.setCallback(string);
                        }

                        public Delete setFields(String string) {
                            return (Delete)super.setFields(string);
                        }

                        public Delete setKey(String string) {
                            return (Delete)super.setKey(string);
                        }

                        public Delete setOauthToken(String string) {
                            return (Delete)super.setOauthToken(string);
                        }

                        public Delete setPrettyPrint(Boolean bl) {
                            return (Delete)super.setPrettyPrint(bl);
                        }

                        public Delete setQuotaUser(String string) {
                            return (Delete)super.setQuotaUser(string);
                        }

                        public Delete setUploadType(String string) {
                            return (Delete)super.setUploadType(string);
                        }

                        public Delete setUploadProtocol(String string) {
                            return (Delete)super.setUploadProtocol(string);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Delete setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Delete setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Delete setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Delete setNodePoolId(String string) {
                            this.nodePoolId = string;
                            return this;
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String string) {
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Delete set(String string, Object object) {
                            return (Delete)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Create
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;

                        protected Create(String string, String string2, String string3, CreateNodePoolRequest createNodePoolRequest) {
                            super(Container.this, "POST", REST_PATH, (Object)createNodePoolRequest, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                        }

                        public Create set$Xgafv(String string) {
                            return (Create)super.set$Xgafv(string);
                        }

                        public Create setAccessToken(String string) {
                            return (Create)super.setAccessToken(string);
                        }

                        public Create setAlt(String string) {
                            return (Create)super.setAlt(string);
                        }

                        public Create setCallback(String string) {
                            return (Create)super.setCallback(string);
                        }

                        public Create setFields(String string) {
                            return (Create)super.setFields(string);
                        }

                        public Create setKey(String string) {
                            return (Create)super.setKey(string);
                        }

                        public Create setOauthToken(String string) {
                            return (Create)super.setOauthToken(string);
                        }

                        public Create setPrettyPrint(Boolean bl) {
                            return (Create)super.setPrettyPrint(bl);
                        }

                        public Create setQuotaUser(String string) {
                            return (Create)super.setQuotaUser(string);
                        }

                        public Create setUploadType(String string) {
                            return (Create)super.setUploadType(string);
                        }

                        public Create setUploadProtocol(String string) {
                            return (Create)super.setUploadProtocol(string);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Create setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Create setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Create setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        @Override
                        public Create set(String string, Object object) {
                            return (Create)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Autoscaling
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/nodePools/{nodePoolId}/autoscaling";
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;

                        protected Autoscaling(String string, String string2, String string3, String string4, SetNodePoolAutoscalingRequest setNodePoolAutoscalingRequest) {
                            super(Container.this, "POST", REST_PATH, (Object)setNodePoolAutoscalingRequest, Operation.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                            this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                            this.nodePoolId = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter nodePoolId must be specified.");
                        }

                        public Autoscaling set$Xgafv(String string) {
                            return (Autoscaling)super.set$Xgafv(string);
                        }

                        public Autoscaling setAccessToken(String string) {
                            return (Autoscaling)super.setAccessToken(string);
                        }

                        public Autoscaling setAlt(String string) {
                            return (Autoscaling)super.setAlt(string);
                        }

                        public Autoscaling setCallback(String string) {
                            return (Autoscaling)super.setCallback(string);
                        }

                        public Autoscaling setFields(String string) {
                            return (Autoscaling)super.setFields(string);
                        }

                        public Autoscaling setKey(String string) {
                            return (Autoscaling)super.setKey(string);
                        }

                        public Autoscaling setOauthToken(String string) {
                            return (Autoscaling)super.setOauthToken(string);
                        }

                        public Autoscaling setPrettyPrint(Boolean bl) {
                            return (Autoscaling)super.setPrettyPrint(bl);
                        }

                        public Autoscaling setQuotaUser(String string) {
                            return (Autoscaling)super.setQuotaUser(string);
                        }

                        public Autoscaling setUploadType(String string) {
                            return (Autoscaling)super.setUploadType(string);
                        }

                        public Autoscaling setUploadProtocol(String string) {
                            return (Autoscaling)super.setUploadProtocol(string);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Autoscaling setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Autoscaling setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Autoscaling setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Autoscaling setNodePoolId(String string) {
                            this.nodePoolId = string;
                            return this;
                        }

                        @Override
                        public Autoscaling set(String string, Object object) {
                            return (Autoscaling)super.set(string, object);
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Update
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Update(String string, String string2, String string3, UpdateClusterRequest updateClusterRequest) {
                        super(Container.this, "PUT", REST_PATH, (Object)updateClusterRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Update set$Xgafv(String string) {
                        return (Update)super.set$Xgafv(string);
                    }

                    public Update setAccessToken(String string) {
                        return (Update)super.setAccessToken(string);
                    }

                    public Update setAlt(String string) {
                        return (Update)super.setAlt(string);
                    }

                    public Update setCallback(String string) {
                        return (Update)super.setCallback(string);
                    }

                    public Update setFields(String string) {
                        return (Update)super.setFields(string);
                    }

                    public Update setKey(String string) {
                        return (Update)super.setKey(string);
                    }

                    public Update setOauthToken(String string) {
                        return (Update)super.setOauthToken(string);
                    }

                    public Update setPrettyPrint(Boolean bl) {
                        return (Update)super.setPrettyPrint(bl);
                    }

                    public Update setQuotaUser(String string) {
                        return (Update)super.setQuotaUser(string);
                    }

                    public Update setUploadType(String string) {
                        return (Update)super.setUploadType(string);
                    }

                    public Update setUploadProtocol(String string) {
                        return (Update)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Update setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Update setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Update setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public Update set(String string, Object object) {
                        return (Update)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class StartIpRotation
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:startIpRotation";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected StartIpRotation(String string, String string2, String string3, StartIPRotationRequest startIPRotationRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)startIPRotationRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public StartIpRotation set$Xgafv(String string) {
                        return (StartIpRotation)super.set$Xgafv(string);
                    }

                    public StartIpRotation setAccessToken(String string) {
                        return (StartIpRotation)super.setAccessToken(string);
                    }

                    public StartIpRotation setAlt(String string) {
                        return (StartIpRotation)super.setAlt(string);
                    }

                    public StartIpRotation setCallback(String string) {
                        return (StartIpRotation)super.setCallback(string);
                    }

                    public StartIpRotation setFields(String string) {
                        return (StartIpRotation)super.setFields(string);
                    }

                    public StartIpRotation setKey(String string) {
                        return (StartIpRotation)super.setKey(string);
                    }

                    public StartIpRotation setOauthToken(String string) {
                        return (StartIpRotation)super.setOauthToken(string);
                    }

                    public StartIpRotation setPrettyPrint(Boolean bl) {
                        return (StartIpRotation)super.setPrettyPrint(bl);
                    }

                    public StartIpRotation setQuotaUser(String string) {
                        return (StartIpRotation)super.setQuotaUser(string);
                    }

                    public StartIpRotation setUploadType(String string) {
                        return (StartIpRotation)super.setUploadType(string);
                    }

                    public StartIpRotation setUploadProtocol(String string) {
                        return (StartIpRotation)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public StartIpRotation setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public StartIpRotation setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public StartIpRotation setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public StartIpRotation set(String string, Object object) {
                        return (StartIpRotation)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetNetworkPolicy
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setNetworkPolicy";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected SetNetworkPolicy(String string, String string2, String string3, SetNetworkPolicyRequest setNetworkPolicyRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setNetworkPolicyRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public SetNetworkPolicy set$Xgafv(String string) {
                        return (SetNetworkPolicy)super.set$Xgafv(string);
                    }

                    public SetNetworkPolicy setAccessToken(String string) {
                        return (SetNetworkPolicy)super.setAccessToken(string);
                    }

                    public SetNetworkPolicy setAlt(String string) {
                        return (SetNetworkPolicy)super.setAlt(string);
                    }

                    public SetNetworkPolicy setCallback(String string) {
                        return (SetNetworkPolicy)super.setCallback(string);
                    }

                    public SetNetworkPolicy setFields(String string) {
                        return (SetNetworkPolicy)super.setFields(string);
                    }

                    public SetNetworkPolicy setKey(String string) {
                        return (SetNetworkPolicy)super.setKey(string);
                    }

                    public SetNetworkPolicy setOauthToken(String string) {
                        return (SetNetworkPolicy)super.setOauthToken(string);
                    }

                    public SetNetworkPolicy setPrettyPrint(Boolean bl) {
                        return (SetNetworkPolicy)super.setPrettyPrint(bl);
                    }

                    public SetNetworkPolicy setQuotaUser(String string) {
                        return (SetNetworkPolicy)super.setQuotaUser(string);
                    }

                    public SetNetworkPolicy setUploadType(String string) {
                        return (SetNetworkPolicy)super.setUploadType(string);
                    }

                    public SetNetworkPolicy setUploadProtocol(String string) {
                        return (SetNetworkPolicy)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public SetNetworkPolicy setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public SetNetworkPolicy setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public SetNetworkPolicy setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public SetNetworkPolicy set(String string, Object object) {
                        return (SetNetworkPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetMasterAuth
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMasterAuth";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected SetMasterAuth(String string, String string2, String string3, SetMasterAuthRequest setMasterAuthRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setMasterAuthRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public SetMasterAuth set$Xgafv(String string) {
                        return (SetMasterAuth)super.set$Xgafv(string);
                    }

                    public SetMasterAuth setAccessToken(String string) {
                        return (SetMasterAuth)super.setAccessToken(string);
                    }

                    public SetMasterAuth setAlt(String string) {
                        return (SetMasterAuth)super.setAlt(string);
                    }

                    public SetMasterAuth setCallback(String string) {
                        return (SetMasterAuth)super.setCallback(string);
                    }

                    public SetMasterAuth setFields(String string) {
                        return (SetMasterAuth)super.setFields(string);
                    }

                    public SetMasterAuth setKey(String string) {
                        return (SetMasterAuth)super.setKey(string);
                    }

                    public SetMasterAuth setOauthToken(String string) {
                        return (SetMasterAuth)super.setOauthToken(string);
                    }

                    public SetMasterAuth setPrettyPrint(Boolean bl) {
                        return (SetMasterAuth)super.setPrettyPrint(bl);
                    }

                    public SetMasterAuth setQuotaUser(String string) {
                        return (SetMasterAuth)super.setQuotaUser(string);
                    }

                    public SetMasterAuth setUploadType(String string) {
                        return (SetMasterAuth)super.setUploadType(string);
                    }

                    public SetMasterAuth setUploadProtocol(String string) {
                        return (SetMasterAuth)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public SetMasterAuth setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public SetMasterAuth setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public SetMasterAuth setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public SetMasterAuth set(String string, Object object) {
                        return (SetMasterAuth)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetMaintenancePolicy
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:setMaintenancePolicy";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected SetMaintenancePolicy(String string, String string2, String string3, SetMaintenancePolicyRequest setMaintenancePolicyRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setMaintenancePolicyRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public SetMaintenancePolicy set$Xgafv(String string) {
                        return (SetMaintenancePolicy)super.set$Xgafv(string);
                    }

                    public SetMaintenancePolicy setAccessToken(String string) {
                        return (SetMaintenancePolicy)super.setAccessToken(string);
                    }

                    public SetMaintenancePolicy setAlt(String string) {
                        return (SetMaintenancePolicy)super.setAlt(string);
                    }

                    public SetMaintenancePolicy setCallback(String string) {
                        return (SetMaintenancePolicy)super.setCallback(string);
                    }

                    public SetMaintenancePolicy setFields(String string) {
                        return (SetMaintenancePolicy)super.setFields(string);
                    }

                    public SetMaintenancePolicy setKey(String string) {
                        return (SetMaintenancePolicy)super.setKey(string);
                    }

                    public SetMaintenancePolicy setOauthToken(String string) {
                        return (SetMaintenancePolicy)super.setOauthToken(string);
                    }

                    public SetMaintenancePolicy setPrettyPrint(Boolean bl) {
                        return (SetMaintenancePolicy)super.setPrettyPrint(bl);
                    }

                    public SetMaintenancePolicy setQuotaUser(String string) {
                        return (SetMaintenancePolicy)super.setQuotaUser(string);
                    }

                    public SetMaintenancePolicy setUploadType(String string) {
                        return (SetMaintenancePolicy)super.setUploadType(string);
                    }

                    public SetMaintenancePolicy setUploadProtocol(String string) {
                        return (SetMaintenancePolicy)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public SetMaintenancePolicy setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public SetMaintenancePolicy setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public SetMaintenancePolicy setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public SetMaintenancePolicy set(String string, Object object) {
                        return (SetMaintenancePolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class ResourceLabels
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/resourceLabels";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected ResourceLabels(String string, String string2, String string3, SetLabelsRequest setLabelsRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setLabelsRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public ResourceLabels set$Xgafv(String string) {
                        return (ResourceLabels)super.set$Xgafv(string);
                    }

                    public ResourceLabels setAccessToken(String string) {
                        return (ResourceLabels)super.setAccessToken(string);
                    }

                    public ResourceLabels setAlt(String string) {
                        return (ResourceLabels)super.setAlt(string);
                    }

                    public ResourceLabels setCallback(String string) {
                        return (ResourceLabels)super.setCallback(string);
                    }

                    public ResourceLabels setFields(String string) {
                        return (ResourceLabels)super.setFields(string);
                    }

                    public ResourceLabels setKey(String string) {
                        return (ResourceLabels)super.setKey(string);
                    }

                    public ResourceLabels setOauthToken(String string) {
                        return (ResourceLabels)super.setOauthToken(string);
                    }

                    public ResourceLabels setPrettyPrint(Boolean bl) {
                        return (ResourceLabels)super.setPrettyPrint(bl);
                    }

                    public ResourceLabels setQuotaUser(String string) {
                        return (ResourceLabels)super.setQuotaUser(string);
                    }

                    public ResourceLabels setUploadType(String string) {
                        return (ResourceLabels)super.setUploadType(string);
                    }

                    public ResourceLabels setUploadProtocol(String string) {
                        return (ResourceLabels)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public ResourceLabels setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public ResourceLabels setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public ResourceLabels setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public ResourceLabels set(String string, Object object) {
                        return (ResourceLabels)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Monitoring
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/monitoring";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Monitoring(String string, String string2, String string3, SetMonitoringServiceRequest setMonitoringServiceRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setMonitoringServiceRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Monitoring set$Xgafv(String string) {
                        return (Monitoring)super.set$Xgafv(string);
                    }

                    public Monitoring setAccessToken(String string) {
                        return (Monitoring)super.setAccessToken(string);
                    }

                    public Monitoring setAlt(String string) {
                        return (Monitoring)super.setAlt(string);
                    }

                    public Monitoring setCallback(String string) {
                        return (Monitoring)super.setCallback(string);
                    }

                    public Monitoring setFields(String string) {
                        return (Monitoring)super.setFields(string);
                    }

                    public Monitoring setKey(String string) {
                        return (Monitoring)super.setKey(string);
                    }

                    public Monitoring setOauthToken(String string) {
                        return (Monitoring)super.setOauthToken(string);
                    }

                    public Monitoring setPrettyPrint(Boolean bl) {
                        return (Monitoring)super.setPrettyPrint(bl);
                    }

                    public Monitoring setQuotaUser(String string) {
                        return (Monitoring)super.setQuotaUser(string);
                    }

                    public Monitoring setUploadType(String string) {
                        return (Monitoring)super.setUploadType(string);
                    }

                    public Monitoring setUploadProtocol(String string) {
                        return (Monitoring)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Monitoring setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Monitoring setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Monitoring setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public Monitoring set(String string, Object object) {
                        return (Monitoring)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Master
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/master";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Master(String string, String string2, String string3, UpdateMasterRequest updateMasterRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)updateMasterRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Master set$Xgafv(String string) {
                        return (Master)super.set$Xgafv(string);
                    }

                    public Master setAccessToken(String string) {
                        return (Master)super.setAccessToken(string);
                    }

                    public Master setAlt(String string) {
                        return (Master)super.setAlt(string);
                    }

                    public Master setCallback(String string) {
                        return (Master)super.setCallback(string);
                    }

                    public Master setFields(String string) {
                        return (Master)super.setFields(string);
                    }

                    public Master setKey(String string) {
                        return (Master)super.setKey(string);
                    }

                    public Master setOauthToken(String string) {
                        return (Master)super.setOauthToken(string);
                    }

                    public Master setPrettyPrint(Boolean bl) {
                        return (Master)super.setPrettyPrint(bl);
                    }

                    public Master setQuotaUser(String string) {
                        return (Master)super.setQuotaUser(string);
                    }

                    public Master setUploadType(String string) {
                        return (Master)super.setUploadType(string);
                    }

                    public Master setUploadProtocol(String string) {
                        return (Master)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Master setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Master setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Master setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public Master set(String string, Object object) {
                        return (Master)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Logging
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/logging";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Logging(String string, String string2, String string3, SetLoggingServiceRequest setLoggingServiceRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setLoggingServiceRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Logging set$Xgafv(String string) {
                        return (Logging)super.set$Xgafv(string);
                    }

                    public Logging setAccessToken(String string) {
                        return (Logging)super.setAccessToken(string);
                    }

                    public Logging setAlt(String string) {
                        return (Logging)super.setAlt(string);
                    }

                    public Logging setCallback(String string) {
                        return (Logging)super.setCallback(string);
                    }

                    public Logging setFields(String string) {
                        return (Logging)super.setFields(string);
                    }

                    public Logging setKey(String string) {
                        return (Logging)super.setKey(string);
                    }

                    public Logging setOauthToken(String string) {
                        return (Logging)super.setOauthToken(string);
                    }

                    public Logging setPrettyPrint(Boolean bl) {
                        return (Logging)super.setPrettyPrint(bl);
                    }

                    public Logging setQuotaUser(String string) {
                        return (Logging)super.setQuotaUser(string);
                    }

                    public Logging setUploadType(String string) {
                        return (Logging)super.setUploadType(string);
                    }

                    public Logging setUploadProtocol(String string) {
                        return (Logging)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Logging setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Logging setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Logging setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public Logging set(String string, Object object) {
                        return (Logging)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Locations
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/locations";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Locations(String string, String string2, String string3, SetLocationsRequest setLocationsRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setLocationsRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Locations set$Xgafv(String string) {
                        return (Locations)super.set$Xgafv(string);
                    }

                    public Locations setAccessToken(String string) {
                        return (Locations)super.setAccessToken(string);
                    }

                    public Locations setAlt(String string) {
                        return (Locations)super.setAlt(string);
                    }

                    public Locations setCallback(String string) {
                        return (Locations)super.setCallback(string);
                    }

                    public Locations setFields(String string) {
                        return (Locations)super.setFields(string);
                    }

                    public Locations setKey(String string) {
                        return (Locations)super.setKey(string);
                    }

                    public Locations setOauthToken(String string) {
                        return (Locations)super.setOauthToken(string);
                    }

                    public Locations setPrettyPrint(Boolean bl) {
                        return (Locations)super.setPrettyPrint(bl);
                    }

                    public Locations setQuotaUser(String string) {
                        return (Locations)super.setQuotaUser(string);
                    }

                    public Locations setUploadType(String string) {
                        return (Locations)super.setUploadType(string);
                    }

                    public Locations setUploadProtocol(String string) {
                        return (Locations)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Locations setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Locations setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Locations setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public Locations set(String string, Object object) {
                        return (Locations)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends ContainerRequest<ListClustersResponse> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String parent;

                    protected List(String string, String string2) {
                        super(Container.this, "GET", REST_PATH, null, ListClustersResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public List setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class LegacyAbac
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/legacyAbac";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected LegacyAbac(String string, String string2, String string3, SetLegacyAbacRequest setLegacyAbacRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setLegacyAbacRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public LegacyAbac set$Xgafv(String string) {
                        return (LegacyAbac)super.set$Xgafv(string);
                    }

                    public LegacyAbac setAccessToken(String string) {
                        return (LegacyAbac)super.setAccessToken(string);
                    }

                    public LegacyAbac setAlt(String string) {
                        return (LegacyAbac)super.setAlt(string);
                    }

                    public LegacyAbac setCallback(String string) {
                        return (LegacyAbac)super.setCallback(string);
                    }

                    public LegacyAbac setFields(String string) {
                        return (LegacyAbac)super.setFields(string);
                    }

                    public LegacyAbac setKey(String string) {
                        return (LegacyAbac)super.setKey(string);
                    }

                    public LegacyAbac setOauthToken(String string) {
                        return (LegacyAbac)super.setOauthToken(string);
                    }

                    public LegacyAbac setPrettyPrint(Boolean bl) {
                        return (LegacyAbac)super.setPrettyPrint(bl);
                    }

                    public LegacyAbac setQuotaUser(String string) {
                        return (LegacyAbac)super.setQuotaUser(string);
                    }

                    public LegacyAbac setUploadType(String string) {
                        return (LegacyAbac)super.setUploadType(string);
                    }

                    public LegacyAbac setUploadProtocol(String string) {
                        return (LegacyAbac)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public LegacyAbac setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public LegacyAbac setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public LegacyAbac setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public LegacyAbac set(String string, Object object) {
                        return (LegacyAbac)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends ContainerRequest<Cluster> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;
                    @Key
                    private String name;

                    protected Get(String string, String string2, String string3) {
                        super(Container.this, "GET", REST_PATH, null, Cluster.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Get setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Get setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;
                    @Key
                    private String name;

                    protected Delete(String string, String string2, String string3) {
                        super(Container.this, "DELETE", REST_PATH, null, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Delete setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Delete setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Delete setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;

                    protected Create(String string, String string2, CreateClusterRequest createClusterRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)createClusterRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Create setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Create setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class CompleteIpRotation
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}:completeIpRotation";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected CompleteIpRotation(String string, String string2, String string3, CompleteIPRotationRequest completeIPRotationRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)completeIPRotationRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public CompleteIpRotation set$Xgafv(String string) {
                        return (CompleteIpRotation)super.set$Xgafv(string);
                    }

                    public CompleteIpRotation setAccessToken(String string) {
                        return (CompleteIpRotation)super.setAccessToken(string);
                    }

                    public CompleteIpRotation setAlt(String string) {
                        return (CompleteIpRotation)super.setAlt(string);
                    }

                    public CompleteIpRotation setCallback(String string) {
                        return (CompleteIpRotation)super.setCallback(string);
                    }

                    public CompleteIpRotation setFields(String string) {
                        return (CompleteIpRotation)super.setFields(string);
                    }

                    public CompleteIpRotation setKey(String string) {
                        return (CompleteIpRotation)super.setKey(string);
                    }

                    public CompleteIpRotation setOauthToken(String string) {
                        return (CompleteIpRotation)super.setOauthToken(string);
                    }

                    public CompleteIpRotation setPrettyPrint(Boolean bl) {
                        return (CompleteIpRotation)super.setPrettyPrint(bl);
                    }

                    public CompleteIpRotation setQuotaUser(String string) {
                        return (CompleteIpRotation)super.setQuotaUser(string);
                    }

                    public CompleteIpRotation setUploadType(String string) {
                        return (CompleteIpRotation)super.setUploadType(string);
                    }

                    public CompleteIpRotation setUploadProtocol(String string) {
                        return (CompleteIpRotation)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public CompleteIpRotation setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public CompleteIpRotation setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public CompleteIpRotation setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public CompleteIpRotation set(String string, Object object) {
                        return (CompleteIpRotation)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Addons
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/clusters/{clusterId}/addons";
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Addons(String string, String string2, String string3, SetAddonsConfigRequest setAddonsConfigRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setAddonsConfigRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                        this.clusterId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterId must be specified.");
                    }

                    public Addons set$Xgafv(String string) {
                        return (Addons)super.set$Xgafv(string);
                    }

                    public Addons setAccessToken(String string) {
                        return (Addons)super.setAccessToken(string);
                    }

                    public Addons setAlt(String string) {
                        return (Addons)super.setAlt(string);
                    }

                    public Addons setCallback(String string) {
                        return (Addons)super.setCallback(string);
                    }

                    public Addons setFields(String string) {
                        return (Addons)super.setFields(string);
                    }

                    public Addons setKey(String string) {
                        return (Addons)super.setKey(string);
                    }

                    public Addons setOauthToken(String string) {
                        return (Addons)super.setOauthToken(string);
                    }

                    public Addons setPrettyPrint(Boolean bl) {
                        return (Addons)super.setPrettyPrint(bl);
                    }

                    public Addons setQuotaUser(String string) {
                        return (Addons)super.setQuotaUser(string);
                    }

                    public Addons setUploadType(String string) {
                        return (Addons)super.setUploadType(string);
                    }

                    public Addons setUploadProtocol(String string) {
                        return (Addons)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Addons setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Addons setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Addons setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public Addons set(String string, Object object) {
                        return (Addons)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetServerconfig
            extends ContainerRequest<ServerConfig> {
                private static final String REST_PATH = "v1/projects/{projectId}/zones/{zone}/serverconfig";
                @Key
                private String projectId;
                @Key
                private String zone;
                @Key
                private String name;

                protected GetServerconfig(String string, String string2) {
                    super(Container.this, "GET", REST_PATH, null, ServerConfig.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetServerconfig set$Xgafv(String string) {
                    return (GetServerconfig)super.set$Xgafv(string);
                }

                public GetServerconfig setAccessToken(String string) {
                    return (GetServerconfig)super.setAccessToken(string);
                }

                public GetServerconfig setAlt(String string) {
                    return (GetServerconfig)super.setAlt(string);
                }

                public GetServerconfig setCallback(String string) {
                    return (GetServerconfig)super.setCallback(string);
                }

                public GetServerconfig setFields(String string) {
                    return (GetServerconfig)super.setFields(string);
                }

                public GetServerconfig setKey(String string) {
                    return (GetServerconfig)super.setKey(string);
                }

                public GetServerconfig setOauthToken(String string) {
                    return (GetServerconfig)super.setOauthToken(string);
                }

                public GetServerconfig setPrettyPrint(Boolean bl) {
                    return (GetServerconfig)super.setPrettyPrint(bl);
                }

                public GetServerconfig setQuotaUser(String string) {
                    return (GetServerconfig)super.setQuotaUser(string);
                }

                public GetServerconfig setUploadType(String string) {
                    return (GetServerconfig)super.setUploadType(string);
                }

                public GetServerconfig setUploadProtocol(String string) {
                    return (GetServerconfig)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public GetServerconfig setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getZone() {
                    return this.zone;
                }

                public GetServerconfig setZone(String string) {
                    this.zone = string;
                    return this;
                }

                public String getName() {
                    return this.name;
                }

                public GetServerconfig setName(String string) {
                    this.name = string;
                    return this;
                }

                @Override
                public GetServerconfig set(String string, Object object) {
                    return (GetServerconfig)super.set(string, object);
                }
            }
        }

        public class Locations {
            public GetServerConfig getServerConfig(String string) throws IOException {
                GetServerConfig getServerConfig = new GetServerConfig(string);
                Container.this.initialize((AbstractGoogleClientRequest<?>)getServerConfig);
                return getServerConfig;
            }

            public Clusters clusters() {
                return new Clusters();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String string, CancelOperationRequest cancelOperationRequest) throws IOException {
                    Cancel cancel = new Cancel(string, cancelOperationRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)cancel);
                    return cancel;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends ContainerRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/operations";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String projectId;
                    @Key
                    private String zone;

                    protected List(String string) {
                        super(Container.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public List setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String operationId;
                    @Key
                    private String projectId;
                    @Key
                    private String zone;

                    protected Get(String string) {
                        super(Container.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getOperationId() {
                        return this.operationId;
                    }

                    public Get setOperationId(String string) {
                        this.operationId = string;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Get setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Cancel
                extends ContainerRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String string, CancelOperationRequest cancelOperationRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)cancelOperationRequest, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String string) {
                        return (Cancel)super.set$Xgafv(string);
                    }

                    public Cancel setAccessToken(String string) {
                        return (Cancel)super.setAccessToken(string);
                    }

                    public Cancel setAlt(String string) {
                        return (Cancel)super.setAlt(string);
                    }

                    public Cancel setCallback(String string) {
                        return (Cancel)super.setCallback(string);
                    }

                    public Cancel setFields(String string) {
                        return (Cancel)super.setFields(string);
                    }

                    public Cancel setKey(String string) {
                        return (Cancel)super.setKey(string);
                    }

                    public Cancel setOauthToken(String string) {
                        return (Cancel)super.setOauthToken(string);
                    }

                    public Cancel setPrettyPrint(Boolean bl) {
                        return (Cancel)super.setPrettyPrint(bl);
                    }

                    public Cancel setQuotaUser(String string) {
                        return (Cancel)super.setQuotaUser(string);
                    }

                    public Cancel setUploadType(String string) {
                        return (Cancel)super.setUploadType(string);
                    }

                    public Cancel setUploadProtocol(String string) {
                        return (Cancel)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Cancel set(String string, Object object) {
                        return (Cancel)super.set(string, object);
                    }
                }
            }

            public class Clusters {
                public CompleteIpRotation completeIpRotation(String string, CompleteIPRotationRequest completeIPRotationRequest) throws IOException {
                    CompleteIpRotation completeIpRotation = new CompleteIpRotation(string, completeIPRotationRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)completeIpRotation);
                    return completeIpRotation;
                }

                public Create create(String string, CreateClusterRequest createClusterRequest) throws IOException {
                    Create create = new Create(string, createClusterRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public GetJwks getJwks(String string) throws IOException {
                    GetJwks getJwks = new GetJwks(string);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)getJwks);
                    return getJwks;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public SetAddons setAddons(String string, SetAddonsConfigRequest setAddonsConfigRequest) throws IOException {
                    SetAddons setAddons = new SetAddons(string, setAddonsConfigRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setAddons);
                    return setAddons;
                }

                public SetLegacyAbac setLegacyAbac(String string, SetLegacyAbacRequest setLegacyAbacRequest) throws IOException {
                    SetLegacyAbac setLegacyAbac = new SetLegacyAbac(string, setLegacyAbacRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setLegacyAbac);
                    return setLegacyAbac;
                }

                public SetLocations setLocations(String string, SetLocationsRequest setLocationsRequest) throws IOException {
                    SetLocations setLocations = new SetLocations(string, setLocationsRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setLocations);
                    return setLocations;
                }

                public SetLogging setLogging(String string, SetLoggingServiceRequest setLoggingServiceRequest) throws IOException {
                    SetLogging setLogging = new SetLogging(string, setLoggingServiceRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setLogging);
                    return setLogging;
                }

                public SetMaintenancePolicy setMaintenancePolicy(String string, SetMaintenancePolicyRequest setMaintenancePolicyRequest) throws IOException {
                    SetMaintenancePolicy setMaintenancePolicy = new SetMaintenancePolicy(string, setMaintenancePolicyRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setMaintenancePolicy);
                    return setMaintenancePolicy;
                }

                public SetMasterAuth setMasterAuth(String string, SetMasterAuthRequest setMasterAuthRequest) throws IOException {
                    SetMasterAuth setMasterAuth = new SetMasterAuth(string, setMasterAuthRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setMasterAuth);
                    return setMasterAuth;
                }

                public SetMonitoring setMonitoring(String string, SetMonitoringServiceRequest setMonitoringServiceRequest) throws IOException {
                    SetMonitoring setMonitoring = new SetMonitoring(string, setMonitoringServiceRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setMonitoring);
                    return setMonitoring;
                }

                public SetNetworkPolicy setNetworkPolicy(String string, SetNetworkPolicyRequest setNetworkPolicyRequest) throws IOException {
                    SetNetworkPolicy setNetworkPolicy = new SetNetworkPolicy(string, setNetworkPolicyRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setNetworkPolicy);
                    return setNetworkPolicy;
                }

                public SetResourceLabels setResourceLabels(String string, SetLabelsRequest setLabelsRequest) throws IOException {
                    SetResourceLabels setResourceLabels = new SetResourceLabels(string, setLabelsRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)setResourceLabels);
                    return setResourceLabels;
                }

                public StartIpRotation startIpRotation(String string, StartIPRotationRequest startIPRotationRequest) throws IOException {
                    StartIpRotation startIpRotation = new StartIpRotation(string, startIPRotationRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)startIpRotation);
                    return startIpRotation;
                }

                public Update update(String string, UpdateClusterRequest updateClusterRequest) throws IOException {
                    Update update = new Update(string, updateClusterRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)update);
                    return update;
                }

                public UpdateMaster updateMaster(String string, UpdateMasterRequest updateMasterRequest) throws IOException {
                    UpdateMaster updateMaster = new UpdateMaster(string, updateMasterRequest);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)updateMaster);
                    return updateMaster;
                }

                public NodePools nodePools() {
                    return new NodePools();
                }

                public WellKnown wellKnown() {
                    return new WellKnown();
                }

                public class WellKnown {
                    public GetOpenidConfiguration getOpenidConfiguration(String string) throws IOException {
                        GetOpenidConfiguration getOpenidConfiguration = new GetOpenidConfiguration(string);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)getOpenidConfiguration);
                        return getOpenidConfiguration;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class GetOpenidConfiguration
                    extends ContainerRequest<GetOpenIDConfigResponse> {
                        private static final String REST_PATH = "v1/{+parent}/.well-known/openid-configuration";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected GetOpenidConfiguration(String string) {
                            super(Container.this, "GET", REST_PATH, null, GetOpenIDConfigResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetOpenidConfiguration set$Xgafv(String string) {
                            return (GetOpenidConfiguration)super.set$Xgafv(string);
                        }

                        public GetOpenidConfiguration setAccessToken(String string) {
                            return (GetOpenidConfiguration)super.setAccessToken(string);
                        }

                        public GetOpenidConfiguration setAlt(String string) {
                            return (GetOpenidConfiguration)super.setAlt(string);
                        }

                        public GetOpenidConfiguration setCallback(String string) {
                            return (GetOpenidConfiguration)super.setCallback(string);
                        }

                        public GetOpenidConfiguration setFields(String string) {
                            return (GetOpenidConfiguration)super.setFields(string);
                        }

                        public GetOpenidConfiguration setKey(String string) {
                            return (GetOpenidConfiguration)super.setKey(string);
                        }

                        public GetOpenidConfiguration setOauthToken(String string) {
                            return (GetOpenidConfiguration)super.setOauthToken(string);
                        }

                        public GetOpenidConfiguration setPrettyPrint(Boolean bl) {
                            return (GetOpenidConfiguration)super.setPrettyPrint(bl);
                        }

                        public GetOpenidConfiguration setQuotaUser(String string) {
                            return (GetOpenidConfiguration)super.setQuotaUser(string);
                        }

                        public GetOpenidConfiguration setUploadType(String string) {
                            return (GetOpenidConfiguration)super.setUploadType(string);
                        }

                        public GetOpenidConfiguration setUploadProtocol(String string) {
                            return (GetOpenidConfiguration)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public GetOpenidConfiguration setParent(String string) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public GetOpenidConfiguration set(String string, Object object) {
                            return (GetOpenidConfiguration)super.set(string, object);
                        }
                    }
                }

                public class NodePools {
                    public Create create(String string, CreateNodePoolRequest createNodePoolRequest) throws IOException {
                        Create create = new Create(string, createNodePoolRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)create);
                        return create;
                    }

                    public Delete delete(String string) throws IOException {
                        Delete delete = new Delete(string);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)delete);
                        return delete;
                    }

                    public Get get(String string) throws IOException {
                        Get get = new Get(string);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)get);
                        return get;
                    }

                    public List list(String string) throws IOException {
                        List list = new List(string);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)list);
                        return list;
                    }

                    public Rollback rollback(String string, RollbackNodePoolUpgradeRequest rollbackNodePoolUpgradeRequest) throws IOException {
                        Rollback rollback = new Rollback(string, rollbackNodePoolUpgradeRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)rollback);
                        return rollback;
                    }

                    public SetAutoscaling setAutoscaling(String string, SetNodePoolAutoscalingRequest setNodePoolAutoscalingRequest) throws IOException {
                        SetAutoscaling setAutoscaling = new SetAutoscaling(string, setNodePoolAutoscalingRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)setAutoscaling);
                        return setAutoscaling;
                    }

                    public SetManagement setManagement(String string, SetNodePoolManagementRequest setNodePoolManagementRequest) throws IOException {
                        SetManagement setManagement = new SetManagement(string, setNodePoolManagementRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)setManagement);
                        return setManagement;
                    }

                    public SetSize setSize(String string, SetNodePoolSizeRequest setNodePoolSizeRequest) throws IOException {
                        SetSize setSize = new SetSize(string, setNodePoolSizeRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)setSize);
                        return setSize;
                    }

                    public Update update(String string, UpdateNodePoolRequest updateNodePoolRequest) throws IOException {
                        Update update = new Update(string, updateNodePoolRequest);
                        Container.this.initialize((AbstractGoogleClientRequest<?>)update);
                        return update;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Update
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Update(String string, UpdateNodePoolRequest updateNodePoolRequest) {
                            super(Container.this, "PUT", REST_PATH, (Object)updateNodePoolRequest, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public Update set$Xgafv(String string) {
                            return (Update)super.set$Xgafv(string);
                        }

                        public Update setAccessToken(String string) {
                            return (Update)super.setAccessToken(string);
                        }

                        public Update setAlt(String string) {
                            return (Update)super.setAlt(string);
                        }

                        public Update setCallback(String string) {
                            return (Update)super.setCallback(string);
                        }

                        public Update setFields(String string) {
                            return (Update)super.setFields(string);
                        }

                        public Update setKey(String string) {
                            return (Update)super.setKey(string);
                        }

                        public Update setOauthToken(String string) {
                            return (Update)super.setOauthToken(string);
                        }

                        public Update setPrettyPrint(Boolean bl) {
                            return (Update)super.setPrettyPrint(bl);
                        }

                        public Update setQuotaUser(String string) {
                            return (Update)super.setQuotaUser(string);
                        }

                        public Update setUploadType(String string) {
                            return (Update)super.setUploadType(string);
                        }

                        public Update setUploadProtocol(String string) {
                            return (Update)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Update setName(String string) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Update set(String string, Object object) {
                            return (Update)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class SetSize
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:setSize";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected SetSize(String string, SetNodePoolSizeRequest setNodePoolSizeRequest) {
                            super(Container.this, "POST", REST_PATH, (Object)setNodePoolSizeRequest, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public SetSize set$Xgafv(String string) {
                            return (SetSize)super.set$Xgafv(string);
                        }

                        public SetSize setAccessToken(String string) {
                            return (SetSize)super.setAccessToken(string);
                        }

                        public SetSize setAlt(String string) {
                            return (SetSize)super.setAlt(string);
                        }

                        public SetSize setCallback(String string) {
                            return (SetSize)super.setCallback(string);
                        }

                        public SetSize setFields(String string) {
                            return (SetSize)super.setFields(string);
                        }

                        public SetSize setKey(String string) {
                            return (SetSize)super.setKey(string);
                        }

                        public SetSize setOauthToken(String string) {
                            return (SetSize)super.setOauthToken(string);
                        }

                        public SetSize setPrettyPrint(Boolean bl) {
                            return (SetSize)super.setPrettyPrint(bl);
                        }

                        public SetSize setQuotaUser(String string) {
                            return (SetSize)super.setQuotaUser(string);
                        }

                        public SetSize setUploadType(String string) {
                            return (SetSize)super.setUploadType(string);
                        }

                        public SetSize setUploadProtocol(String string) {
                            return (SetSize)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public SetSize setName(String string) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public SetSize set(String string, Object object) {
                            return (SetSize)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class SetManagement
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:setManagement";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected SetManagement(String string, SetNodePoolManagementRequest setNodePoolManagementRequest) {
                            super(Container.this, "POST", REST_PATH, (Object)setNodePoolManagementRequest, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public SetManagement set$Xgafv(String string) {
                            return (SetManagement)super.set$Xgafv(string);
                        }

                        public SetManagement setAccessToken(String string) {
                            return (SetManagement)super.setAccessToken(string);
                        }

                        public SetManagement setAlt(String string) {
                            return (SetManagement)super.setAlt(string);
                        }

                        public SetManagement setCallback(String string) {
                            return (SetManagement)super.setCallback(string);
                        }

                        public SetManagement setFields(String string) {
                            return (SetManagement)super.setFields(string);
                        }

                        public SetManagement setKey(String string) {
                            return (SetManagement)super.setKey(string);
                        }

                        public SetManagement setOauthToken(String string) {
                            return (SetManagement)super.setOauthToken(string);
                        }

                        public SetManagement setPrettyPrint(Boolean bl) {
                            return (SetManagement)super.setPrettyPrint(bl);
                        }

                        public SetManagement setQuotaUser(String string) {
                            return (SetManagement)super.setQuotaUser(string);
                        }

                        public SetManagement setUploadType(String string) {
                            return (SetManagement)super.setUploadType(string);
                        }

                        public SetManagement setUploadProtocol(String string) {
                            return (SetManagement)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public SetManagement setName(String string) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public SetManagement set(String string, Object object) {
                            return (SetManagement)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class SetAutoscaling
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:setAutoscaling";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected SetAutoscaling(String string, SetNodePoolAutoscalingRequest setNodePoolAutoscalingRequest) {
                            super(Container.this, "POST", REST_PATH, (Object)setNodePoolAutoscalingRequest, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public SetAutoscaling set$Xgafv(String string) {
                            return (SetAutoscaling)super.set$Xgafv(string);
                        }

                        public SetAutoscaling setAccessToken(String string) {
                            return (SetAutoscaling)super.setAccessToken(string);
                        }

                        public SetAutoscaling setAlt(String string) {
                            return (SetAutoscaling)super.setAlt(string);
                        }

                        public SetAutoscaling setCallback(String string) {
                            return (SetAutoscaling)super.setCallback(string);
                        }

                        public SetAutoscaling setFields(String string) {
                            return (SetAutoscaling)super.setFields(string);
                        }

                        public SetAutoscaling setKey(String string) {
                            return (SetAutoscaling)super.setKey(string);
                        }

                        public SetAutoscaling setOauthToken(String string) {
                            return (SetAutoscaling)super.setOauthToken(string);
                        }

                        public SetAutoscaling setPrettyPrint(Boolean bl) {
                            return (SetAutoscaling)super.setPrettyPrint(bl);
                        }

                        public SetAutoscaling setQuotaUser(String string) {
                            return (SetAutoscaling)super.setQuotaUser(string);
                        }

                        public SetAutoscaling setUploadType(String string) {
                            return (SetAutoscaling)super.setUploadType(string);
                        }

                        public SetAutoscaling setUploadProtocol(String string) {
                            return (SetAutoscaling)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public SetAutoscaling setName(String string) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public SetAutoscaling set(String string, Object object) {
                            return (SetAutoscaling)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Rollback
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}:rollback";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Rollback(String string, RollbackNodePoolUpgradeRequest rollbackNodePoolUpgradeRequest) {
                            super(Container.this, "POST", REST_PATH, (Object)rollbackNodePoolUpgradeRequest, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public Rollback set$Xgafv(String string) {
                            return (Rollback)super.set$Xgafv(string);
                        }

                        public Rollback setAccessToken(String string) {
                            return (Rollback)super.setAccessToken(string);
                        }

                        public Rollback setAlt(String string) {
                            return (Rollback)super.setAlt(string);
                        }

                        public Rollback setCallback(String string) {
                            return (Rollback)super.setCallback(string);
                        }

                        public Rollback setFields(String string) {
                            return (Rollback)super.setFields(string);
                        }

                        public Rollback setKey(String string) {
                            return (Rollback)super.setKey(string);
                        }

                        public Rollback setOauthToken(String string) {
                            return (Rollback)super.setOauthToken(string);
                        }

                        public Rollback setPrettyPrint(Boolean bl) {
                            return (Rollback)super.setPrettyPrint(bl);
                        }

                        public Rollback setQuotaUser(String string) {
                            return (Rollback)super.setQuotaUser(string);
                        }

                        public Rollback setUploadType(String string) {
                            return (Rollback)super.setUploadType(string);
                        }

                        public Rollback setUploadProtocol(String string) {
                            return (Rollback)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Rollback setName(String string) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Rollback set(String string, Object object) {
                            return (Rollback)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class List
                    extends ContainerRequest<ListNodePoolsResponse> {
                        private static final String REST_PATH = "v1/{+parent}/nodePools";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;

                        protected List(String string) {
                            super(Container.this, "GET", REST_PATH, null, ListNodePoolsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String string) {
                            return (List)super.set$Xgafv(string);
                        }

                        public List setAccessToken(String string) {
                            return (List)super.setAccessToken(string);
                        }

                        public List setAlt(String string) {
                            return (List)super.setAlt(string);
                        }

                        public List setCallback(String string) {
                            return (List)super.setCallback(string);
                        }

                        public List setFields(String string) {
                            return (List)super.setFields(string);
                        }

                        public List setKey(String string) {
                            return (List)super.setKey(string);
                        }

                        public List setOauthToken(String string) {
                            return (List)super.setOauthToken(string);
                        }

                        public List setPrettyPrint(Boolean bl) {
                            return (List)super.setPrettyPrint(bl);
                        }

                        public List setQuotaUser(String string) {
                            return (List)super.setQuotaUser(string);
                        }

                        public List setUploadType(String string) {
                            return (List)super.setUploadType(string);
                        }

                        public List setUploadProtocol(String string) {
                            return (List)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String string) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public List setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public List setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public List setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        @Override
                        public List set(String string, Object object) {
                            return (List)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Get
                    extends ContainerRequest<NodePool> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;
                        @Key
                        private String projectId;
                        @Key
                        private String zone;

                        protected Get(String string) {
                            super(Container.this, "GET", REST_PATH, null, NodePool.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String string) {
                            return (Get)super.set$Xgafv(string);
                        }

                        public Get setAccessToken(String string) {
                            return (Get)super.setAccessToken(string);
                        }

                        public Get setAlt(String string) {
                            return (Get)super.setAlt(string);
                        }

                        public Get setCallback(String string) {
                            return (Get)super.setCallback(string);
                        }

                        public Get setFields(String string) {
                            return (Get)super.setFields(string);
                        }

                        public Get setKey(String string) {
                            return (Get)super.setKey(string);
                        }

                        public Get setOauthToken(String string) {
                            return (Get)super.setOauthToken(string);
                        }

                        public Get setPrettyPrint(Boolean bl) {
                            return (Get)super.setPrettyPrint(bl);
                        }

                        public Get setQuotaUser(String string) {
                            return (Get)super.setQuotaUser(string);
                        }

                        public Get setUploadType(String string) {
                            return (Get)super.setUploadType(string);
                        }

                        public Get setUploadProtocol(String string) {
                            return (Get)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String string) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Get setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Get setNodePoolId(String string) {
                            this.nodePoolId = string;
                            return this;
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Get setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Get setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        @Override
                        public Get set(String string, Object object) {
                            return (Get)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Delete
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String projectId;
                        @Key
                        private String zone;
                        @Key
                        private String clusterId;
                        @Key
                        private String nodePoolId;

                        protected Delete(String string) {
                            super(Container.this, "DELETE", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String string) {
                            return (Delete)super.set$Xgafv(string);
                        }

                        public Delete setAccessToken(String string) {
                            return (Delete)super.setAccessToken(string);
                        }

                        public Delete setAlt(String string) {
                            return (Delete)super.setAlt(string);
                        }

                        public Delete setCallback(String string) {
                            return (Delete)super.setCallback(string);
                        }

                        public Delete setFields(String string) {
                            return (Delete)super.setFields(string);
                        }

                        public Delete setKey(String string) {
                            return (Delete)super.setKey(string);
                        }

                        public Delete setOauthToken(String string) {
                            return (Delete)super.setOauthToken(string);
                        }

                        public Delete setPrettyPrint(Boolean bl) {
                            return (Delete)super.setPrettyPrint(bl);
                        }

                        public Delete setQuotaUser(String string) {
                            return (Delete)super.setQuotaUser(string);
                        }

                        public Delete setUploadType(String string) {
                            return (Delete)super.setUploadType(string);
                        }

                        public Delete setUploadProtocol(String string) {
                            return (Delete)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String string) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+/nodePools/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Delete setProjectId(String string) {
                            this.projectId = string;
                            return this;
                        }

                        public String getZone() {
                            return this.zone;
                        }

                        public Delete setZone(String string) {
                            this.zone = string;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Delete setClusterId(String string) {
                            this.clusterId = string;
                            return this;
                        }

                        public String getNodePoolId() {
                            return this.nodePoolId;
                        }

                        public Delete setNodePoolId(String string) {
                            this.nodePoolId = string;
                            return this;
                        }

                        @Override
                        public Delete set(String string, Object object) {
                            return (Delete)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Create
                    extends ContainerRequest<Operation> {
                        private static final String REST_PATH = "v1/{+parent}/nodePools";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Create(String string, CreateNodePoolRequest createNodePoolRequest) {
                            super(Container.this, "POST", REST_PATH, (Object)createNodePoolRequest, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String string) {
                            return (Create)super.set$Xgafv(string);
                        }

                        public Create setAccessToken(String string) {
                            return (Create)super.setAccessToken(string);
                        }

                        public Create setAlt(String string) {
                            return (Create)super.setAlt(string);
                        }

                        public Create setCallback(String string) {
                            return (Create)super.setCallback(string);
                        }

                        public Create setFields(String string) {
                            return (Create)super.setFields(string);
                        }

                        public Create setKey(String string) {
                            return (Create)super.setKey(string);
                        }

                        public Create setOauthToken(String string) {
                            return (Create)super.setOauthToken(string);
                        }

                        public Create setPrettyPrint(Boolean bl) {
                            return (Create)super.setPrettyPrint(bl);
                        }

                        public Create setQuotaUser(String string) {
                            return (Create)super.setQuotaUser(string);
                        }

                        public Create setUploadType(String string) {
                            return (Create)super.setUploadType(string);
                        }

                        public Create setUploadProtocol(String string) {
                            return (Create)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String string) {
                            if (!Container.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        @Override
                        public Create set(String string, Object object) {
                            return (Create)super.set(string, object);
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class UpdateMaster
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:updateMaster";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected UpdateMaster(String string, UpdateMasterRequest updateMasterRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)updateMasterRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public UpdateMaster set$Xgafv(String string) {
                        return (UpdateMaster)super.set$Xgafv(string);
                    }

                    public UpdateMaster setAccessToken(String string) {
                        return (UpdateMaster)super.setAccessToken(string);
                    }

                    public UpdateMaster setAlt(String string) {
                        return (UpdateMaster)super.setAlt(string);
                    }

                    public UpdateMaster setCallback(String string) {
                        return (UpdateMaster)super.setCallback(string);
                    }

                    public UpdateMaster setFields(String string) {
                        return (UpdateMaster)super.setFields(string);
                    }

                    public UpdateMaster setKey(String string) {
                        return (UpdateMaster)super.setKey(string);
                    }

                    public UpdateMaster setOauthToken(String string) {
                        return (UpdateMaster)super.setOauthToken(string);
                    }

                    public UpdateMaster setPrettyPrint(Boolean bl) {
                        return (UpdateMaster)super.setPrettyPrint(bl);
                    }

                    public UpdateMaster setQuotaUser(String string) {
                        return (UpdateMaster)super.setQuotaUser(string);
                    }

                    public UpdateMaster setUploadType(String string) {
                        return (UpdateMaster)super.setUploadType(string);
                    }

                    public UpdateMaster setUploadProtocol(String string) {
                        return (UpdateMaster)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public UpdateMaster setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public UpdateMaster set(String string, Object object) {
                        return (UpdateMaster)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Update
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Update(String string, UpdateClusterRequest updateClusterRequest) {
                        super(Container.this, "PUT", REST_PATH, (Object)updateClusterRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public Update set$Xgafv(String string) {
                        return (Update)super.set$Xgafv(string);
                    }

                    public Update setAccessToken(String string) {
                        return (Update)super.setAccessToken(string);
                    }

                    public Update setAlt(String string) {
                        return (Update)super.setAlt(string);
                    }

                    public Update setCallback(String string) {
                        return (Update)super.setCallback(string);
                    }

                    public Update setFields(String string) {
                        return (Update)super.setFields(string);
                    }

                    public Update setKey(String string) {
                        return (Update)super.setKey(string);
                    }

                    public Update setOauthToken(String string) {
                        return (Update)super.setOauthToken(string);
                    }

                    public Update setPrettyPrint(Boolean bl) {
                        return (Update)super.setPrettyPrint(bl);
                    }

                    public Update setQuotaUser(String string) {
                        return (Update)super.setQuotaUser(string);
                    }

                    public Update setUploadType(String string) {
                        return (Update)super.setUploadType(string);
                    }

                    public Update setUploadProtocol(String string) {
                        return (Update)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Update setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Update set(String string, Object object) {
                        return (Update)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class StartIpRotation
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:startIpRotation";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected StartIpRotation(String string, StartIPRotationRequest startIPRotationRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)startIPRotationRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public StartIpRotation set$Xgafv(String string) {
                        return (StartIpRotation)super.set$Xgafv(string);
                    }

                    public StartIpRotation setAccessToken(String string) {
                        return (StartIpRotation)super.setAccessToken(string);
                    }

                    public StartIpRotation setAlt(String string) {
                        return (StartIpRotation)super.setAlt(string);
                    }

                    public StartIpRotation setCallback(String string) {
                        return (StartIpRotation)super.setCallback(string);
                    }

                    public StartIpRotation setFields(String string) {
                        return (StartIpRotation)super.setFields(string);
                    }

                    public StartIpRotation setKey(String string) {
                        return (StartIpRotation)super.setKey(string);
                    }

                    public StartIpRotation setOauthToken(String string) {
                        return (StartIpRotation)super.setOauthToken(string);
                    }

                    public StartIpRotation setPrettyPrint(Boolean bl) {
                        return (StartIpRotation)super.setPrettyPrint(bl);
                    }

                    public StartIpRotation setQuotaUser(String string) {
                        return (StartIpRotation)super.setQuotaUser(string);
                    }

                    public StartIpRotation setUploadType(String string) {
                        return (StartIpRotation)super.setUploadType(string);
                    }

                    public StartIpRotation setUploadProtocol(String string) {
                        return (StartIpRotation)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public StartIpRotation setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public StartIpRotation set(String string, Object object) {
                        return (StartIpRotation)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetResourceLabels
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setResourceLabels";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetResourceLabels(String string, SetLabelsRequest setLabelsRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setLabelsRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetResourceLabels set$Xgafv(String string) {
                        return (SetResourceLabels)super.set$Xgafv(string);
                    }

                    public SetResourceLabels setAccessToken(String string) {
                        return (SetResourceLabels)super.setAccessToken(string);
                    }

                    public SetResourceLabels setAlt(String string) {
                        return (SetResourceLabels)super.setAlt(string);
                    }

                    public SetResourceLabels setCallback(String string) {
                        return (SetResourceLabels)super.setCallback(string);
                    }

                    public SetResourceLabels setFields(String string) {
                        return (SetResourceLabels)super.setFields(string);
                    }

                    public SetResourceLabels setKey(String string) {
                        return (SetResourceLabels)super.setKey(string);
                    }

                    public SetResourceLabels setOauthToken(String string) {
                        return (SetResourceLabels)super.setOauthToken(string);
                    }

                    public SetResourceLabels setPrettyPrint(Boolean bl) {
                        return (SetResourceLabels)super.setPrettyPrint(bl);
                    }

                    public SetResourceLabels setQuotaUser(String string) {
                        return (SetResourceLabels)super.setQuotaUser(string);
                    }

                    public SetResourceLabels setUploadType(String string) {
                        return (SetResourceLabels)super.setUploadType(string);
                    }

                    public SetResourceLabels setUploadProtocol(String string) {
                        return (SetResourceLabels)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetResourceLabels setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public SetResourceLabels set(String string, Object object) {
                        return (SetResourceLabels)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetNetworkPolicy
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setNetworkPolicy";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetNetworkPolicy(String string, SetNetworkPolicyRequest setNetworkPolicyRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setNetworkPolicyRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetNetworkPolicy set$Xgafv(String string) {
                        return (SetNetworkPolicy)super.set$Xgafv(string);
                    }

                    public SetNetworkPolicy setAccessToken(String string) {
                        return (SetNetworkPolicy)super.setAccessToken(string);
                    }

                    public SetNetworkPolicy setAlt(String string) {
                        return (SetNetworkPolicy)super.setAlt(string);
                    }

                    public SetNetworkPolicy setCallback(String string) {
                        return (SetNetworkPolicy)super.setCallback(string);
                    }

                    public SetNetworkPolicy setFields(String string) {
                        return (SetNetworkPolicy)super.setFields(string);
                    }

                    public SetNetworkPolicy setKey(String string) {
                        return (SetNetworkPolicy)super.setKey(string);
                    }

                    public SetNetworkPolicy setOauthToken(String string) {
                        return (SetNetworkPolicy)super.setOauthToken(string);
                    }

                    public SetNetworkPolicy setPrettyPrint(Boolean bl) {
                        return (SetNetworkPolicy)super.setPrettyPrint(bl);
                    }

                    public SetNetworkPolicy setQuotaUser(String string) {
                        return (SetNetworkPolicy)super.setQuotaUser(string);
                    }

                    public SetNetworkPolicy setUploadType(String string) {
                        return (SetNetworkPolicy)super.setUploadType(string);
                    }

                    public SetNetworkPolicy setUploadProtocol(String string) {
                        return (SetNetworkPolicy)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetNetworkPolicy setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public SetNetworkPolicy set(String string, Object object) {
                        return (SetNetworkPolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetMonitoring
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setMonitoring";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetMonitoring(String string, SetMonitoringServiceRequest setMonitoringServiceRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setMonitoringServiceRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetMonitoring set$Xgafv(String string) {
                        return (SetMonitoring)super.set$Xgafv(string);
                    }

                    public SetMonitoring setAccessToken(String string) {
                        return (SetMonitoring)super.setAccessToken(string);
                    }

                    public SetMonitoring setAlt(String string) {
                        return (SetMonitoring)super.setAlt(string);
                    }

                    public SetMonitoring setCallback(String string) {
                        return (SetMonitoring)super.setCallback(string);
                    }

                    public SetMonitoring setFields(String string) {
                        return (SetMonitoring)super.setFields(string);
                    }

                    public SetMonitoring setKey(String string) {
                        return (SetMonitoring)super.setKey(string);
                    }

                    public SetMonitoring setOauthToken(String string) {
                        return (SetMonitoring)super.setOauthToken(string);
                    }

                    public SetMonitoring setPrettyPrint(Boolean bl) {
                        return (SetMonitoring)super.setPrettyPrint(bl);
                    }

                    public SetMonitoring setQuotaUser(String string) {
                        return (SetMonitoring)super.setQuotaUser(string);
                    }

                    public SetMonitoring setUploadType(String string) {
                        return (SetMonitoring)super.setUploadType(string);
                    }

                    public SetMonitoring setUploadProtocol(String string) {
                        return (SetMonitoring)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetMonitoring setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public SetMonitoring set(String string, Object object) {
                        return (SetMonitoring)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetMasterAuth
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setMasterAuth";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetMasterAuth(String string, SetMasterAuthRequest setMasterAuthRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setMasterAuthRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetMasterAuth set$Xgafv(String string) {
                        return (SetMasterAuth)super.set$Xgafv(string);
                    }

                    public SetMasterAuth setAccessToken(String string) {
                        return (SetMasterAuth)super.setAccessToken(string);
                    }

                    public SetMasterAuth setAlt(String string) {
                        return (SetMasterAuth)super.setAlt(string);
                    }

                    public SetMasterAuth setCallback(String string) {
                        return (SetMasterAuth)super.setCallback(string);
                    }

                    public SetMasterAuth setFields(String string) {
                        return (SetMasterAuth)super.setFields(string);
                    }

                    public SetMasterAuth setKey(String string) {
                        return (SetMasterAuth)super.setKey(string);
                    }

                    public SetMasterAuth setOauthToken(String string) {
                        return (SetMasterAuth)super.setOauthToken(string);
                    }

                    public SetMasterAuth setPrettyPrint(Boolean bl) {
                        return (SetMasterAuth)super.setPrettyPrint(bl);
                    }

                    public SetMasterAuth setQuotaUser(String string) {
                        return (SetMasterAuth)super.setQuotaUser(string);
                    }

                    public SetMasterAuth setUploadType(String string) {
                        return (SetMasterAuth)super.setUploadType(string);
                    }

                    public SetMasterAuth setUploadProtocol(String string) {
                        return (SetMasterAuth)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetMasterAuth setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public SetMasterAuth set(String string, Object object) {
                        return (SetMasterAuth)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetMaintenancePolicy
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setMaintenancePolicy";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetMaintenancePolicy(String string, SetMaintenancePolicyRequest setMaintenancePolicyRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setMaintenancePolicyRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetMaintenancePolicy set$Xgafv(String string) {
                        return (SetMaintenancePolicy)super.set$Xgafv(string);
                    }

                    public SetMaintenancePolicy setAccessToken(String string) {
                        return (SetMaintenancePolicy)super.setAccessToken(string);
                    }

                    public SetMaintenancePolicy setAlt(String string) {
                        return (SetMaintenancePolicy)super.setAlt(string);
                    }

                    public SetMaintenancePolicy setCallback(String string) {
                        return (SetMaintenancePolicy)super.setCallback(string);
                    }

                    public SetMaintenancePolicy setFields(String string) {
                        return (SetMaintenancePolicy)super.setFields(string);
                    }

                    public SetMaintenancePolicy setKey(String string) {
                        return (SetMaintenancePolicy)super.setKey(string);
                    }

                    public SetMaintenancePolicy setOauthToken(String string) {
                        return (SetMaintenancePolicy)super.setOauthToken(string);
                    }

                    public SetMaintenancePolicy setPrettyPrint(Boolean bl) {
                        return (SetMaintenancePolicy)super.setPrettyPrint(bl);
                    }

                    public SetMaintenancePolicy setQuotaUser(String string) {
                        return (SetMaintenancePolicy)super.setQuotaUser(string);
                    }

                    public SetMaintenancePolicy setUploadType(String string) {
                        return (SetMaintenancePolicy)super.setUploadType(string);
                    }

                    public SetMaintenancePolicy setUploadProtocol(String string) {
                        return (SetMaintenancePolicy)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetMaintenancePolicy setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public SetMaintenancePolicy set(String string, Object object) {
                        return (SetMaintenancePolicy)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetLogging
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setLogging";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetLogging(String string, SetLoggingServiceRequest setLoggingServiceRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setLoggingServiceRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetLogging set$Xgafv(String string) {
                        return (SetLogging)super.set$Xgafv(string);
                    }

                    public SetLogging setAccessToken(String string) {
                        return (SetLogging)super.setAccessToken(string);
                    }

                    public SetLogging setAlt(String string) {
                        return (SetLogging)super.setAlt(string);
                    }

                    public SetLogging setCallback(String string) {
                        return (SetLogging)super.setCallback(string);
                    }

                    public SetLogging setFields(String string) {
                        return (SetLogging)super.setFields(string);
                    }

                    public SetLogging setKey(String string) {
                        return (SetLogging)super.setKey(string);
                    }

                    public SetLogging setOauthToken(String string) {
                        return (SetLogging)super.setOauthToken(string);
                    }

                    public SetLogging setPrettyPrint(Boolean bl) {
                        return (SetLogging)super.setPrettyPrint(bl);
                    }

                    public SetLogging setQuotaUser(String string) {
                        return (SetLogging)super.setQuotaUser(string);
                    }

                    public SetLogging setUploadType(String string) {
                        return (SetLogging)super.setUploadType(string);
                    }

                    public SetLogging setUploadProtocol(String string) {
                        return (SetLogging)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetLogging setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public SetLogging set(String string, Object object) {
                        return (SetLogging)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetLocations
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setLocations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetLocations(String string, SetLocationsRequest setLocationsRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setLocationsRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetLocations set$Xgafv(String string) {
                        return (SetLocations)super.set$Xgafv(string);
                    }

                    public SetLocations setAccessToken(String string) {
                        return (SetLocations)super.setAccessToken(string);
                    }

                    public SetLocations setAlt(String string) {
                        return (SetLocations)super.setAlt(string);
                    }

                    public SetLocations setCallback(String string) {
                        return (SetLocations)super.setCallback(string);
                    }

                    public SetLocations setFields(String string) {
                        return (SetLocations)super.setFields(string);
                    }

                    public SetLocations setKey(String string) {
                        return (SetLocations)super.setKey(string);
                    }

                    public SetLocations setOauthToken(String string) {
                        return (SetLocations)super.setOauthToken(string);
                    }

                    public SetLocations setPrettyPrint(Boolean bl) {
                        return (SetLocations)super.setPrettyPrint(bl);
                    }

                    public SetLocations setQuotaUser(String string) {
                        return (SetLocations)super.setQuotaUser(string);
                    }

                    public SetLocations setUploadType(String string) {
                        return (SetLocations)super.setUploadType(string);
                    }

                    public SetLocations setUploadProtocol(String string) {
                        return (SetLocations)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetLocations setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public SetLocations set(String string, Object object) {
                        return (SetLocations)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetLegacyAbac
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setLegacyAbac";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetLegacyAbac(String string, SetLegacyAbacRequest setLegacyAbacRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setLegacyAbacRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetLegacyAbac set$Xgafv(String string) {
                        return (SetLegacyAbac)super.set$Xgafv(string);
                    }

                    public SetLegacyAbac setAccessToken(String string) {
                        return (SetLegacyAbac)super.setAccessToken(string);
                    }

                    public SetLegacyAbac setAlt(String string) {
                        return (SetLegacyAbac)super.setAlt(string);
                    }

                    public SetLegacyAbac setCallback(String string) {
                        return (SetLegacyAbac)super.setCallback(string);
                    }

                    public SetLegacyAbac setFields(String string) {
                        return (SetLegacyAbac)super.setFields(string);
                    }

                    public SetLegacyAbac setKey(String string) {
                        return (SetLegacyAbac)super.setKey(string);
                    }

                    public SetLegacyAbac setOauthToken(String string) {
                        return (SetLegacyAbac)super.setOauthToken(string);
                    }

                    public SetLegacyAbac setPrettyPrint(Boolean bl) {
                        return (SetLegacyAbac)super.setPrettyPrint(bl);
                    }

                    public SetLegacyAbac setQuotaUser(String string) {
                        return (SetLegacyAbac)super.setQuotaUser(string);
                    }

                    public SetLegacyAbac setUploadType(String string) {
                        return (SetLegacyAbac)super.setUploadType(string);
                    }

                    public SetLegacyAbac setUploadProtocol(String string) {
                        return (SetLegacyAbac)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetLegacyAbac setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public SetLegacyAbac set(String string, Object object) {
                        return (SetLegacyAbac)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class SetAddons
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:setAddons";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected SetAddons(String string, SetAddonsConfigRequest setAddonsConfigRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)setAddonsConfigRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public SetAddons set$Xgafv(String string) {
                        return (SetAddons)super.set$Xgafv(string);
                    }

                    public SetAddons setAccessToken(String string) {
                        return (SetAddons)super.setAccessToken(string);
                    }

                    public SetAddons setAlt(String string) {
                        return (SetAddons)super.setAlt(string);
                    }

                    public SetAddons setCallback(String string) {
                        return (SetAddons)super.setCallback(string);
                    }

                    public SetAddons setFields(String string) {
                        return (SetAddons)super.setFields(string);
                    }

                    public SetAddons setKey(String string) {
                        return (SetAddons)super.setKey(string);
                    }

                    public SetAddons setOauthToken(String string) {
                        return (SetAddons)super.setOauthToken(string);
                    }

                    public SetAddons setPrettyPrint(Boolean bl) {
                        return (SetAddons)super.setPrettyPrint(bl);
                    }

                    public SetAddons setQuotaUser(String string) {
                        return (SetAddons)super.setQuotaUser(string);
                    }

                    public SetAddons setUploadType(String string) {
                        return (SetAddons)super.setUploadType(string);
                    }

                    public SetAddons setUploadProtocol(String string) {
                        return (SetAddons)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public SetAddons setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public SetAddons set(String string, Object object) {
                        return (SetAddons)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends ContainerRequest<ListClustersResponse> {
                    private static final String REST_PATH = "v1/{+parent}/clusters";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String projectId;
                    @Key
                    private String zone;

                    protected List(String string) {
                        super(Container.this, "GET", REST_PATH, null, ListClustersResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public List setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class GetJwks
                extends ContainerRequest<GetJSONWebKeysResponse> {
                    private static final String REST_PATH = "v1/{+parent}/jwks";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected GetJwks(String string) {
                        super(Container.this, "GET", REST_PATH, null, GetJSONWebKeysResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetJwks set$Xgafv(String string) {
                        return (GetJwks)super.set$Xgafv(string);
                    }

                    public GetJwks setAccessToken(String string) {
                        return (GetJwks)super.setAccessToken(string);
                    }

                    public GetJwks setAlt(String string) {
                        return (GetJwks)super.setAlt(string);
                    }

                    public GetJwks setCallback(String string) {
                        return (GetJwks)super.setCallback(string);
                    }

                    public GetJwks setFields(String string) {
                        return (GetJwks)super.setFields(string);
                    }

                    public GetJwks setKey(String string) {
                        return (GetJwks)super.setKey(string);
                    }

                    public GetJwks setOauthToken(String string) {
                        return (GetJwks)super.setOauthToken(string);
                    }

                    public GetJwks setPrettyPrint(Boolean bl) {
                        return (GetJwks)super.setPrettyPrint(bl);
                    }

                    public GetJwks setQuotaUser(String string) {
                        return (GetJwks)super.setQuotaUser(string);
                    }

                    public GetJwks setUploadType(String string) {
                        return (GetJwks)super.setUploadType(string);
                    }

                    public GetJwks setUploadProtocol(String string) {
                        return (GetJwks)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public GetJwks setParent(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public GetJwks set(String string, Object object) {
                        return (GetJwks)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends ContainerRequest<Cluster> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String clusterId;
                    @Key
                    private String projectId;
                    @Key
                    private String zone;

                    protected Get(String string) {
                        super(Container.this, "GET", REST_PATH, null, Cluster.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Get setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Get setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String projectId;
                    @Key
                    private String zone;
                    @Key
                    private String clusterId;

                    protected Delete(String string) {
                        super(Container.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Delete setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getZone() {
                        return this.zone;
                    }

                    public Delete setZone(String string) {
                        this.zone = string;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Delete setClusterId(String string) {
                        this.clusterId = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/clusters";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String string, CreateClusterRequest createClusterRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)createClusterRequest, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class CompleteIpRotation
                extends ContainerRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}:completeIpRotation";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected CompleteIpRotation(String string, CompleteIPRotationRequest completeIPRotationRequest) {
                        super(Container.this, "POST", REST_PATH, (Object)completeIPRotationRequest, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public CompleteIpRotation set$Xgafv(String string) {
                        return (CompleteIpRotation)super.set$Xgafv(string);
                    }

                    public CompleteIpRotation setAccessToken(String string) {
                        return (CompleteIpRotation)super.setAccessToken(string);
                    }

                    public CompleteIpRotation setAlt(String string) {
                        return (CompleteIpRotation)super.setAlt(string);
                    }

                    public CompleteIpRotation setCallback(String string) {
                        return (CompleteIpRotation)super.setCallback(string);
                    }

                    public CompleteIpRotation setFields(String string) {
                        return (CompleteIpRotation)super.setFields(string);
                    }

                    public CompleteIpRotation setKey(String string) {
                        return (CompleteIpRotation)super.setKey(string);
                    }

                    public CompleteIpRotation setOauthToken(String string) {
                        return (CompleteIpRotation)super.setOauthToken(string);
                    }

                    public CompleteIpRotation setPrettyPrint(Boolean bl) {
                        return (CompleteIpRotation)super.setPrettyPrint(bl);
                    }

                    public CompleteIpRotation setQuotaUser(String string) {
                        return (CompleteIpRotation)super.setQuotaUser(string);
                    }

                    public CompleteIpRotation setUploadType(String string) {
                        return (CompleteIpRotation)super.setUploadType(string);
                    }

                    public CompleteIpRotation setUploadProtocol(String string) {
                        return (CompleteIpRotation)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public CompleteIpRotation setName(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/clusters/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public CompleteIpRotation set(String string, Object object) {
                        return (CompleteIpRotation)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetServerConfig
            extends ContainerRequest<ServerConfig> {
                private static final String REST_PATH = "v1/{+name}/serverConfig";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String projectId;
                @Key
                private String zone;

                protected GetServerConfig(String string) {
                    super(Container.this, "GET", REST_PATH, null, ServerConfig.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Container.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetServerConfig set$Xgafv(String string) {
                    return (GetServerConfig)super.set$Xgafv(string);
                }

                public GetServerConfig setAccessToken(String string) {
                    return (GetServerConfig)super.setAccessToken(string);
                }

                public GetServerConfig setAlt(String string) {
                    return (GetServerConfig)super.setAlt(string);
                }

                public GetServerConfig setCallback(String string) {
                    return (GetServerConfig)super.setCallback(string);
                }

                public GetServerConfig setFields(String string) {
                    return (GetServerConfig)super.setFields(string);
                }

                public GetServerConfig setKey(String string) {
                    return (GetServerConfig)super.setKey(string);
                }

                public GetServerConfig setOauthToken(String string) {
                    return (GetServerConfig)super.setOauthToken(string);
                }

                public GetServerConfig setPrettyPrint(Boolean bl) {
                    return (GetServerConfig)super.setPrettyPrint(bl);
                }

                public GetServerConfig setQuotaUser(String string) {
                    return (GetServerConfig)super.setQuotaUser(string);
                }

                public GetServerConfig setUploadType(String string) {
                    return (GetServerConfig)super.setUploadType(string);
                }

                public GetServerConfig setUploadProtocol(String string) {
                    return (GetServerConfig)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public GetServerConfig setName(String string) {
                    if (!Container.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public GetServerConfig setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getZone() {
                    return this.zone;
                }

                public GetServerConfig setZone(String string) {
                    this.zone = string;
                    return this;
                }

                @Override
                public GetServerConfig set(String string, Object object) {
                    return (GetServerConfig)super.set(string, object);
                }
            }
        }

        public class Aggregated {
            public UsableSubnetworks usableSubnetworks() {
                return new UsableSubnetworks();
            }

            public class UsableSubnetworks {
                public List list(String string) throws IOException {
                    List list = new List(string);
                    Container.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends ContainerRequest<ListUsableSubnetworksResponse> {
                    private static final String REST_PATH = "v1/{+parent}/aggregated/usableSubnetworks";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(Container.this, "GET", REST_PATH, null, ListUsableSubnetworksResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Container.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String string) {
                        this.filter = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }
            }
        }
    }
}

