/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.PluginWrapper;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.globalyamlproperties.MultibranchYAMLJobProperty;
import io.jenkins.plugins.globalyamlproperties.PipelineYAMLJobProperty;
import io.jenkins.plugins.globalyamlproperties.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class GetLocalYAMLConfig
extends Step {
    @DataBoundConstructor
    public GetLocalYAMLConfig() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new GlobalPropertiesStepExecution(context);
    }

    private static class GlobalPropertiesStepExecution
    extends SynchronousStepExecution<Map<String, Object>> {
        private static final long serialVersionUID = 1L;

        protected GlobalPropertiesStepExecution(StepContext context) {
            super(context);
        }

        protected boolean isMultibranchPipeline(Job job) {
            try {
                PluginWrapper plugin = Jenkins.get().pluginManager.getPlugin("workflow-multibranch");
                return plugin != null && job.getParent() instanceof WorkflowMultiBranchProject;
            }
            catch (Exception e) {
                return false;
            }
        }

        protected Map<String, Object> run() throws Exception {
            StepContext context = this.getContext();
            Job job = ((Run)context.get(Run.class)).getParent();
            if (this.isMultibranchPipeline(job)) {
                WorkflowMultiBranchProject multibranchProject = (WorkflowMultiBranchProject)job.getParent();
                MultibranchYAMLJobProperty localYamlConfiguration = (MultibranchYAMLJobProperty)multibranchProject.getProperties().get(MultibranchYAMLJobProperty.class);
                if (localYamlConfiguration == null) {
                    return new HashMap<String, Object>();
                }
                return Utils.deepCopyMap(localYamlConfiguration.getParsedConfig());
            }
            WorkflowJob pipelineJob = (WorkflowJob)job;
            PipelineYAMLJobProperty localYamlConfiguration = (PipelineYAMLJobProperty)pipelineJob.getProperty(PipelineYAMLJobProperty.class);
            if (localYamlConfiguration == null) {
                return new HashMap<String, Object>();
            }
            return Utils.deepCopyMap(localYamlConfiguration.getParsedConfig());
        }
    }

    @Symbol(value={"getLocalYAMLProperties"})
    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "getLocalYAMLProperties";
        }

        @NonNull
        public String getDisplayName() {
            return "Get Local YAML Properties in HashMap format";
        }

        public boolean takesImplicitBlockArgument() {
            return false;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(TaskListener.class, Run.class);
        }
    }
}

