/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import io.jenkins.plugins.globalyamlproperties.GlobalYAMLPropertiesConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GetGlobalYAMLConfigNamesByCategory
extends Step {
    private String category = "";

    @DataBoundConstructor
    public GetGlobalYAMLConfigNamesByCategory(String category) {
        this.category = category;
    }

    @DataBoundSetter
    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new GlobalPropertiesStepExecution(context, this.category);
    }

    private static class GlobalPropertiesStepExecution
    extends SynchronousStepExecution<List<String>> {
        private final String category;
        private static final long serialVersionUID = 1L;

        protected GlobalPropertiesStepExecution(StepContext context, String category) {
            super(context);
            this.category = category;
        }

        protected List<String> run() throws Exception {
            GlobalYAMLPropertiesConfiguration globalPropertiesConfig = GlobalYAMLPropertiesConfiguration.get();
            return globalPropertiesConfig.getConfigNamesByCategory(this.category);
        }
    }

    @Symbol(value={"getGlobalYAMLConfigNamesByCategory"})
    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "getGlobalYAMLConfigNamesByCategory";
        }

        @NonNull
        public String getDisplayName() {
            return "Get list of configs by category";
        }

        public boolean takesImplicitBlockArgument() {
            return false;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

