/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.TaskListener;
import io.jenkins.plugins.globalyamlproperties.GlobalYAMLPropertiesConfiguration;
import io.jenkins.plugins.globalyamlproperties.Utils;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class GetGlobalYAMLConfig
extends Step {
    private String configName = "";

    @DataBoundConstructor
    public GetGlobalYAMLConfig(String configName) {
        if (configName != null) {
            this.configName = configName;
        }
    }

    @DataBoundSetter
    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public String getConfigName() {
        return this.configName;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new GlobalPropertiesStepExecution(context, this.configName);
    }

    private static class GlobalPropertiesStepExecution
    extends SynchronousStepExecution<Map<String, Object>> {
        private final String configName;
        private static final long serialVersionUID = 1L;

        protected GlobalPropertiesStepExecution(StepContext context, String configName) {
            super(context);
            this.configName = configName;
        }

        protected Map<String, Object> run() throws Exception {
            Map<String, Object> globalPropertiesConfigMap;
            StepContext context = this.getContext();
            PrintStream logger = ((TaskListener)context.get(TaskListener.class)).getLogger();
            GlobalYAMLPropertiesConfiguration globalPropertiesConfig = GlobalYAMLPropertiesConfiguration.get();
            if (this.configName != null && !this.configName.isEmpty()) {
                logger.println("[GetGlobalProperties] Obtaining configuration for " + this.configName);
                globalPropertiesConfigMap = globalPropertiesConfig.getConfigByName(this.configName).getConfigMap();
            } else {
                logger.println("[GetGlobalProperties] Obtaining default configuration (" + globalPropertiesConfig.getDefaultConfig().getName() + ")");
                globalPropertiesConfigMap = globalPropertiesConfig.getDefaultConfig().getConfigMap();
            }
            if (globalPropertiesConfigMap.isEmpty()) {
                logger.println("[GetGlobalProperties] Warning: Configuration is empty");
            }
            return Utils.deepCopyMap(globalPropertiesConfigMap);
        }
    }

    @Symbol(value={"getGlobalYAMLProperties"})
    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "getGlobalYAMLProperties";
        }

        @NonNull
        public String getDisplayName() {
            return "Get Global YAML Properties in HashMap format";
        }

        public boolean takesImplicitBlockArgument() {
            return false;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

