/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties.scmpolling;

import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import io.jenkins.plugins.globalyamlproperties.Config;
import io.jenkins.plugins.globalyamlproperties.ConfigSource;
import io.jenkins.plugins.globalyamlproperties.ConfigSourceSCM;
import io.jenkins.plugins.globalyamlproperties.GlobalYAMLPropertiesConfiguration;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

@Extension
public class GitHubFetchTask
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(GitHubFetchTask.class.getName());
    private static final String LOG_PREFIX = "[GlobalYAMLPropertiesPeriodicTask] ";

    public GitHubFetchTask() {
        super("GitHubFetchTask");
    }

    protected void execute(TaskListener listener) throws IOException {
        LOGGER.info("[GlobalYAMLPropertiesPeriodicTask] Refreshing GlobalYAMLProperties configuration...");
        for (Config config : GlobalYAMLPropertiesConfiguration.get().getConfigs()) {
            LOGGER.info("[GlobalYAMLPropertiesPeriodicTask] Processing " + config.getName() + "...");
            try {
                ConfigSource configSource = config.getConfigSource();
                if (configSource instanceof ConfigSourceSCM) {
                    ConfigSourceSCM configSourceSCM = (ConfigSourceSCM)configSource;
                    configSourceSCM.fetchConfiguration();
                }
                config.refreshConfiguration();
            }
            catch (Exception e) {
                LOGGER.severe("[GlobalYAMLPropertiesPeriodicTask] Error refreshing " + config.getName() + ": " + e.getMessage());
                e.printStackTrace();
            }
            config.refreshConfiguration();
            LOGGER.info("[GlobalYAMLPropertiesPeriodicTask] Refresh " + config.getName() + "...");
        }
        LOGGER.info("[GlobalYAMLPropertiesPeriodicTask] Refresh completed. Next refresh after " + TimeUnit.MILLISECONDS.toMinutes(this.getRecurrencePeriod()) + " minutes.");
    }

    public long getRecurrencePeriod() {
        return 60000L * (long)GlobalYAMLPropertiesConfiguration.get().getRefreshInterval();
    }
}

