/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsUnavailableException;
import hudson.security.ACL;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.Authentication;

public class Utils {
    static String readInputStream(InputStream inputStream) throws IOException {
        StringBuilder textBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        int c = 0;
        while ((c = ((Reader)reader).read()) != -1) {
            textBuilder.append((char)c);
        }
        return textBuilder.toString();
    }

    public static Map<String, Object> deepCopyMap(Map<String, Object> orig) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(orig);
        oos.flush();
        ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bin);
        return (Map)ois.readObject();
    }

    static Credentials getCredentialsById(String credentialsId) {
        List credentialsList = CredentialsProvider.lookupCredentialsInItem(Credentials.class, null, (Authentication)ACL.SYSTEM2, Collections.emptyList());
        Credentials requestedCredentials = CredentialsMatchers.firstOrNull((Iterable)credentialsList, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (requestedCredentials == null) {
            throw new CredentialsUnavailableException("No credentials found with ID: " + credentialsId);
        }
        return requestedCredentials;
    }
}

