/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.globalyamlproperties.ConfigValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;
import org.yaml.snakeyaml.Yaml;

public class PipelineYAMLJobProperty
extends JobProperty<AbstractProject<?, ?>>
implements Serializable {
    private final String yamlConfiguration;
    private transient HashMap<String, Object> parsedConfig;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public PipelineYAMLJobProperty(String yamlConfiguration) {
        this.yamlConfiguration = yamlConfiguration;
        Yaml parser = new Yaml();
        this.parsedConfig = (HashMap)parser.load(yamlConfiguration);
        parser = null;
    }

    public String getYamlConfiguration() {
        return this.yamlConfiguration;
    }

    private void readObject(@NonNull ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        Yaml parser = new Yaml();
        this.parsedConfig = (HashMap)parser.load(this.yamlConfiguration);
        parser = null;
    }

    public Map<String, Object> getParsedConfig() {
        if (this.parsedConfig == null) {
            Yaml parser = new Yaml();
            this.parsedConfig = (HashMap)parser.load(this.yamlConfiguration);
        }
        return this.parsedConfig == null ? new HashMap<String, Object>() : this.parsedConfig;
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            return super.configure(req, json);
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public JobProperty<?> newInstance(StaplerRequest2 req, JSONObject formData) {
            String yamlConfiguration = formData.getString("yamlConfiguration");
            return new PipelineYAMLJobProperty(yamlConfiguration);
        }

        @POST
        public FormValidation doCheckYamlConfiguration(@QueryParameter String value) {
            return ConfigValidator.validateYamlConfig(value);
        }

        @NonNull
        public String getDisplayName() {
            return "Custom YAML Configuration";
        }
    }
}

