/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties;

import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import io.jenkins.plugins.globalyamlproperties.ConfigValidator;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.yaml.snakeyaml.Yaml;

public class MultibranchYAMLJobProperty
extends AbstractFolderProperty<WorkflowMultiBranchProject> {
    private String yamlConfiguration;
    private Map<String, Object> parsedConfig;

    @DataBoundConstructor
    public MultibranchYAMLJobProperty(String yamlConfiguration) {
        this.yamlConfiguration = yamlConfiguration;
        if (yamlConfiguration.isEmpty()) {
            this.parsedConfig = new HashMap<String, Object>();
        } else {
            this.parseYamlConfig();
        }
    }

    private void parseYamlConfig() {
        Yaml parser = new Yaml();
        this.parsedConfig = (Map)parser.load(this.yamlConfiguration);
        parser = null;
    }

    public Map<String, Object> getParsedConfig() {
        if (this.parsedConfig == null) {
            this.parseYamlConfig();
        }
        return this.parsedConfig;
    }

    @DataBoundSetter
    void setYamlConfiguration(String yamlConfiguration) {
        this.yamlConfiguration = yamlConfiguration;
        this.parseYamlConfig();
    }

    public String getYamlConfiguration() {
        return this.yamlConfiguration;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "YAML Configuration";
        }

        @POST
        public FormValidation doCheckYamlConfiguration(@QueryParameter String value) {
            return ConfigValidator.validateYamlConfig(value);
        }
    }
}

