/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import io.jenkins.plugins.globalyamlproperties.Config;
import io.jenkins.plugins.globalyamlproperties.GlobalYAMLPropertiesConfigurationException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class GlobalYAMLPropertiesConfiguration
extends GlobalConfiguration
implements Serializable {
    private List<Config> configs = new ArrayList<Config>();
    private int refreshInterval = 60;

    public static GlobalYAMLPropertiesConfiguration get() {
        return (GlobalYAMLPropertiesConfiguration)ExtensionList.lookupSingleton(GlobalYAMLPropertiesConfiguration.class);
    }

    public GlobalYAMLPropertiesConfiguration() {
        this.load();
    }

    public List<Config> getConfigs() {
        return this.configs;
    }

    public Config getConfigByName(String name) throws GlobalYAMLPropertiesConfigurationException {
        for (Config config : this.configs) {
            if (!config.getName().equals(name)) continue;
            return config;
        }
        throw new GlobalYAMLPropertiesConfigurationException("Config with name " + name + " not found");
    }

    public List<String> getConfigNames() {
        ArrayList<String> configNames = new ArrayList<String>();
        for (Config config : this.configs) {
            configNames.add(config.getName());
        }
        return configNames;
    }

    void refreshConfiguration() throws IOException {
        for (Config config : this.configs) {
            config.refreshConfiguration();
        }
    }

    public List<Config> getConfigsByCategory(String category) {
        ArrayList<Config> collectedConfigs = new ArrayList<Config>();
        for (Config config : this.configs) {
            if (!config.getCategory().equals(category)) continue;
            collectedConfigs.add(config);
        }
        return collectedConfigs;
    }

    public List<String> getConfigNamesByCategory(String category) {
        ArrayList<String> collectedConfigNames = new ArrayList<String>();
        for (Config config : this.configs) {
            if (!config.getCategory().equals(category)) continue;
            collectedConfigNames.add(config.getName());
        }
        return collectedConfigNames;
    }

    public List<String> getCategories() {
        HashSet<String> categories = new HashSet<String>();
        for (Config config : this.getConfigs()) {
            if (config.getCategory() == null || config.getCategory().isEmpty()) continue;
            categories.add(config.getCategory());
        }
        return new ArrayList<String>(categories);
    }

    public Config getDefaultConfig() {
        return this.configs.get(0);
    }

    @DataBoundSetter
    public void setConfigs(List<Config> configs) {
        this.configs = configs;
        this.save();
    }

    @DataBoundSetter
    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
        this.save();
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        String configsField = "configs";
        if (!json.has(configsField)) {
            return true;
        }
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }
}

