/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.util.FormValidation;
import io.jenkins.plugins.globalyamlproperties.Config;
import io.jenkins.plugins.globalyamlproperties.ConfigSource;
import io.jenkins.plugins.globalyamlproperties.ConfigSourceManual;
import io.jenkins.plugins.globalyamlproperties.ConfigSourceSCM;
import io.jenkins.plugins.globalyamlproperties.ConfigValidator;
import io.jenkins.plugins.globalyamlproperties.GlobalYAMLPropertiesConfiguration;
import io.jenkins.plugins.globalyamlproperties.Messages;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;
import org.springframework.lang.NonNull;

@Extension
public class ConfigurationManagementLink
extends ManagementLink {
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(ConfigurationManagementLink.class, Messages._permission_component());
    public static final Permission VIEW_CONFIG = new Permission(PERMISSIONS, "View", Messages._permission_view(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    public static final Permission UPDATE_CONFIG = new Permission(PERMISSIONS, "Edit", Messages._permission_edit(), Jenkins.ADMINISTER, PermissionScope.JENKINS);
    private List<Config> configs = new ArrayList<Config>();

    public String getIconFileName() {
        return "symbol-document-text-outline plugin-ionicons-api";
    }

    public GlobalYAMLPropertiesConfiguration getConfiguration() {
        if (!Jenkins.get().hasPermission(VIEW_CONFIG)) {
            return null;
        }
        return GlobalYAMLPropertiesConfiguration.get();
    }

    @POST
    public HttpResponse doConfigure(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException {
        if (!Jenkins.get().hasPermission(UPDATE_CONFIG)) {
            return HttpResponses.errorWithoutStack((int)403, (String)"You have no permissions to update global configuration");
        }
        GlobalYAMLPropertiesConfiguration globalConfig = this.getConfiguration();
        String configNameField = "name";
        String yamlConfigField = "yamlConfig";
        String configSourceField = "configSource";
        JSONObject json = req.getSubmittedForm();
        Object configs = json.get("configs");
        ArrayList<JSONObject> configList = new ArrayList<JSONObject>();
        if (configs instanceof JSONArray) {
            JSONArray configsArray = json.getJSONArray("configs");
            Iterator iterator = configsArray.iterator();
            while (iterator.hasNext()) {
                Object config = iterator.next();
                configList.add((JSONObject)config);
            }
        } else if (configs instanceof JSONObject) {
            configList.add((JSONObject)configs);
        }
        for (JSONObject obj : configList) {
            HttpResponses.HttpResponseException validationError = this.validateConfig(obj, configNameField, configSourceField, yamlConfigField);
            if (validationError == null) continue;
            return validationError;
        }
        req.bindJSON((Object)globalConfig, json);
        try {
            globalConfig.refreshConfiguration();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        globalConfig.save();
        return HttpResponses.redirectTo((String)".");
    }

    HttpResponses.HttpResponseException validateConfig(JSONObject config, String nameField, String configSourceField, String yamlConfigField) {
        if (config == null) {
            return null;
        }
        if (!config.has(nameField) || !(config.get(nameField) instanceof String)) {
            return HttpResponses.errorWithoutStack((int)400, (String)"Global YAML Configuration is not valid: Config name must be a string");
        }
        if (!config.has(configSourceField)) {
            return HttpResponses.errorWithoutStack((int)400, (String)"Global YAML Configuration is not valid: Config has no configuration source");
        }
        JSONObject configSource = config.getJSONObject(configSourceField);
        if (configSource.get("stapler-class").equals(ConfigSourceManual.class.getName())) {
            FormValidation yamlConfigValidation = ConfigValidator.validateYamlConfig(configSource.getString(yamlConfigField));
            if (yamlConfigValidation.kind == FormValidation.Kind.ERROR) {
                return HttpResponses.errorWithoutStack((int)400, (String)("Global YAML Configuration [" + String.valueOf(config.get(nameField)) + "] is not valid: " + yamlConfigValidation.getMessage()));
            }
        }
        return null;
    }

    @POST
    public FormValidation doCheckName(@QueryParameter String value) {
        if (!Jenkins.get().hasPermission(UPDATE_CONFIG)) {
            return FormValidation.error((String)"You have no permissions to update global configuration");
        }
        return ConfigValidator.validateName(value);
    }

    public List<Descriptor<ConfigSource>> getApplicableConfigSources() {
        Logger logger = Logger.getLogger(ConfigurationManagementLink.class.getName());
        logger.info("getApplicableConfigSources");
        ArrayList<Descriptor<ConfigSource>> applicableConfigSources = new ArrayList<Descriptor<ConfigSource>>();
        applicableConfigSources.add(Jenkins.get().getDescriptor(ConfigSourceSCM.class));
        applicableConfigSources.add(Jenkins.get().getDescriptor(ConfigSourceManual.class));
        return applicableConfigSources;
    }

    @POST
    public FormValidation doCheckYamlConfig(@QueryParameter String value) {
        if (!Jenkins.get().hasPermission(UPDATE_CONFIG)) {
            return FormValidation.error((String)"You have no permissions to update global configuration");
        }
        return ConfigValidator.validateYamlConfig(value);
    }

    public String getUrlName() {
        return "globalyamlconfiguration";
    }

    public String getDisplayName() {
        return "Global YAML Configuration";
    }

    public String getDescription() {
        return "Manage Global YAML Configurations";
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }
}

