/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties;

import hudson.util.FormValidation;
import io.jenkins.plugins.globalyamlproperties.GlobalYAMLPropertiesConfigurationException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class ConfigValidator {
    public static FormValidation validateName(String name) {
        if (name == null || name.isEmpty()) {
            return FormValidation.error((String)"Name cannot be empty");
        }
        return FormValidation.ok();
    }

    public static FormValidation validateYamlConfig(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return FormValidation.warning((String)"Config is empty");
        }
        Yaml parser = new Yaml();
        try {
            Object parsedYAML = parser.load(value);
            if (!(parsedYAML instanceof Map)) {
                throw new GlobalYAMLPropertiesConfigurationException("Provided config's root element is not a Map");
            }
        }
        catch (YAMLException e) {
            return FormValidation.error((String)"Config is not a valid YAML file");
        }
        catch (GlobalYAMLPropertiesConfigurationException e) {
            return FormValidation.error((String)"Specified YAML config is valid, but root element is not a Map. Please, use key-value format for root element");
        }
        return FormValidation.ok((String)"YAML config is valid");
    }
}

