/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.globalyamlproperties.ConfigSource;
import io.jenkins.plugins.globalyamlproperties.ConfigValidator;
import io.jenkins.plugins.globalyamlproperties.Utils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubAppCredentials;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class ConfigSourceSCM
implements ConfigSource,
Serializable {
    private String yamlConfig;
    private String repositoryName;
    private String repositoryOwner;
    private String ref;
    private String credentialsId;
    private String path;

    @DataBoundConstructor
    public ConfigSourceSCM(String repositoryName, String repositoryOwner, String ref, String credentialsId, String path) {
        this.ref = ref;
        this.credentialsId = credentialsId;
        this.path = path;
        this.repositoryOwner = repositoryOwner;
        this.repositoryName = repositoryName;
    }

    @Override
    public String getYamlConfig() {
        return this.yamlConfig;
    }

    @DataBoundSetter
    void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    void setRef(String ref) {
        this.ref = ref;
    }

    @DataBoundSetter
    void setPath(String path) {
        this.path = path;
    }

    @DataBoundSetter
    void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @DataBoundSetter
    void setRepositoryOwner(String repositoryOwner) {
        this.repositoryOwner = repositoryOwner;
    }

    public String getRepositoryOwner() {
        return this.repositoryOwner;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getRef() {
        return this.ref;
    }

    public String getPath() {
        return this.path;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchConfiguration() throws IOException {
        GitHub connect = Connector.connect((String)"https://api.github.com", (StandardCredentials)((GitHubAppCredentials)Utils.getCredentialsById(this.credentialsId)));
        try {
            GHRepository repository = connect.getRepository(this.repositoryOwner + "/" + this.repositoryName);
            GHContent content = repository.getFileContent(this.path, this.ref);
            this.yamlConfig = Utils.readInputStream(content.read());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Connector.release((GitHub)connect);
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ConfigSource> {
        @POST
        public FormValidation doCheckName(@QueryParameter String value) {
            return ConfigValidator.validateName(value);
        }

        @POST
        public FormValidation doCheckYamlConfig(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.error((String)"Only administrators can update global configuration");
            }
            return ConfigValidator.validateYamlConfig(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @POST
        public FormValidation doValidate(@QueryParameter(value="repositoryName") String repositoryName, @QueryParameter(value="repositoryOwner") String repositoryOwner, @QueryParameter(value="ref") String ref, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="path") String path) {
            FormValidation formValidation;
            GitHubAppCredentials requestedCredentials = (GitHubAppCredentials)Utils.getCredentialsById(credentialsId);
            GitHub connect = Connector.connect((String)"https://api.github.com", (StandardCredentials)requestedCredentials);
            try {
                GHRepository repository = connect.getRepository(repositoryOwner + "/" + repositoryName);
                GHContent content = repository.getFileContent(path, ref);
                String yamlConfig = Utils.readInputStream(content.read());
                formValidation = FormValidation.ok((String)("Success, Remaining rate limit: " + connect.getRateLimit().getRemaining() + "\n" + yamlConfig));
            }
            catch (Throwable throwable) {
                try {
                    Connector.release((GitHub)connect);
                    throw throwable;
                }
                catch (Exception e) {
                    return FormValidation.error((String)e.toString());
                }
            }
            Connector.release((GitHub)connect);
            return formValidation;
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems() {
            ListBoxModel items = new ListBoxModel();
            List credentials = CredentialsProvider.lookupCredentialsInItem(GitHubAppCredentials.class, null, (Authentication)ACL.SYSTEM2, Collections.emptyList());
            for (GitHubAppCredentials c : credentials) {
                items.add(c.getId());
            }
            return items;
        }

        @NonNull
        public String getDisplayName() {
            return "Config from SCM";
        }
    }
}

