/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.globalyamlproperties;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.globalyamlproperties.ConfigSource;
import io.jenkins.plugins.globalyamlproperties.ConfigValidator;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ConfigSourceManual
implements ConfigSource,
Serializable {
    private String yamlConfig;

    @DataBoundConstructor
    public ConfigSourceManual(String yamlConfig) {
        this.yamlConfig = yamlConfig;
    }

    @Override
    public String getYamlConfig() {
        return this.yamlConfig;
    }

    @DataBoundSetter
    public void setYamlConfig(String yamlConfig) {
        this.yamlConfig = yamlConfig;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ConfigSource> {
        @POST
        public FormValidation doCheckYamlConfig(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.error((String)"Only administrators can update global configuration");
            }
            return ConfigValidator.validateYamlConfig(value);
        }

        @NonNull
        public String getDisplayName() {
            return "Manually defined config";
        }
    }
}

