/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.webhook.build;

import com.dabsquared.gitlabjenkins.GitLabPushTrigger;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.PipelineHook;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.Project;
import com.dabsquared.gitlabjenkins.util.JsonUtil;
import com.dabsquared.gitlabjenkins.webhook.build.BuildWebHookAction;
import com.fasterxml.jackson.databind.JsonNode;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.util.HttpResponses;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;

public class PipelineBuildAction
extends BuildWebHookAction {
    private static final Logger LOGGER = Logger.getLogger(PipelineBuildAction.class.getName());
    private Item project;
    private PipelineHook pipelineBuildHook;
    private final String secretToken;

    public PipelineBuildAction(Item project, String json, String secretToken) {
        LOGGER.log(Level.FINE, "Pipeline event: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.pipelineBuildHook = JsonUtil.read(json, PipelineHook.class);
        this.secretToken = secretToken;
    }

    public PipelineBuildAction(Item project, JsonNode json, String secretToken) {
        LOGGER.log(Level.FINE, "Pipeline event: {0}", JsonUtil.toPrettyPrint(json));
        this.project = project;
        this.pipelineBuildHook = JsonUtil.read(json, PipelineHook.class);
        this.secretToken = secretToken;
    }

    @Override
    void processForCompatibility() {
        if (this.pipelineBuildHook.getProject() == null && this.pipelineBuildHook.getRepository() != null) {
            try {
                String path = new URL(this.pipelineBuildHook.getRepository().getGitHttpUrl()).getPath();
                if (StringUtils.isNotBlank((CharSequence)path)) {
                    Project project = new Project();
                    project.setNamespace(path.replaceFirst("/", "").substring(0, path.lastIndexOf("/")));
                    this.pipelineBuildHook.setProject(project);
                } else {
                    LOGGER.log(Level.WARNING, "Could not find suitable namespace.");
                }
            }
            catch (MalformedURLException ignored) {
                LOGGER.log(Level.WARNING, "Invalid repository url found while building namespace.");
            }
        }
    }

    @Override
    void execute() {
        if (!(this.project instanceof Job)) {
            throw HttpResponses.errorWithoutStack((int)409, (String)"Pipeline Hook is not supported for this project");
        }
        ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new BuildWebHookAction.TriggerNotifier(this.project, this.secretToken, Jenkins.getAuthentication()){

            @Override
            protected void performOnPost(GitLabPushTrigger trigger) {
                trigger.onPost(PipelineBuildAction.this.pipelineBuildHook);
            }
        });
        throw HttpResponses.ok();
    }
}

