/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.connection;

import com.dabsquared.gitlabjenkins.connection.GitLabApiToken;
import com.dabsquared.gitlabjenkins.connection.GitLabApiTokenImpl;
import com.dabsquared.gitlabjenkins.connection.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitLabApiTokenBinding
extends MultiBinding<GitLabApiToken> {
    private final String variable;

    @DataBoundConstructor
    public GitLabApiTokenBinding(String credentialsId, String variable) {
        super(credentialsId);
        this.variable = variable;
    }

    protected Class<GitLabApiToken> type() {
        return GitLabApiToken.class;
    }

    public Set<String> variables() {
        return Collections.singleton(this.variable);
    }

    public MultiBinding.MultiEnvironment bind(@NonNull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        GitLabApiToken credentials = (GitLabApiToken)this.getCredentials(build);
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put(this.variable, Secret.toString((Secret)credentials.getApiToken()));
        return new MultiBinding.MultiEnvironment(values);
    }

    @Symbol(value={"gitlabApiToken"})
    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<GitLabApiTokenImpl> {
        protected Class<GitLabApiTokenImpl> type() {
            return GitLabApiTokenImpl.class;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.GitLabApiToken_name();
        }

        public boolean requiresWorkspace() {
            return false;
        }
    }
}

