/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.trigger.handler.push;

import com.dabsquared.gitlabjenkins.cause.CauseData;
import com.dabsquared.gitlabjenkins.cause.CauseDataBuilder;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.Commit;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.PushHook;
import com.dabsquared.gitlabjenkins.trigger.exception.NoRevisionToBuildException;
import com.dabsquared.gitlabjenkins.trigger.filter.BranchFilter;
import com.dabsquared.gitlabjenkins.trigger.filter.MergeRequestLabelFilter;
import com.dabsquared.gitlabjenkins.trigger.handler.AbstractWebHookTriggerHandler;
import com.dabsquared.gitlabjenkins.trigger.handler.builder.generated.BuildStatusUpdateBuilder;
import com.dabsquared.gitlabjenkins.trigger.handler.push.PushHookTriggerHandler;
import hudson.model.Job;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.RevisionParameterAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.util.StringUtils;

class PushHookTriggerHandlerImpl
extends AbstractWebHookTriggerHandler<PushHook>
implements PushHookTriggerHandler {
    private static final String NO_COMMIT = "0000000000000000000000000000000000000000";
    private boolean triggerToBranchDeleteRequest = false;
    private static final Logger LOGGER = Logger.getLogger(PushHookTriggerHandlerImpl.class.getName());

    public PushHookTriggerHandlerImpl(boolean triggerToBranchDeleteRequest) {
        this.triggerToBranchDeleteRequest = triggerToBranchDeleteRequest;
    }

    @Override
    public void handle(Job<?, ?> job, PushHook hook, boolean ciSkip, BranchFilter branchFilter, MergeRequestLabelFilter mergeRequestLabelFilter) {
        if (this.isNoRemoveBranchPush(hook) || this.triggerToBranchDeleteRequest) {
            super.handle(job, hook, ciSkip, branchFilter, mergeRequestLabelFilter);
        }
    }

    @Override
    protected boolean isCiSkip(PushHook hook) {
        List<Commit> commits = hook.getCommits();
        return commits != null && !commits.isEmpty() && commits.get(commits.size() - 1).getMessage() != null && commits.get(commits.size() - 1).getMessage().contains("[ci-skip]");
    }

    @Override
    protected CauseData retrieveCauseData(PushHook hook) {
        try {
            CauseData.ActionType actionType = hook.getObjectKind().equals("tag_push") ? CauseData.ActionType.TAG_PUSH : CauseData.ActionType.PUSH;
            return CauseDataBuilder.causeData().withActionType(actionType).withSourceProjectId(hook.getProjectId()).withTargetProjectId(hook.getProjectId()).withBranch(this.getTargetBranch(hook)).withSourceBranch(this.getTargetBranch(hook)).withUserName(hook.getUserName()).withUserUsername(hook.getUserUsername()).withUserEmail(hook.getUserEmail()).withSourceRepoHomepage(hook.getRepository().getHomepage()).withSourceRepoName(hook.getRepository().getName()).withSourceNamespace(hook.getProject().getNamespace()).withSourceRepoUrl(hook.getRepository().getUrl()).withSourceRepoSshUrl(hook.getRepository().getGitSshUrl()).withSourceRepoHttpUrl(hook.getRepository().getGitHttpUrl()).withMergeCommitSha(null).withMergeRequestTitle("").withMergeRequestDescription("").withMergeRequestId(null).withMergeRequestIid(null).withMergeRequestState(null).withMergedByUser("").withMergeRequestAssignee("").withMergeRequestTargetProjectId(null).withTargetBranch(this.getTargetBranch(hook)).withTargetRepoName("").withTargetNamespace("").withTargetRepoSshUrl("").withTargetRepoHttpUrl("").withTriggeredByUser(this.retrievePushedBy(hook)).withBefore(hook.getBefore()).withAfter(hook.getAfter()).withLastCommit(hook.getAfter()).withTargetProjectUrl(hook.getProject().getWebUrl()).build();
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    @Override
    protected String getSourceBranch(PushHook hook) {
        return hook.getRef() == null ? null : hook.getRef().replaceFirst("^refs/heads/", "");
    }

    @Override
    protected String getTargetBranch(PushHook hook) {
        return hook.getRef() == null ? null : hook.getRef().replaceFirst("^refs/heads/", "");
    }

    @Override
    protected String getTriggerType() {
        return "push";
    }

    @Override
    protected RevisionParameterAction createRevisionParameter(PushHook hook, GitSCM gitSCM) throws NoRevisionToBuildException {
        return new RevisionParameterAction(this.retrieveRevisionToBuild(hook, gitSCM), this.retrieveUrIish(hook));
    }

    @Override
    protected AbstractWebHookTriggerHandler.BuildStatusUpdate retrieveBuildStatusUpdate(PushHook hook) {
        return BuildStatusUpdateBuilder.buildStatusUpdate().withProjectId(hook.getProjectId()).withSha(hook.getAfter()).withRef(this.getTargetBranch(hook)).build();
    }

    private String retrievePushedBy(PushHook hook) {
        String userName = hook.getUserName();
        if (!StringUtils.isEmptyOrNull((String)userName)) {
            return userName;
        }
        String userUsername = hook.getUserUsername();
        if (!StringUtils.isEmptyOrNull((String)userUsername)) {
            return userUsername;
        }
        List<Commit> commits = hook.getCommits();
        if (commits != null && !commits.isEmpty()) {
            return commits.get(commits.size() - 1).getAuthor().getName();
        }
        return null;
    }

    private String retrieveRevisionToBuild(PushHook hook, GitSCM gitSCM) throws NoRevisionToBuildException {
        if (this.inNoBranchDelete(hook)) {
            if (gitSCM != null && gitSCM.getRepositories().size() == 1) {
                String repositoryName = ((RemoteConfig)gitSCM.getRepositories().get(0)).getName();
                return hook.getRef().replaceFirst("^refs/heads", "remotes/" + repositoryName);
            }
            return hook.getAfter();
        }
        throw new NoRevisionToBuildException();
    }

    private boolean inNoBranchDelete(PushHook hook) {
        return hook.getAfter() != null && !hook.getAfter().equals(NO_COMMIT);
    }

    private boolean isNoRemoveBranchPush(PushHook hook) {
        return hook.getAfter() != null && !hook.getAfter().equals(NO_COMMIT);
    }
}

