/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.connection;

import com.dabsquared.gitlabjenkins.connection.GitLabConnection;
import com.dabsquared.gitlabjenkins.connection.Messages;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Item;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class GitLabConnectionConfig
extends GlobalConfiguration {
    private Boolean useAuthenticatedEndpoint = true;
    private List<GitLabConnection> connections = new ArrayList<GitLabConnection>();
    private transient Map<String, GitLabConnection> connectionMap = new HashMap<String, GitLabConnection>();

    @DataBoundConstructor
    public GitLabConnectionConfig() {
        this.load();
        this.refreshConnectionMap();
    }

    public boolean isUseAuthenticatedEndpoint() {
        return this.useAuthenticatedEndpoint;
    }

    @DataBoundSetter
    public void setUseAuthenticatedEndpoint(boolean useAuthenticatedEndpoint) {
        this.useAuthenticatedEndpoint = useAuthenticatedEndpoint;
        this.save();
    }

    public List<GitLabConnection> getConnections() {
        return this.connections;
    }

    private void addConnection(List<GitLabConnection> list, Map<String, GitLabConnection> map, GitLabConnection connection) {
        String name = connection.getName();
        if (map.containsKey(name)) {
            throw new IllegalArgumentException(Messages.name_exists(name));
        }
        list.add(connection);
        map.put(name, connection);
    }

    public void addConnection(GitLabConnection connection) {
        this.addConnection(this.connections, this.connectionMap, connection);
    }

    @DataBoundSetter
    public void setConnections(List<GitLabConnection> newConnections) {
        ArrayList<GitLabConnection> tempConnections = new ArrayList<GitLabConnection>();
        HashMap<String, GitLabConnection> tempConnectionMap = new HashMap<String, GitLabConnection>();
        for (GitLabConnection connection : newConnections) {
            this.addConnection(tempConnections, tempConnectionMap, connection);
        }
        this.connections = tempConnections;
        this.connectionMap = tempConnectionMap;
        this.save();
    }

    public GitLabClient getClient(String connectionName, Item item, String jobCredentialId) {
        if (!this.connectionMap.containsKey(connectionName)) {
            return null;
        }
        return this.connectionMap.get(connectionName).getClient(item, jobCredentialId);
    }

    private void refreshConnectionMap() {
        this.connectionMap.clear();
        for (GitLabConnection connection : this.connections) {
            this.connectionMap.put(connection.getName(), connection);
        }
    }

    protected GitLabConnectionConfig readResolve() {
        if (this.useAuthenticatedEndpoint == null) {
            this.setUseAuthenticatedEndpoint(false);
        }
        return this;
    }

    public static GitLabConnectionConfig get() {
        return (GitLabConnectionConfig)((Object)ExtensionList.lookupSingleton(GitLabConnectionConfig.class));
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        try {
            return super.configure(req, json);
        }
        catch (IllegalArgumentException e) {
            throw new Descriptor.FormException(e.getMessage(), "connections");
        }
    }
}

