/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.workflow;

import com.dabsquared.gitlabjenkins.cause.GitLabWebHookCause;
import com.dabsquared.gitlabjenkins.connection.GitLabConnectionProperty;
import com.dabsquared.gitlabjenkins.gitlab.api.GitLabClient;
import com.dabsquared.gitlabjenkins.gitlab.api.model.MergeRequest;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class AcceptGitLabMergeRequestStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(AcceptGitLabMergeRequestStep.class.getName());
    private String mergeCommitMessage;
    private boolean useMRDescription;
    private Boolean removeSourceBranch;

    @Deprecated
    public AcceptGitLabMergeRequestStep(String mergeCommitMessage, boolean useMRDescription, boolean removeSourceBranch) {
        this.mergeCommitMessage = StringUtils.isEmpty((CharSequence)mergeCommitMessage) ? null : mergeCommitMessage;
        this.useMRDescription = useMRDescription;
        this.removeSourceBranch = removeSourceBranch;
    }

    @DataBoundConstructor
    public AcceptGitLabMergeRequestStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new AcceptGitLabMergeRequestStepExecution(context, this);
    }

    public String getMergeCommitMessage() {
        return this.mergeCommitMessage;
    }

    public Boolean getRemoveSourceBranch() {
        return this.removeSourceBranch;
    }

    public boolean getUseMRDescription() {
        return this.useMRDescription;
    }

    @DataBoundSetter
    public void setMergeCommitMessage(String mergeCommitMessage) {
        this.mergeCommitMessage = StringUtils.isEmpty((CharSequence)mergeCommitMessage) ? null : mergeCommitMessage;
    }

    @DataBoundSetter
    public void setUseMRDescription(boolean useMRDescription) {
        this.useMRDescription = useMRDescription;
    }

    @DataBoundSetter
    public void setRemoveSourceBranch(boolean removeSourceBranch) {
        this.removeSourceBranch = removeSourceBranch;
    }

    public static class AcceptGitLabMergeRequestStepExecution
    extends AbstractSynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient Run<?, ?> run;
        private final transient AcceptGitLabMergeRequestStep step;

        AcceptGitLabMergeRequestStepExecution(StepContext context, AcceptGitLabMergeRequestStep step) throws Exception {
            super(context);
            this.step = step;
            this.run = (Run)context.get(Run.class);
        }

        protected Void run() throws Exception {
            MergeRequest mergeRequest;
            GitLabWebHookCause cause = (GitLabWebHookCause)this.run.getCause(GitLabWebHookCause.class);
            if (cause != null && (mergeRequest = cause.getData().getMergeRequest()) != null) {
                GitLabClient client = GitLabConnectionProperty.getClient(this.run);
                if (client == null) {
                    this.println("No GitLab connection configured");
                } else {
                    try {
                        client.acceptMergeRequest(mergeRequest, this.getCommitMessage(mergeRequest), this.step.removeSourceBranch);
                    }
                    catch (ProcessingException | WebApplicationException e) {
                        this.printf("Failed to accept merge request for project '%s': %s%n", mergeRequest.getProjectId(), e.getMessage());
                        LOGGER.log(Level.SEVERE, "Failed to accept merge request for project '%s'".formatted(mergeRequest.getProjectId()), e);
                    }
                }
            }
            return null;
        }

        private String getCommitMessage(MergeRequest mergeRequest) {
            if (!this.step.useMRDescription) {
                return this.step.mergeCommitMessage;
            }
            return "Merge branch '%s' into '%s'%n%n%s%n%n%s%n%nSee merge request !%d".formatted(mergeRequest.getSourceBranch(), mergeRequest.getTargetBranch(), mergeRequest.getTitle(), mergeRequest.getDescription(), mergeRequest.getIid());
        }

        private void println(String message) {
            TaskListener listener = this.getTaskListener();
            if (listener == null) {
                LOGGER.log(Level.FINE, "failed to print message {0} due to null TaskListener", message);
            } else {
                listener.getLogger().println(message);
            }
        }

        private void printf(String message, Object ... args) {
            TaskListener listener = this.getTaskListener();
            if (listener == null) {
                LOGGER.log(Level.FINE, "failed to print message {0} due to null TaskListener", message.formatted(args));
            } else {
                listener.getLogger().printf(message, args);
            }
        }

        private TaskListener getTaskListener() {
            StepContext context = this.getContext();
            if (!context.isReady()) {
                return null;
            }
            try {
                return (TaskListener)context.get(TaskListener.class);
            }
            catch (Exception x) {
                return null;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Accept GitLab Merge Request";
        }

        public String getFunctionName() {
            return "acceptGitLabMR";
        }

        public Set<Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, TaskListener.class, Run.class);
            return Collections.unmodifiableSet(context);
        }
    }
}

