/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.util;

import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.git.Branch;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.MergeRecord;

public class BuildUtil {
    public static Run<?, ?> getBuildByBranch(Job<?, ?> project, String branchName) {
        for (Run build : project.getBuilds()) {
            BuildData data = (BuildData)build.getAction(BuildData.class);
            MergeRecord merge = (MergeRecord)build.getAction(MergeRecord.class);
            if (!BuildUtil.hasLastBuild(data) || !BuildUtil.isNoMergeBuild(data, merge)) continue;
            for (Branch branch : data.lastBuild.getRevision().getBranches()) {
                if (!branch.getName().endsWith("/" + branchName)) continue;
                return build;
            }
        }
        return null;
    }

    public static Run<?, ?> getBuildBySHA1WithoutMergeBuilds(Job<?, ?> project, String sha1) {
        for (Run build : project.getBuilds()) {
            MergeRecord merge = (MergeRecord)build.getAction(MergeRecord.class);
            for (BuildData data : build.getActions(BuildData.class)) {
                if (!BuildUtil.hasLastBuild(data) || !BuildUtil.isNoMergeBuild(data, merge) || !data.lastBuild.isFor(sha1)) continue;
                return build;
            }
        }
        return null;
    }

    public static Run<?, ?> getBuildBySHA1IncludingMergeBuilds(Job<?, ?> project, String sha1) {
        for (Run build : project.getBuilds()) {
            for (BuildData data : build.getActions(BuildData.class)) {
                if (data == null || data.lastBuild == null || data.lastBuild.getMarked() == null || !data.lastBuild.getMarked().getSha1String().equals(sha1)) continue;
                return build;
            }
        }
        return null;
    }

    private static boolean isNoMergeBuild(BuildData data, MergeRecord merge) {
        return merge == null || merge.getSha1().equals(data.lastBuild.getMarked().getSha1String());
    }

    private static boolean hasLastBuild(BuildData data) {
        return data != null && data.lastBuild != null && data.lastBuild.getRevision() != null;
    }
}

