/*
 * Decompiled with CFR 0.152.
 */
package com.dabsquared.gitlabjenkins.gitlab.api.impl;

import com.dabsquared.gitlabjenkins.gitlab.api.impl.GitLabApiProxy;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Awardable;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Branch;
import com.dabsquared.gitlabjenkins.gitlab.api.model.BuildState;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Group;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Label;
import com.dabsquared.gitlabjenkins.gitlab.api.model.MergeRequest;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Pipeline;
import com.dabsquared.gitlabjenkins.gitlab.api.model.Project;
import com.dabsquared.gitlabjenkins.gitlab.api.model.ProjectHook;
import com.dabsquared.gitlabjenkins.gitlab.api.model.User;
import com.dabsquared.gitlabjenkins.gitlab.hook.model.State;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;

@Path(value="/api/v3")
interface V3GitLabApiProxy
extends GitLabApiProxy {
    public static final String ID = "v3";

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/groups")
    public List<Group> getGroups(@QueryParam(value="all_available") Boolean var1, @QueryParam(value="top_level_only") Boolean var2, @QueryParam(value="order_by") String var3, @QueryParam(value="sort") String var4);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/groups/{groupId}/projects")
    public List<Project> getGroupProjects(@PathParam(value="groupId") @Encoded String var1, @QueryParam(value="include_subgroups") Boolean var2, @QueryParam(value="visibility") String var3, @QueryParam(value="order_by") String var4, @QueryParam(value="sort") String var5);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects")
    public Project createProject(@FormParam(value="name") String var1);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects/{projectId}/merge_requests")
    public MergeRequest createMergeRequest(@PathParam(value="projectId") @Encoded Integer var1, @FormParam(value="source_branch") String var2, @FormParam(value="target_branch") String var3, @FormParam(value="title") String var4);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/projects/{projectName}")
    public Project getProject(@PathParam(value="projectName") @Encoded String var1);

    @Override
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects/{projectId}")
    public Project updateProject(@PathParam(value="projectId") @Encoded String var1, @FormParam(value="name") String var2, @FormParam(value="path") String var3);

    @Override
    @DELETE
    @Path(value="/projects/{projectId}")
    public void deleteProject(@PathParam(value="projectId") @Encoded String var1);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/projects/{projectName}/hooks")
    public List<ProjectHook> getProjectHooks(@PathParam(value="projectName") @Encoded String var1);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects/{projectId}/hooks")
    public void addProjectHook(@PathParam(value="projectId") @Encoded String var1, @FormParam(value="url") String var2, @FormParam(value="push_events") Boolean var3, @FormParam(value="merge_requests_events") Boolean var4, @FormParam(value="note_events") Boolean var5);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects/{projectId}/hooks")
    public void addProjectHook(@PathParam(value="projectId") @Encoded String var1, @FormParam(value="url") String var2, @FormParam(value="token") String var3, @FormParam(value="push_events") Boolean var4, @FormParam(value="merge_requests_events") Boolean var5, @FormParam(value="note_events") Boolean var6);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects/{projectId}/statuses/{sha}")
    public void changeBuildStatus(@PathParam(value="projectId") @Encoded String var1, @PathParam(value="sha") @Encoded String var2, @FormParam(value="state") BuildState var3, @FormParam(value="ref") String var4, @FormParam(value="context") String var5, @FormParam(value="target_url") String var6, @FormParam(value="description") String var7);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects/{projectId}/statuses/{sha}")
    public void changeBuildStatus(@PathParam(value="projectId") @Encoded Integer var1, @PathParam(value="sha") @Encoded String var2, @FormParam(value="state") BuildState var3, @FormParam(value="ref") String var4, @FormParam(value="context") String var5, @FormParam(value="target_url") String var6, @FormParam(value="description") String var7);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/projects/{projectId}/repository/commits/{sha}")
    public void getCommit(@PathParam(value="projectId") @Encoded String var1, @PathParam(value="sha") @Encoded String var2);

    @Override
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects/{projectId}/merge_requests/{mergeRequestId}/merge")
    public void acceptMergeRequest(@PathParam(value="projectId") @Encoded Integer var1, @PathParam(value="mergeRequestId") @Encoded Integer var2, @FormParam(value="merge_commit_message") String var3, @FormParam(value="should_remove_source_branch") Boolean var4);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects/{projectId}/merge_requests/{mergeRequestId}/notes")
    public void createMergeRequestNote(@PathParam(value="projectId") @Encoded Integer var1, @PathParam(value="mergeRequestId") @Encoded Integer var2, @FormParam(value="body") String var3);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects/{projectId}/merge_requests/{mergeRequestId}/award_emoji")
    public List<Awardable> getMergeRequestEmoji(@PathParam(value="projectId") @Encoded Integer var1, @PathParam(value="mergeRequestId") @Encoded Integer var2);

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects/{projectId}/merge_requests/{mergeRequestId}/award_emoji")
    public void awardMergeRequestEmoji(@PathParam(value="projectId") @Encoded Integer var1, @PathParam(value="mergeRequestId") @Encoded Integer var2, @QueryParam(value="name") String var3);

    @Override
    @DELETE
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/projects/{projectId}/merge_requests/{mergeRequestId}/award_emoji/{awardId}")
    public void deleteMergeRequestEmoji(@PathParam(value="projectId") @Encoded Integer var1, @PathParam(value="mergeRequestId") @Encoded Integer var2, @PathParam(value="awardId") @Encoded Integer var3);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/projects/{projectId}/merge_requests")
    public List<MergeRequest> getMergeRequests(@PathParam(value="projectId") @Encoded String var1, @QueryParam(value="state") State var2, @QueryParam(value="page") int var3, @QueryParam(value="per_page") int var4);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/projects/{projectId}/repository/branches")
    public List<Branch> getBranches(@PathParam(value="projectId") @Encoded String var1);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/projects/{projectId}/repository/branches/{branch}")
    public Branch getBranch(@PathParam(value="projectId") @Encoded String var1, @PathParam(value="branch") @Encoded String var2);

    @Override
    @HEAD
    @Produces(value={"application/json"})
    @Path(value="/user")
    public void headCurrentUser();

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/user")
    public User getCurrentUser();

    @Override
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/users")
    public User addUser(@FormParam(value="email") String var1, @FormParam(value="username") String var2, @FormParam(value="name") String var3, @FormParam(value="password") String var4);

    @Override
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/users/{userId}")
    public User updateUser(@PathParam(value="userId") @Encoded String var1, @FormParam(value="email") String var2, @FormParam(value="username") String var3, @FormParam(value="name") String var4, @FormParam(value="password") String var5);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/projects/{projectId}/labels")
    public List<Label> getLabels(@PathParam(value="projectId") @Encoded String var1);

    @Override
    @GET
    @Produces(value={"application/json"})
    @Path(value="/projects/{projectId}/pipelines")
    public List<Pipeline> getPipelines(@PathParam(value="projectId") @Encoded String var1);
}

