/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource.helpers;

import hudson.init.Initializer;
import java.util.NoSuchElementException;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.kohsuke.stapler.Stapler;

public final class GitLabIcons {
    public static final String ICON_PROJECT = "gitlab-project";
    public static final String ICON_BRANCH = "gitlab-branch";
    public static final String ICON_GITLAB = "gitlab-logo";
    public static final String ICON_COMMIT = "gitlab-commit";
    public static final String ICON_MR = "gitlab-mr";
    public static final String ICON_TAG = "gitlab-tag";
    private static final String ICON_PATH = "plugin/gitlab-branch-source/images/";

    private GitLabIcons() {
    }

    @Initializer
    public static void initialize() {
        GitLabIcons.addIcon(ICON_GITLAB);
        GitLabIcons.addIcon(ICON_PROJECT);
        GitLabIcons.addIcon(ICON_BRANCH);
        GitLabIcons.addIcon(ICON_COMMIT);
        GitLabIcons.addIcon(ICON_MR);
        GitLabIcons.addIcon(ICON_TAG);
    }

    public static String iconFileName(String name, Size size) {
        Icon icon = IconSet.icons.getIconByClassSpec((Object)GitLabIcons.classSpec(name, size));
        if (icon == null) {
            return null;
        }
        JellyContext ctx = new JellyContext();
        ctx.setVariable("resURL", (Object)(Stapler.getCurrentRequest2().getContextPath() + Jenkins.RESOURCE_PATH));
        return icon.getQualifiedUrl(ctx);
    }

    public static String iconFilePathPattern(String name) {
        return ICON_PATH + name + ".svg";
    }

    private static String classSpec(String name, Size size) {
        return name + " " + size.className;
    }

    private static void addIcon(String name) {
        for (Size size : Size.values()) {
            IconSet.icons.addIcon(new Icon(GitLabIcons.classSpec(name, size), "plugin/gitlab-branch-source/images//" + name + ".svg", size.style));
        }
    }

    public static enum Size {
        SMALL("icon-sm", "16x16", "width: 16px; height: 16px;"),
        MEDIUM("icon-md", "24x24", "width: 24px; height: 24px;"),
        LARGE("icon-lg", "32x32", "width: 32px; height: 32px;"),
        XLARGE("icon-xlg", "48x48", "width: 48px; height: 48px;");

        private final String className;
        private final String dimensions;
        private final String style;

        private Size(String className, String dimensions, String style) {
            this.className = className;
            this.dimensions = dimensions;
            this.style = style;
        }

        public static Size byDimensions(String dimensions) {
            for (Size s : Size.values()) {
                if (!s.dimensions.equals(dimensions)) continue;
                return s;
            }
            throw new NoSuchElementException("unknown dimensions: " + dimensions);
        }
    }
}

