/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import io.jenkins.plugins.gitlabbranchsource.Messages;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class LogCommentTrait
extends SCMSourceTrait {
    @NonNull
    private String sudoUser = "";
    private boolean logSuccess;

    @DataBoundConstructor
    public LogCommentTrait() {
    }

    @DataBoundSetter
    public void setLogSuccess(boolean logSuccess) {
        this.logSuccess = logSuccess;
    }

    @DataBoundSetter
    public void setSudoUser(@NonNull String sudoUser) {
        this.sudoUser = sudoUser;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        if (context instanceof GitLabSCMSourceContext) {
            GitLabSCMSourceContext ctx = (GitLabSCMSourceContext)context;
            ctx.withLogCommentEnabled(true);
            ctx.withLogSuccess(this.getLogSuccess());
            ctx.withSudoUser(this.getSudoUser());
        }
    }

    @NonNull
    public String getSudoUser() {
        return this.sudoUser;
    }

    public boolean getLogSuccess() {
        return this.logSuccess;
    }

    @Extension
    @Symbol(value={"logComment"})
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.LogCommentTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitLabSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitLabSCMSource.class;
        }
    }
}

