/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.gitlabbranchsource.GitLabHookRegistration;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import io.jenkins.plugins.gitlabbranchsource.Messages;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class HookRegistrationTrait
extends SCMSourceTrait {
    @NonNull
    private final GitLabHookRegistration webHookMode;
    @NonNull
    private GitLabHookRegistration systemHookMode;

    @DataBoundConstructor
    public HookRegistrationTrait(@NonNull String webHookMode, @NonNull String systemHookMode) {
        this(GitLabHookRegistration.valueOf(webHookMode), GitLabHookRegistration.valueOf(systemHookMode));
    }

    public HookRegistrationTrait(@NonNull GitLabHookRegistration webHookMode, @NonNull GitLabHookRegistration systemHookMode) {
        this.webHookMode = webHookMode;
        this.systemHookMode = systemHookMode;
    }

    @NonNull
    public final GitLabHookRegistration getWebHookMode() {
        return this.webHookMode;
    }

    @NonNull
    public final GitLabHookRegistration getSystemHookMode() {
        return this.systemHookMode;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GitLabSCMSourceContext ctx = (GitLabSCMSourceContext)context;
        ctx.webhookRegistration(this.getWebHookMode());
        ctx.systemhookRegistration(this.getSystemHookMode());
    }

    @Symbol(value={"gitLabHookRegistration"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.HookRegistrationTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitLabSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitLabSCMSource.class;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillWebHookModeItems() {
            return this.getOptions(true);
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillSystemHookModeItems() {
            return this.getOptions(false);
        }

        private ListBoxModel getOptions(boolean isWebHook) {
            ListBoxModel result = new ListBoxModel();
            String pronoun = isWebHook ? "Web Hook" : "System Hook";
            result.add(Messages.HookRegistrationTrait_disable(pronoun), GitLabHookRegistration.DISABLE.toString());
            result.add(Messages.HookRegistrationTrait_useSystem(pronoun), GitLabHookRegistration.SYSTEM.toString());
            result.add(Messages.HookRegistrationTrait_useItem(pronoun), GitLabHookRegistration.ITEM.toString());
            return result;
        }
    }
}

