/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.HttpResponses;
import io.jenkins.plugins.gitlabbranchsource.GitLabWebHookListener;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServer;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServers;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.lang3.StringUtils;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.WebHookManager;
import org.gitlab4j.api.webhook.WebHookListener;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public final class GitLabWebHookAction
extends CrumbExclusion
implements UnprotectedRootAction {
    public static final Logger LOGGER = Logger.getLogger(GitLabWebHookAction.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "gitlab-webhook";
    }

    public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/" + this.getUrlName() + "/post")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return true;
        }
        return false;
    }

    public HttpResponse doPost(StaplerRequest2 request) throws IOException, GitLabApiException {
        if (!request.getMethod().equals("POST")) {
            return HttpResponses.error((int)400, (String)("Only POST requests are supported, this was a " + request.getMethod() + " request"));
        }
        if (!"application/json".equals(request.getContentType())) {
            return HttpResponses.error((int)400, (String)("Only application/json content is supported, this was " + request.getContentType()));
        }
        String type = request.getHeader("X-Gitlab-Event");
        if (StringUtils.isBlank((CharSequence)type)) {
            return HttpResponses.error((int)400, (String)"Expecting a GitLab event, missing expected X-Gitlab-Event header");
        }
        String secretToken = request.getHeader("X-Gitlab-Token");
        if (!this.isValidToken(secretToken)) {
            return HttpResponses.error((int)401, (String)"Expecting a valid secret token");
        }
        String origin = SCMEvent.originOf((HttpServletRequest)request);
        WebHookManager webHookManager = new WebHookManager();
        webHookManager.addListener((WebHookListener)new GitLabWebHookListener(origin));
        webHookManager.handleEvent((HttpServletRequest)request);
        return HttpResponses.ok();
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="MessageDigest.isEqual does handle null and spotbugs is wrong")
    private boolean isValidToken(String secretToken) {
        try {
            List<GitLabServer> servers = GitLabServers.get().getServers();
            byte[] secretTokenBytes = secretToken != null ? secretToken.getBytes(StandardCharsets.UTF_8) : null;
            for (GitLabServer server : servers) {
                byte[] secretTokenAsPlainTextBytes;
                String secretTokenAsPlainText = server.getSecretTokenAsPlainText();
                byte[] byArray = secretTokenAsPlainTextBytes = secretTokenAsPlainText != null ? secretTokenAsPlainText.getBytes(StandardCharsets.UTF_8) : null;
                if (!MessageDigest.isEqual(secretTokenBytes, secretTokenAsPlainTextBytes) && (secretTokenAsPlainText == null || !secretTokenAsPlainText.isEmpty() || secretToken != null)) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Error while validating token: %s", e.getMessage()));
        }
        return false;
    }
}

