/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import io.jenkins.plugins.gitlabbranchsource.GitLabProjectSCMEvent;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMSourceEvent;
import org.gitlab4j.api.systemhooks.GroupSystemHookEvent;
import org.gitlab4j.api.systemhooks.ProjectSystemHookEvent;
import org.gitlab4j.api.systemhooks.SystemHookListener;

public class GitLabSystemHookListener
implements SystemHookListener {
    public static final Logger LOGGER = Logger.getLogger(GitLabSystemHookListener.class.getName());
    private String origin;

    public GitLabSystemHookListener(String origin) {
        this.origin = origin;
    }

    public void onProjectEvent(ProjectSystemHookEvent projectSystemHookEvent) {
        LOGGER.log(Level.FINE, projectSystemHookEvent.toString());
        switch (projectSystemHookEvent.getEventName()) {
            case "project_create": 
            case "project_destroy": 
            case "project_update": {
                GitLabProjectSCMEvent trigger = new GitLabProjectSCMEvent(projectSystemHookEvent, this.origin);
                SCMSourceEvent.fireLater((SCMSourceEvent)trigger, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, String.format("unsupported System hook event: %s", projectSystemHookEvent.getEventName().toString()));
            }
        }
    }

    public void onGroupEvent(GroupSystemHookEvent groupSystemHookEvent) {
        LOGGER.log(Level.FINE, groupSystemHookEvent.toString());
    }
}

