/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.TaskListener;
import io.jenkins.plugins.gitlabbranchsource.BranchSCMHead;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import io.jenkins.plugins.gitlabbranchsource.GitLabTagSCMHead;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMHead;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.models.AccessLevel;
import org.gitlab4j.api.models.Branch;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.Tag;

public class GitLabSCMSourceRequest
extends SCMSourceRequest {
    public static final Logger LOGGER = Logger.getLogger(GitLabSCMSourceRequest.class.getName());
    private final boolean fetchBranches;
    private final boolean fetchTags;
    private final boolean fetchOriginMRs;
    private final boolean fetchForkMRs;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> originMRStrategies;
    @NonNull
    private final Set<ChangeRequestCheckoutStrategy> forkMRStrategies;
    @CheckForNull
    private final Set<Long> requestedMergeRequestNumbers;
    @CheckForNull
    private final Set<String> requestedOriginBranchNames;
    @CheckForNull
    private final Set<String> requestedTagNames;
    @CheckForNull
    private Iterable<MergeRequest> mergeRequests;
    @CheckForNull
    private Iterable<Branch> branches;
    @CheckForNull
    private Iterable<Tag> tags;
    private HashMap<String, AccessLevel> members = new HashMap();
    @CheckForNull
    private Project gitlabProject;
    @CheckForNull
    private GitLabApi gitLabApi;

    GitLabSCMSourceRequest(SCMSource source, GitLabSCMSourceContext context, TaskListener listener) {
        super(source, (SCMSourceContext)context, listener);
        this.fetchBranches = context.wantBranches();
        this.fetchTags = context.wantTags();
        this.fetchOriginMRs = context.wantOriginMRs();
        this.fetchForkMRs = context.wantForkMRs();
        this.originMRStrategies = this.fetchOriginMRs && !context.originMRStrategies().isEmpty() ? Collections.unmodifiableSet(EnumSet.copyOf(context.originMRStrategies())) : Collections.emptySet();
        this.forkMRStrategies = this.fetchForkMRs && !context.forkMRStrategies().isEmpty() ? Collections.unmodifiableSet(EnumSet.copyOf(context.forkMRStrategies())) : Collections.emptySet();
        Set includes = context.observer().getIncludes();
        if (includes != null) {
            HashSet<Long> mergeRequestNumbers = new HashSet<Long>(includes.size());
            HashSet<String> branchNames = new HashSet<String>(includes.size());
            HashSet<String> tagNames = new HashSet<String>(includes.size());
            for (SCMHead h : includes) {
                if (h instanceof BranchSCMHead) {
                    branchNames.add(h.getName());
                    continue;
                }
                if (h instanceof MergeRequestSCMHead) {
                    mergeRequestNumbers.add(Long.parseLong(((MergeRequestSCMHead)h).getId()));
                    if (!SCMHeadOrigin.DEFAULT.equals((Object)h.getOrigin())) continue;
                    branchNames.add(((MergeRequestSCMHead)h).getOriginName());
                    continue;
                }
                if (!(h instanceof GitLabTagSCMHead)) continue;
                tagNames.add(h.getName());
            }
            this.requestedMergeRequestNumbers = Collections.unmodifiableSet(mergeRequestNumbers);
            this.requestedOriginBranchNames = Collections.unmodifiableSet(branchNames);
            this.requestedTagNames = Collections.unmodifiableSet(tagNames);
        } else {
            this.requestedMergeRequestNumbers = null;
            this.requestedOriginBranchNames = null;
            this.requestedTagNames = null;
        }
    }

    public final boolean isFetchBranches() {
        return this.fetchBranches;
    }

    public final boolean isFetchTags() {
        return this.fetchTags;
    }

    public final boolean isFetchMRs() {
        return this.isFetchOriginMRs() || this.isFetchForkMRs();
    }

    public final boolean isFetchOriginMRs() {
        return this.fetchOriginMRs;
    }

    public final boolean isFetchForkMRs() {
        return this.fetchForkMRs;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getOriginMRStrategies() {
        return this.originMRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getForkMRStrategies() {
        return this.forkMRStrategies;
    }

    @NonNull
    public final Set<ChangeRequestCheckoutStrategy> getMRStrategies(boolean fork) {
        if (fork) {
            return this.fetchForkMRs ? this.getForkMRStrategies() : Collections.emptySet();
        }
        return this.fetchOriginMRs ? this.getOriginMRStrategies() : Collections.emptySet();
    }

    public final Map<Boolean, Set<ChangeRequestCheckoutStrategy>> getMRStrategies() {
        HashMap<Boolean, Set<ChangeRequestCheckoutStrategy>> result = new HashMap<Boolean, Set<ChangeRequestCheckoutStrategy>>();
        for (Boolean fork : new Boolean[]{Boolean.TRUE, Boolean.FALSE}) {
            result.put(fork, this.getMRStrategies(fork));
        }
        return result;
    }

    @CheckForNull
    public final Set<Long> getRequestedMergeRequestNumbers() {
        return this.requestedMergeRequestNumbers;
    }

    @CheckForNull
    public final Set<String> getRequestedOriginBranchNames() {
        return this.requestedOriginBranchNames;
    }

    @CheckForNull
    public final Set<String> getRequestedTagNames() {
        return this.requestedTagNames;
    }

    @NonNull
    public Iterable<MergeRequest> getMergeRequests() {
        return Util.fixNull(this.mergeRequests);
    }

    public void setMergeRequests(@CheckForNull Iterable<MergeRequest> mergeRequests) {
        this.mergeRequests = mergeRequests;
    }

    @NonNull
    public final Iterable<Branch> getBranches() {
        return Util.fixNull(this.branches);
    }

    public final void setBranches(@CheckForNull Iterable<Branch> branches) {
        this.branches = branches;
    }

    @NonNull
    public final Iterable<Tag> getTags() {
        return Util.fixNull(this.tags);
    }

    public final void setTags(@CheckForNull Iterable<Tag> tags) {
        this.tags = tags;
    }

    public final HashMap<String, AccessLevel> getMembers() {
        return this.members;
    }

    public final void setMembers(@CheckForNull HashMap<String, AccessLevel> members) {
        this.members = members;
    }

    @CheckForNull
    public GitLabApi getGitLabApi() {
        return this.gitLabApi;
    }

    public void setGitLabApi(@CheckForNull GitLabApi gitLabApi) {
        this.gitLabApi = gitLabApi;
    }

    public AccessLevel getPermission(String username) {
        if (this.getMembers() == null) {
            return null;
        }
        if (this.getMembers().containsKey(username)) {
            return this.getMembers().get(username);
        }
        return null;
    }

    public boolean isMember(String username) {
        if (this.getMembers() == null) {
            throw new NullPointerException("No members! :O");
        }
        return this.getMembers().containsKey(username);
    }

    public void close() throws IOException {
        if (this.mergeRequests instanceof Closeable) {
            ((Closeable)((Object)this.mergeRequests)).close();
        }
        if (this.branches instanceof Closeable) {
            ((Closeable)((Object)this.branches)).close();
        }
        super.close();
    }

    public void setProject(Project gitlabProject) {
        this.gitlabProject = gitlabProject;
    }

    @CheckForNull
    public Project getGitlabProject() {
        return this.gitlabProject;
    }
}

