/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jenkins.scm.api.SCMFile;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.models.TreeItem;

public class GitLabSCMFile
extends SCMFile {
    private final GitLabApi gitLabApi;
    private final String projectPath;
    private final String ref;
    private boolean isDir;

    public GitLabSCMFile(GitLabApi gitLabApi, String projectPath, String ref) {
        this.gitLabApi = gitLabApi;
        this.isDir = true;
        this.type(SCMFile.Type.DIRECTORY);
        this.projectPath = projectPath;
        this.ref = ref;
    }

    private GitLabSCMFile(@NonNull GitLabSCMFile parent, String name, boolean isDir) {
        super((SCMFile)parent, name);
        this.gitLabApi = parent.gitLabApi;
        this.projectPath = parent.projectPath;
        this.ref = parent.ref;
        this.isDir = isDir;
    }

    private GitLabSCMFile(GitLabSCMFile parent, String name, SCMFile.Type type) {
        super((SCMFile)parent, name);
        this.gitLabApi = parent.gitLabApi;
        this.projectPath = parent.projectPath;
        this.ref = parent.ref;
        this.isDir = type == SCMFile.Type.DIRECTORY;
        this.type(type);
    }

    @NonNull
    protected SCMFile newChild(@NonNull String name, boolean assumeIsDirectory) {
        return new GitLabSCMFile(this, name, assumeIsDirectory);
    }

    @NonNull
    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        if (!this.isDirectory()) {
            throw new IOException("Cannot get children from a regular file");
        }
        List<TreeItem> treeItems = this.fetchTree();
        ArrayList<SCMFile> result = new ArrayList<SCMFile>(treeItems.size());
        for (TreeItem c : treeItems) {
            SCMFile.Type t = c.getType() == TreeItem.Type.TREE ? SCMFile.Type.DIRECTORY : (c.getType() == TreeItem.Type.BLOB ? ("120000".equals(c.getMode()) ? SCMFile.Type.LINK : SCMFile.Type.REGULAR_FILE) : SCMFile.Type.OTHER);
            result.add(new GitLabSCMFile(this, c.getName(), t));
        }
        return result;
    }

    public long lastModified() throws IOException, InterruptedException {
        return 0L;
    }

    @NonNull
    protected SCMFile.Type type() throws IOException, InterruptedException {
        if (this.isDir) {
            return SCMFile.Type.DIRECTORY;
        }
        try {
            this.gitLabApi.getRepositoryFileApi().getFile((Object)this.projectPath, this.getPath(), this.ref);
            return SCMFile.Type.REGULAR_FILE;
        }
        catch (GitLabApiException e) {
            if (e.getHttpStatus() != 404) {
                throw new IOException(e);
            }
            try {
                List files = this.gitLabApi.getRepositoryApi().getTree((Object)this.projectPath, this.getPath(), this.ref);
                if (files.size() == 0) {
                    return SCMFile.Type.NONEXISTENT;
                }
                return SCMFile.Type.DIRECTORY;
            }
            catch (GitLabApiException ex) {
                if (e.getHttpStatus() != 404) {
                    throw new IOException(e);
                }
                return SCMFile.Type.NONEXISTENT;
            }
        }
    }

    @NonNull
    public InputStream content() throws IOException, InterruptedException {
        if (this.isDirectory()) {
            throw new IOException("Cannot get raw content from a directory");
        }
        return this.fetchFile();
    }

    private InputStream fetchFile() throws IOException {
        try {
            return this.gitLabApi.getRepositoryFileApi().getRawFile((Object)this.projectPath, this.ref, this.getPath());
        }
        catch (GitLabApiException e) {
            throw new IOException(String.format("%s not found at %s", this.getPath(), this.ref));
        }
    }

    private List<TreeItem> fetchTree() throws IOException {
        try {
            return this.gitLabApi.getRepositoryApi().getTree((Object)this.projectPath, this.getPath(), this.ref);
        }
        catch (GitLabApiException e) {
            throw new IOException(String.format("%s not found at %s", this.getPath(), this.ref));
        }
    }
}

