/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabserverconfig.credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.gitlabserverconfig.credentials.GroupAccessToken;
import io.jenkins.plugins.gitlabserverconfig.credentials.Messages;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class GroupAccessTokenImpl
extends BaseStandardCredentials
implements GroupAccessToken {
    @Nullable
    private Secret token;

    @DataBoundConstructor
    public GroupAccessTokenImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description) {
        super(scope, id, description);
    }

    @Override
    @NonNull
    public Secret getToken() {
        return this.token;
    }

    @DataBoundSetter
    public void setToken(String token) {
        this.token = Secret.fromString((String)token);
    }

    @NonNull
    public String getUsername() {
        return "any-value-here-is-fine";
    }

    @NonNull
    public Secret getPassword() {
        return this.token;
    }

    @Extension
    @Symbol(value={"gitlabGroupAccessToken"})
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        private static final int GITLAB_ACCESS_TOKEN_MINIMAL_LENGTH = 20;

        @NonNull
        public String getDisplayName() {
            return Messages.GroupAccessTokenImpl_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public FormValidation doCheckToken(@QueryParameter String value) {
            Jenkins.get().checkPermission(CredentialsProvider.USE_OWN);
            Secret secret = Secret.fromString((String)value);
            if (StringUtils.equals((CharSequence)value, (CharSequence)secret.getPlainText()) ? value.length() < 20 : secret.getPlainText().length() < 20) {
                return FormValidation.error((String)Messages.GroupAccessTokenImpl_tokenWrongLength());
            }
            return FormValidation.ok();
        }
    }
}

