/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource.helpers;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.impl.Operator;
import hudson.ProxyConfiguration;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import io.jenkins.plugins.gitlabserverconfig.credentials.GroupAccessToken;
import io.jenkins.plugins.gitlabserverconfig.credentials.PersonalAccessToken;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServer;
import io.jenkins.plugins.gitlabserverconfig.servers.GitLabServers;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.annotations.NonNull;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.ProxyClientConfig;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class GitLabHelper {
    public static GitLabApi apiBuilder(AccessControlled context, String serverName, String credentialsId) {
        return GitLabHelper.apiBuilder(context, serverName, GitLabHelper.getCredential(credentialsId, serverName, context));
    }

    public static GitLabApi apiBuilder(AccessControlled context, String serverName, StandardCredentials credential) {
        GitLabServer server = GitLabServers.get().findServer(serverName);
        if (server != null) {
            StandardCredentials credentials = credential != null ? credential : server.getCredentials(context);
            String serverUrl = server.getServerUrl();
            String privateToken = GitLabHelper.getPrivateTokenAsPlainText(credentials);
            if (privateToken.equals("")) {
                return new GitLabApi(serverUrl, "", null, GitLabHelper.getProxyConfig(serverUrl));
            }
            return new GitLabApi(serverUrl, privateToken, null, GitLabHelper.getProxyConfig(serverUrl));
        }
        throw new IllegalStateException(String.format("No server found with the name: %s", serverName));
    }

    public static Map<String, Object> getProxyConfig(String serverUrl) {
        ProxyConfiguration proxyConfiguration = Jenkins.get().getProxy();
        if (proxyConfiguration != null) {
            URL url;
            try {
                url = new URL(serverUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
            if (!"http".equals(url.getProtocol()) && !"https".equals(url.getProtocol())) {
                return null;
            }
            List nonProxyHostPatterns = proxyConfiguration.getNoProxyHostPatterns();
            if (nonProxyHostPatterns.stream().anyMatch(p -> p.matcher(url.getHost()).matches())) {
                return null;
            }
            if (proxyConfiguration.getUserName() != null && proxyConfiguration.getSecretPassword() != null) {
                return ProxyClientConfig.createProxyClientConfig((String)("http://" + proxyConfiguration.getName() + ":" + proxyConfiguration.getPort()), (String)proxyConfiguration.getUserName(), (String)proxyConfiguration.getSecretPassword().getPlainText());
            }
            return ProxyClientConfig.createProxyClientConfig((String)("http://" + proxyConfiguration.getName() + ":" + proxyConfiguration.getPort()));
        }
        return null;
    }

    @NonNull
    public static String getServerUrlFromName(String serverName) {
        GitLabServer server = GitLabServers.get().findServer(serverName);
        return GitLabHelper.getServerUrl(server);
    }

    @NonNull
    public static String getServerUrl(GitLabServer server) {
        if (server == null) {
            return "https://gitlab.com";
        }
        String url = server.getServerUrl();
        return GitLabHelper.sanitizeUrlValue(url);
    }

    @NonNull
    private static String getServerUrl(String server) {
        if (server.startsWith("http://") || server.startsWith("https://")) {
            return GitLabHelper.sanitizeUrlValue(server);
        }
        return GitLabHelper.getServerUrlFromName(server);
    }

    private static String sanitizeUrlValue(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String getPrivateTokenAsPlainText(StandardCredentials credentials) {
        String privateToken = "";
        if (credentials != null) {
            if (credentials instanceof PersonalAccessToken) {
                privateToken = ((PersonalAccessToken)credentials).getToken().getPlainText();
            }
            if (credentials instanceof GroupAccessToken) {
                privateToken = ((GroupAccessToken)credentials).getToken().getPlainText();
            }
            if (credentials instanceof StringCredentials) {
                privateToken = ((StringCredentials)credentials).getSecret().getPlainText();
            }
        }
        return privateToken;
    }

    public static UriTemplateBuilder getUriTemplateFromServer(String server) {
        return UriTemplate.buildFromTemplate((String)GitLabHelper.getServerUrl(server));
    }

    public static UriTemplate projectUriTemplate(String serverNameOrUrl) {
        return GitLabHelper.getUriTemplateFromServer(serverNameOrUrl).template(new String[]{"{/project*}"}).build();
    }

    public static UriTemplate branchUriTemplate(String serverNameOrUrl) {
        return GitLabHelper.getUriTemplateFromServer(serverNameOrUrl).template(new String[]{"{/project*}/-/tree/{branch*}"}).build();
    }

    public static UriTemplate mergeRequestUriTemplate(String serverNameOrUrl) {
        return GitLabHelper.getUriTemplateFromServer(serverNameOrUrl).template(new String[]{"{/project*}/-/merge_requests/{iid}"}).build();
    }

    public static UriTemplate tagUriTemplate(String serverNameOrUrl) {
        return GitLabHelper.getUriTemplateFromServer(serverNameOrUrl).template(new String[]{"{/project*}/-/tree/{tag*}"}).build();
    }

    public static UriTemplate commitUriTemplate(String serverNameOrUrl) {
        return GitLabHelper.getUriTemplateFromServer(serverNameOrUrl).template(new String[]{"{/project*}/-/commit/{hash}"}).build();
    }

    public static String[] splitPath(String path) {
        return path.split(Operator.PATH.getSeparator());
    }

    public static StandardCredentials getCredential(String credentialsId, String serverName, AccessControlled context) {
        if (StringUtils.isNotBlank((CharSequence)credentialsId)) {
            if (context instanceof ItemGroup) {
                return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)((ItemGroup)context), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)((String)StringUtils.defaultIfBlank((CharSequence)GitLabHelper.getServerUrlFromName(serverName), (CharSequence)"https://gitlab.com"))).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), GitLabServer.CREDENTIALS_MATCHER}));
            }
            return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)((Item)context), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)((String)StringUtils.defaultIfBlank((CharSequence)GitLabHelper.getServerUrlFromName(serverName), (CharSequence)"https://gitlab.com"))).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), GitLabServer.CREDENTIALS_MATCHER}));
        }
        return null;
    }
}

