/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource.helpers;

import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.impl.VarSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import io.jenkins.plugins.gitlabbranchsource.helpers.GitLabHelper;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class GitLabBrowser
extends GitRepositoryBrowser {
    @DataBoundConstructor
    public GitLabBrowser(String projectUrl) {
        super(projectUrl);
    }

    public String getProjectUrl() {
        return super.getRepoUrl();
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(GitLabHelper.commitUriTemplate(this.getProjectUrl()).set("hash", (Object)changeSet.getId()).expand());
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        return this.diffLink(path);
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.diffLink(path);
        }
        return new URL(GitLabHelper.getUriTemplateFromServer(this.getProjectUrl()).literal("/blob").path(new VarSpec[]{UriTemplateBuilder.var((String)"changeSet")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"path", (boolean)true)}).build().set("changeSet", (Object)path.getChangeSet().getId()).set("path", (Object)GitLabHelper.splitPath(path.getPath())).expand());
    }

    private URL diffLink(GitChangeSet.Path path) throws IOException {
        return new URL(GitLabHelper.getUriTemplateFromServer(this.getProjectUrl()).literal("/commit").path(new VarSpec[]{UriTemplateBuilder.var((String)"changeSet")}).fragment(new VarSpec[]{UriTemplateBuilder.var((String)"diff")}).build().set("changeSet", (Object)path.getChangeSet().getId()).set("diff", (Object)("#diff-" + this.getIndexOfPath(path))).expand());
    }

    @Symbol(value={"gitLabBrowser"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "GitLab";
        }

        public GitLabBrowser newInstance(StaplerRequest2 req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            return (GitLabBrowser)((Object)req.bindJSON(GitLabBrowser.class, jsonObject));
        }
    }
}

