/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SSHCheckoutTrait
extends SCMSourceTrait {
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public SSHCheckoutTrait(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @CheckForNull
    public final String getCredentialsId() {
        return this.credentialsId;
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        ((GitSCMBuilder)builder).withCredentials(this.credentialsId);
    }

    @Symbol(value={"gitLabSshCheckout"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Checkout over SSH";
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitLabSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitLabSCMSource.class;
        }

        public Class<? extends SCM> getScmClass() {
            return GitSCM.class;
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String serverUrl, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (context == null) {
                if (!Jenkins.get().hasPermission(Jenkins.MANAGE)) {
                    result.includeCurrentValue(credentialsId);
                    return result;
                }
            } else if (!context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                result.includeCurrentValue(credentialsId);
                return result;
            }
            result.includeEmptyValue();
            result.includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class));
            return result;
        }
    }
}

