/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceContext;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSourceRequest;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMHead;
import io.jenkins.plugins.gitlabbranchsource.MergeRequestSCMRevision;
import io.jenkins.plugins.gitlabbranchsource.Messages;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMHeadAuthorityDescriptor;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.trait.Discovery;
import org.gitlab4j.api.models.AccessLevel;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ForkMergeRequestDiscoveryTrait
extends SCMSourceTrait {
    private final int strategyId;
    @NonNull
    private final SCMHeadAuthority<? super GitLabSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision> trust;
    private boolean buildMRForksNotMirror = false;

    @DataBoundConstructor
    public ForkMergeRequestDiscoveryTrait(int strategyId, @NonNull SCMHeadAuthority<? super GitLabSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision> trust, boolean buildMRForksNotMirror) {
        this.strategyId = strategyId;
        this.trust = trust;
        this.buildMRForksNotMirror = buildMRForksNotMirror;
    }

    public ForkMergeRequestDiscoveryTrait(@NonNull Set<ChangeRequestCheckoutStrategy> strategies, @NonNull SCMHeadAuthority<? super GitLabSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision> trust, boolean buildMRForksNotMirror) {
        this((strategies.contains(ChangeRequestCheckoutStrategy.MERGE) ? 1 : 0) + (strategies.contains(ChangeRequestCheckoutStrategy.HEAD) ? 2 : 0), trust, buildMRForksNotMirror);
    }

    public int getStrategyId() {
        return this.strategyId;
    }

    @NonNull
    public Set<ChangeRequestCheckoutStrategy> getStrategies() {
        switch (this.strategyId) {
            case 1: {
                return EnumSet.of(ChangeRequestCheckoutStrategy.MERGE);
            }
            case 2: {
                return EnumSet.of(ChangeRequestCheckoutStrategy.HEAD);
            }
            case 3: {
                return EnumSet.of(ChangeRequestCheckoutStrategy.HEAD, ChangeRequestCheckoutStrategy.MERGE);
            }
        }
        return EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
    }

    @NonNull
    public SCMHeadAuthority<? super GitLabSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision> getTrust() {
        return this.trust;
    }

    public boolean getBuildMRForksNotMirror() {
        return this.buildMRForksNotMirror;
    }

    @DataBoundSetter
    public void setBuildMRForksNotMirror(boolean buildMRForksNotMirror) {
        this.buildMRForksNotMirror = buildMRForksNotMirror;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GitLabSCMSourceContext ctx = (GitLabSCMSourceContext)context;
        ctx.wantForkMRs(true);
        ctx.withAuthority(this.trust);
        ctx.withForkMRStrategies(this.getStrategies());
        ctx.withBuildMRForksNotMirror(this.getBuildMRForksNotMirror());
    }

    public boolean includeCategory(@NonNull SCMHeadCategory category) {
        return category instanceof ChangeRequestSCMHeadCategory;
    }

    public static class TrustEveryone
    extends SCMHeadAuthority<SCMSourceRequest, ChangeRequestSCMHead2, SCMRevision> {
        @DataBoundConstructor
        public TrustEveryone() {
        }

        protected boolean checkTrusted(@NonNull SCMSourceRequest request, @NonNull ChangeRequestSCMHead2 head) {
            return true;
        }

        @Symbol(value={"gitLabTrustEveryone"})
        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            @NonNull
            public String getDisplayName() {
                return Messages.ForkMergeRequestDiscoveryTrait_everyoneDisplayName();
            }

            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Fork.class.isAssignableFrom(originClass);
            }
        }
    }

    public static class TrustPermission
    extends SCMHeadAuthority<GitLabSCMSourceRequest, MergeRequestSCMHead, MergeRequestSCMRevision> {
        @DataBoundConstructor
        public TrustPermission() {
        }

        protected boolean checkTrusted(@NonNull GitLabSCMSourceRequest request, @NonNull MergeRequestSCMHead head) {
            AccessLevel permission;
            if (!head.getOrigin().equals((Object)SCMHeadOrigin.DEFAULT) && (permission = request.getPermission(head.getOriginOwner())) != null) {
                switch (permission) {
                    case MAINTAINER: 
                    case DEVELOPER: 
                    case OWNER: {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        @Symbol(value={"gitLabTrustPermissions"})
        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            @NonNull
            public String getDisplayName() {
                return Messages.ForkMergeRequestDiscoveryTrait_permissionsDisplayName();
            }

            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Fork.class.isAssignableFrom(originClass);
            }
        }
    }

    public static class TrustMembers
    extends SCMHeadAuthority<GitLabSCMSourceRequest, MergeRequestSCMHead, MergeRequestSCMRevision> {
        @DataBoundConstructor
        public TrustMembers() {
        }

        protected boolean checkTrusted(@NonNull GitLabSCMSourceRequest request, @NonNull MergeRequestSCMHead head) {
            if (head.getOrigin().equals((Object)SCMHeadOrigin.DEFAULT)) {
                return false;
            }
            assert (request.getMembers() != null);
            return request.isMember(head.getOriginOwner());
        }

        @Symbol(value={"gitLabTrustMembers"})
        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            @NonNull
            public String getDisplayName() {
                return Messages.ForkMergeRequestDiscoveryTrait_contributorsDisplayName();
            }

            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Fork.class.isAssignableFrom(originClass);
            }
        }
    }

    public static class TrustNobody
    extends SCMHeadAuthority<SCMSourceRequest, ChangeRequestSCMHead2, SCMRevision> {
        @DataBoundConstructor
        public TrustNobody() {
        }

        public boolean checkTrusted(@NonNull SCMSourceRequest request, @NonNull ChangeRequestSCMHead2 head) {
            return false;
        }

        @Symbol(value={"gitLabTrustNobody"})
        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Fork.class.isAssignableFrom(originClass);
            }

            @NonNull
            public String getDisplayName() {
                return Messages.ForkMergeRequestDiscoveryTrait_nobodyDisplayName();
            }
        }
    }

    @Symbol(value={"gitLabForkDiscovery"})
    @Extension
    @Discovery
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ForkMergeRequestDiscoveryTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitLabSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GitLabSCMSource.class;
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public ListBoxModel doFillStrategyIdItems() {
            ListBoxModel result = new ListBoxModel();
            result.add(Messages.ForkMergeRequestDiscoveryTrait_mergeOnly(), "1");
            result.add(Messages.ForkMergeRequestDiscoveryTrait_headOnly(), "2");
            result.add(Messages.ForkMergeRequestDiscoveryTrait_headAndMerge(), "3");
            return result;
        }

        @NonNull
        public List<SCMHeadAuthorityDescriptor> getTrustDescriptors() {
            return SCMHeadAuthority._for(GitLabSCMSourceRequest.class, MergeRequestSCMHead.class, MergeRequestSCMRevision.class, (Class[])new Class[]{SCMHeadOrigin.Fork.class});
        }

        @NonNull
        public SCMHeadAuthority<?, ?, ?> getDefaultTrust() {
            return new TrustPermission();
        }
    }
}

