/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.gitlabbranchsource;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMNavigator;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.gitlabbranchsource.GitLabWebHookCause;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.gitlab4j.api.webhook.AbstractPushEvent;

public abstract class AbstractGitLabSCMHeadEvent<E>
extends SCMHeadEvent<E> {
    public static final Logger LOGGER = Logger.getLogger(AbstractGitLabSCMHeadEvent.class.getName());
    private static final Pattern NONE_HASH_PATTERN = Pattern.compile("^0+$");

    static <E extends AbstractPushEvent> SCMEvent.Type typeOf(E pushEvent) {
        SCMEvent.Type result;
        boolean hasBefore = AbstractGitLabSCMHeadEvent.isPresent(pushEvent.getBefore());
        boolean hasAfter = AbstractGitLabSCMHeadEvent.isPresent(pushEvent.getAfter());
        if (hasBefore && hasAfter) {
            result = SCMEvent.Type.UPDATED;
        } else if (hasAfter) {
            result = SCMEvent.Type.CREATED;
        } else if (hasBefore) {
            result = SCMEvent.Type.REMOVED;
        } else {
            LOGGER.warning("Received push event with both \"before\" and \"after\" set to non-existing revision. Assuming removal.");
            result = SCMEvent.Type.REMOVED;
        }
        return result;
    }

    private static boolean isPresent(String ref) {
        return !NONE_HASH_PATTERN.matcher(ref).matches();
    }

    public AbstractGitLabSCMHeadEvent(SCMEvent.Type type, E createEvent, String origin) {
        super(type, createEvent, origin);
    }

    public boolean isMatch(@NonNull SCMNavigator navigator) {
        return navigator instanceof GitLabSCMNavigator && this.isMatch((GitLabSCMNavigator)navigator);
    }

    public abstract boolean isMatch(@NonNull GitLabSCMNavigator var1);

    public boolean isMatch(@NonNull SCMSource source) {
        return source instanceof GitLabSCMSource && this.isMatch((GitLabSCMSource)source);
    }

    public abstract boolean isMatch(@NonNull GitLabSCMSource var1);

    @NonNull
    public final Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
        HashMap<SCMHead, SCMRevision> heads = new HashMap<SCMHead, SCMRevision>();
        if (source instanceof GitLabSCMSource) {
            return this.headsFor((GitLabSCMSource)source);
        }
        return heads;
    }

    public boolean isMatch(@NonNull SCM scm) {
        return false;
    }

    @NonNull
    protected abstract Map<SCMHead, SCMRevision> headsFor(GitLabSCMSource var1);

    public abstract GitLabWebHookCause getCause();
}

