/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github.webhook.subscriber;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.Item;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.jenkinsci.plugins.github.admin.GitHubHookRegisterProblemMonitor;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class PingGHEventSubscriber
extends GHEventsSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(PingGHEventSubscriber.class);
    @Inject
    private transient GitHubHookRegisterProblemMonitor monitor;

    @Override
    protected boolean isApplicable(Item project) {
        return false;
    }

    @Override
    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.PING, (Enum[])new GHEvent[0]);
    }

    @Override
    protected void onEvent(GHEvent event, String payload) {
        GHEventPayload.Ping ping;
        try {
            ping = (GHEventPayload.Ping)GitHub.offline().parseEventPayload((Reader)new StringReader(payload), GHEventPayload.Ping.class);
        }
        catch (IOException e) {
            LOGGER.warn("Received malformed PingEvent: " + payload, (Throwable)e);
            return;
        }
        GHRepository repository = ping.getRepository();
        if (repository != null) {
            LOGGER.info("{} webhook received from repo <{}>!", (Object)event, (Object)repository.getHtmlUrl());
            this.monitor.resolveProblem(GitHubRepositoryName.create(repository.getHtmlUrl().toExternalForm()));
        } else {
            GHOrganization organization = ping.getOrganization();
            if (organization != null) {
                LOGGER.info("{} webhook received from org <{}>!", (Object)event, (Object)organization.getUrl());
            } else {
                LOGGER.warn("{} webhook received with unexpected payload", (Object)event);
            }
        }
    }
}

